/*
 * Decompiled with CFR 0.152.
 */
package org.igv.gwas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.igv.gwas.GWASFeature;

public class GWASData {
    double minValue;
    double maxValue = -1.7976931348623157E308;
    Map<String, List<GWASFeature>> features = new HashMap<String, List<GWASFeature>>();

    public GWASData() {
        this.minValue = Double.MAX_VALUE;
    }

    void addFeature(GWASFeature f) {
        List<GWASFeature> featureList = this.features.get(f.chr);
        if (featureList == null) {
            featureList = new ArrayList<GWASFeature>();
            this.features.put(f.chr, featureList);
        }
        featureList.add(f);
        this.minValue = Math.min(this.minValue, f.value);
        this.maxValue = Math.max(this.maxValue, f.value);
    }

    Set<String> keySet() {
        return this.features.keySet();
    }

    Collection<List<GWASFeature>> values() {
        return this.features.values();
    }

    List<GWASFeature> get(String chr) {
        return this.features.get(chr);
    }

    boolean isEmpty() {
        return this.features.isEmpty();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    void finish() {
        for (List<GWASFeature> featureList : this.features.values()) {
            featureList.sort(Comparator.comparingInt(o -> o.position));
        }
    }
}

