/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome.load;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.igv.Globals;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.InMemorySequence;
import org.igv.feature.genome.load.GenbankParser;
import org.igv.feature.genome.load.GenomeConfig;
import org.igv.feature.genome.load.GenomeLoader;
import org.igv.track.FeatureTrack;
import org.igv.ui.IGV;

public class GenbankLoader
extends GenomeLoader {
    private String genomePath;

    public GenbankLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    @Override
    public Genome loadGenome() throws IOException {
        GenbankParser genbankParser = new GenbankParser(this.genomePath);
        genbankParser.readFeatures(true);
        Object name = genbankParser.getLocusName();
        String chr = genbankParser.getChr();
        if (!((String)name).equals(chr)) {
            name = (String)name + " (" + chr + ")";
        }
        byte[] seq = genbankParser.getSequence();
        InMemorySequence sequence = new InMemorySequence(chr, seq);
        GenomeConfig config = new GenomeConfig();
        config.id = chr;
        config.setName((String)name);
        config.setSequence(sequence);
        String[] aliases = genbankParser.getAliases();
        if (aliases != null) {
            ArrayList<String> aliasList = new ArrayList<String>();
            aliasList.add(chr);
            for (String a : aliases) {
                aliasList.add(a);
            }
            config.setChromAliases(Arrays.asList(aliasList));
        }
        Genome genome = new Genome(config);
        if (IGV.hasInstance() && !Globals.isHeadless()) {
            genome.getFeatureDB().addFeatures(genbankParser.getFeatures());
            FeatureTrack geneFeatureTrack = GenbankLoader.createGeneTrack(genome, genbankParser.getFeatures());
            genome.setGeneTrack(geneFeatureTrack);
        }
        return genome;
    }
}

