/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome.load;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.igv.Globals;
import org.igv.feature.Chromosome;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.util.ParsingUtils;

public class ChromSizesParser {
    private static Logger log = LogManager.getLogger(ChromSizesParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Chromosome> parse(String path) throws IOException {
        try (BufferedReader br = null;){
            String nextLine;
            br = ParsingUtils.openBufferedReader(path);
            ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
            int idx = 0;
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = Globals.whitespacePattern.split(nextLine);
                if (tokens.length >= 2) {
                    String chr = tokens[0];
                    int length = Integer.parseInt(tokens[1]);
                    chromosomes.add(new Chromosome(idx, chr, length));
                    ++idx;
                    continue;
                }
                log.warn("Unexpected # of tokens at line: " + nextLine);
            }
            ArrayList<Chromosome> arrayList = chromosomes;
            return arrayList;
        }
    }
}

