/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome;

import htsjdk.samtools.util.SequenceUtil;
import htsjdk.tribble.NamedFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.igv.feature.AbstractFeature;
import org.igv.feature.BasicFeature;
import org.igv.feature.Exon;
import org.igv.feature.IGVFeature;
import org.igv.feature.Strand;
import org.igv.feature.aa.Codon;
import org.igv.feature.genome.ChromAlias;
import org.igv.feature.genome.Genome;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.action.SearchCommand;

public class HGVS {
    private static final Logger log = LogManager.getLogger(HGVS.class);

    public static boolean isValidHGVS(String notation) {
        if (notation == null) {
            return false;
        }
        String genomic = "g\\.\\d+.*";
        String coding = "c\\.[-*]?\\d+.*";
        String nonCoding = "n\\.-?\\d+.*";
        String protein = "p\\.[A-Za-z*]*\\d+.*";
        String accessionWithOptionalGene = "^[A-Za-z0-9_.]+(?:\\([^)]+\\))?";
        return notation.matches(accessionWithOptionalGene + ":(?:" + genomic + "|" + coding + "|" + nonCoding + "|" + protein + ")$");
    }

    public static SearchCommand.SearchResult search(String hgvs, Genome genome) {
        int openIdx;
        int idx;
        String type;
        if (!HGVS.isValidHGVS(hgvs)) {
            return null;
        }
        int idxG = hgvs.indexOf(":g.");
        int idxC = hgvs.indexOf(":c.");
        int idxN = hgvs.indexOf(":n.");
        int idxP = hgvs.indexOf(":p.");
        if (idxG >= 0) {
            type = "g";
            idx = idxG;
        } else if (idxC >= 0) {
            type = "c";
            idx = idxC;
        } else if (idxN >= 0) {
            type = "n";
            idx = idxN;
        } else if (idxP >= 0) {
            type = "p";
            idx = idxP;
        } else {
            return null;
        }
        String accession = hgvs.substring(0, idx);
        if (accession.endsWith(")") && (openIdx = accession.lastIndexOf(40)) > 0) {
            accession = accession.substring(0, openIdx);
        }
        String positionPart = hgvs.substring(idx + 3);
        switch (type) {
            case "g": {
                Matcher matcher = Pattern.compile("^(\\d+)(?:_(\\d+))?").matcher(positionPart);
                if (!matcher.find()) {
                    return null;
                }
                int start = Integer.parseInt(matcher.group(1));
                String endGroup = matcher.group(2);
                int end = endGroup != null ? Integer.parseInt(endGroup) : start;
                String chr = genome.getCanonicalChrName(accession);
                return new SearchCommand.SearchResult(SearchCommand.ResultType.LOCUS, chr, start - 1, end);
            }
            case "p": {
                BasicFeature transcript = HGVS.getTranscript(genome, accession);
                if (transcript == null) {
                    return null;
                }
                Matcher pm = Pattern.compile("^[A-Za-z*]{0,3}(\\d+)(?:_[A-Za-z*]{0,3}(\\d+))?").matcher(positionPart);
                if (!pm.find()) {
                    return null;
                }
                int p1 = Integer.parseInt(pm.group(1));
                String p2Str = pm.group(2);
                int p2 = p2Str != null ? Integer.parseInt(p2Str) : p1;
                Codon codon1 = transcript.getCodon(genome, transcript.getChr(), p1);
                if (codon1 == null || !codon1.isGenomePositionsSet()) {
                    return null;
                }
                int start1 = Integer.MAX_VALUE;
                int end1 = Integer.MIN_VALUE;
                for (int gp : codon1.getGenomePositions()) {
                    start1 = Math.min(start1, gp);
                    end1 = Math.max(end1, gp);
                }
                int regionStart = start1;
                int regionEnd = end1;
                if (p2 != p1) {
                    Codon codon2 = transcript.getCodon(genome, transcript.getChr(), p2);
                    if (codon2 == null || !codon2.isGenomePositionsSet()) {
                        return null;
                    }
                    int start2 = Integer.MAX_VALUE;
                    int end2 = Integer.MIN_VALUE;
                    for (int gp : codon2.getGenomePositions()) {
                        start2 = Math.min(start2, gp);
                        end2 = Math.max(end2, gp);
                    }
                    regionStart = Math.min(start1, start2);
                    regionEnd = Math.max(end1, end2);
                }
                int halfOpenEnd = regionEnd + 1;
                return new SearchCommand.SearchResult(SearchCommand.ResultType.LOCUS, transcript.getChr(), regionStart, halfOpenEnd);
            }
            case "n": {
                BasicFeature transcript = HGVS.getTranscript(genome, accession);
                if (transcript == null) {
                    return null;
                }
                Matcher matcher = Pattern.compile("^(-?\\d+)(?:_(-?\\d+))?([+-]\\d+)?").matcher(positionPart);
                if (!matcher.find()) {
                    return null;
                }
                int t1 = Integer.parseInt(matcher.group(1));
                String t2Str = matcher.group(2);
                int t2 = t2Str != null ? Integer.parseInt(t2Str) : t1;
                int g1 = HGVS.transcriptPositionToGenomicPosition(transcript, t1);
                int g2 = HGVS.transcriptPositionToGenomicPosition(transcript, t2);
                if (g1 <= 0 || g2 <= 0) {
                    return null;
                }
                String offsetStr = matcher.group(3);
                if (offsetStr != null) {
                    int offset = Integer.parseInt(offsetStr);
                    if (transcript.getStrand() == Strand.NEGATIVE) {
                        offset = -offset;
                    }
                    g1 += offset;
                    g2 += offset;
                }
                int regionStart = Math.min(g1, g2);
                int regionEndInclusive = Math.max(g1, g2);
                int halfOpenEnd = regionEndInclusive + 1;
                return new SearchCommand.SearchResult(SearchCommand.ResultType.LOCUS, transcript.getChr(), regionStart, halfOpenEnd);
            }
            case "c": {
                BasicFeature transcript = HGVS.getTranscript(genome, accession);
                if (transcript != null) {
                    Matcher utr5Matcher = Pattern.compile("^-(\\d+)(?:_-(\\d+))?([+-]\\d+)?").matcher(positionPart);
                    if (utr5Matcher.find()) {
                        int n1 = Integer.parseInt(utr5Matcher.group(1));
                        String n2Str = utr5Matcher.group(2);
                        Integer n2 = n2Str != null ? Integer.valueOf(Integer.parseInt(n2Str)) : null;
                        int firstCodingGenomic = transcript.codingToGenomePosition(1);
                        if (firstCodingGenomic > 0) {
                            String offsetStr;
                            int g1;
                            int g2 = g1 = transcript.getStrand() == Strand.POSITIVE ? firstCodingGenomic - n1 : firstCodingGenomic + n1;
                            if (n2 != null) {
                                int n = g2 = transcript.getStrand() == Strand.POSITIVE ? firstCodingGenomic - n2 : firstCodingGenomic + n2;
                            }
                            if ((offsetStr = utr5Matcher.group(3)) != null) {
                                int offset = Integer.parseInt(offsetStr);
                                if (transcript.getStrand() == Strand.NEGATIVE) {
                                    offset = -offset;
                                }
                                g1 += offset;
                                g2 += offset;
                            }
                            int start = Math.min(g1, g2);
                            int endInclusive = Math.max(g1, g2);
                            int endExclusive = endInclusive + 1;
                            return new SearchCommand.SearchResult(SearchCommand.ResultType.LOCUS, transcript.getChr(), start, endExclusive);
                        }
                        return null;
                    }
                    Matcher utr3Matcher = Pattern.compile("^\\*(\\d+)(?:_\\*(\\d+))?([+-]\\d+)?").matcher(positionPart);
                    if (utr3Matcher.find()) {
                        int lastCodingGenomic;
                        int n1 = Integer.parseInt(utr3Matcher.group(1));
                        String n2Str = utr3Matcher.group(2);
                        Integer n2 = n2Str != null ? Integer.valueOf(Integer.parseInt(n2Str)) : null;
                        int codingLen = 0;
                        if (transcript.getExons() != null) {
                            for (Exon exon : transcript.getExons()) {
                                codingLen += exon.getCodingLength();
                            }
                        }
                        if (codingLen > 0 && (lastCodingGenomic = transcript.codingToGenomePosition(codingLen)) > 0) {
                            String offsetStr;
                            int g1;
                            int g2 = g1 = transcript.getStrand() == Strand.POSITIVE ? lastCodingGenomic + n1 : lastCodingGenomic - n1;
                            if (n2 != null) {
                                int n = g2 = transcript.getStrand() == Strand.POSITIVE ? lastCodingGenomic + n2 : lastCodingGenomic - n2;
                            }
                            if ((offsetStr = utr3Matcher.group(3)) != null) {
                                int offset = Integer.parseInt(offsetStr);
                                if (transcript.getStrand() == Strand.NEGATIVE) {
                                    offset = -offset;
                                }
                                g1 += offset;
                                g2 += offset;
                            }
                            int start = Math.min(g1, g2);
                            int endInclusive = Math.max(g1, g2);
                            int endExclusive = endInclusive + 1;
                            return new SearchCommand.SearchResult(SearchCommand.ResultType.LOCUS, transcript.getChr(), start, endExclusive);
                        }
                        return null;
                    }
                    Matcher cpos = Pattern.compile("^(\\d+)(?:_(\\d+))?").matcher(positionPart);
                    if (!cpos.find()) {
                        return null;
                    }
                    int c1 = Integer.parseInt(cpos.group(1));
                    String c2Str = cpos.group(2);
                    int c2 = c2Str != null ? Integer.parseInt(c2Str) : c1;
                    int g1 = transcript.codingToGenomePosition(c1);
                    int g2 = transcript.codingToGenomePosition(c2);
                    if (g1 <= 0 || g2 <= 0) {
                        return null;
                    }
                    Matcher offs = Pattern.compile("^(\\d+)([+-]\\d+)?(?:_(\\d+)([+-]\\d+)?)?").matcher(positionPart);
                    if (offs.find()) {
                        String off1Str = offs.group(2);
                        String off2Str = offs.group(4);
                        if (off1Str != null) {
                            int off1 = Integer.parseInt(off1Str);
                            if (transcript.getStrand() == Strand.NEGATIVE) {
                                off1 = -off1;
                            }
                            g1 += off1;
                        }
                        if (off2Str != null) {
                            int off2 = Integer.parseInt(off2Str);
                            if (transcript.getStrand() == Strand.NEGATIVE) {
                                off2 = -off2;
                            }
                            g2 += off2;
                        }
                    }
                    if (c2Str == null) {
                        g2 = g1;
                    }
                    int start = Math.min(g1, g2);
                    int endInclusive = Math.max(g1, g2);
                    int endExclusive = endInclusive + 1;
                    return new SearchCommand.SearchResult(SearchCommand.ResultType.LOCUS, transcript.getChr(), start, endExclusive);
                }
                return null;
            }
        }
        return null;
    }

    private static int transcriptPositionToGenomicPosition(BasicFeature transcript, int transcriptPos) {
        if (transcriptPos <= 0) {
            int d = Math.abs(transcriptPos);
            return transcript.getStrand() == Strand.POSITIVE ? transcript.getStart() - d : transcript.getEnd() + d;
        }
        List<Exon> exons = transcript.getExons();
        if (exons == null || exons.isEmpty()) {
            if (transcript.getStrand() == Strand.POSITIVE) {
                return transcript.getStart() + transcriptPos - 1;
            }
            return transcript.getEnd() - transcriptPos + 1;
        }
        boolean positive = transcript.getStrand() == Strand.POSITIVE;
        int accumulatedLength = 0;
        ArrayList<Exon> sortedExons = new ArrayList<Exon>(exons);
        if (!positive) {
            sortedExons.sort((e1, e2) -> Integer.compare(e2.getStart(), e1.getStart()));
        } else {
            sortedExons.sort(Comparator.comparingInt(AbstractFeature::getStart));
        }
        for (Exon exon : sortedExons) {
            int exonLength = exon.getEnd() - exon.getStart();
            if (accumulatedLength + exonLength >= transcriptPos) {
                int offsetInExon = transcriptPos - accumulatedLength - 1;
                if (positive) {
                    return exon.getStart() + offsetInExon;
                }
                return exon.getEnd() - offsetInExon - 1;
            }
            accumulatedLength += exonLength;
        }
        return -1;
    }

    private static BasicFeature getTranscript(Genome genome, String accession) {
        NamedFeature nf;
        IGVFeature feature = genome.getManeTranscript(accession);
        if (feature == null && genome.getFeatureDB() != null && (nf = genome.getFeatureDB().getFeature(accession)) instanceof IGVFeature) {
            feature = (IGVFeature)nf;
        }
        if (!(feature instanceof BasicFeature)) {
            return null;
        }
        return (BasicFeature)feature;
    }

    public static String createHGVSAnnotation(Genome genome, String chr, int position, byte reference, byte alternate) {
        try {
            BasicFeature transcript = genome.getManeTranscriptAt(chr, position);
            if (transcript != null && transcript.getExons() != null) {
                if (transcript.getStrand() == Strand.NEGATIVE) {
                    reference = SequenceUtil.complement((byte)reference);
                    alternate = SequenceUtil.complement((byte)alternate);
                }
                Object positionString = "";
                String transcriptName = transcript.getName();
                for (String string : transcript.getAttributes().values()) {
                    if (!string.startsWith("NM_") && !string.startsWith("NR_")) continue;
                    transcriptName = string;
                    break;
                }
                if (transcriptName != null && !transcriptName.isEmpty()) {
                    boolean positionIsInExon = false;
                    for (Exon exon : transcript.getExons()) {
                        if (position < exon.getStart() || position >= exon.getEnd()) continue;
                        positionIsInExon = true;
                        break;
                    }
                    if (positionIsInExon) {
                        int n = transcript.genomeToCodingPosition(position);
                        if (n >= 0) {
                            positionString = transcriptName + ":c." + (n + 1);
                        } else {
                            int firstCodingPos = transcript.codingToGenomePosition(1);
                            if (firstCodingPos > 0) {
                                boolean positive;
                                int codingLen = 0;
                                for (Exon exon : transcript.getExons()) {
                                    codingLen += exon.getCodingLength();
                                }
                                int lastCodingPos = transcript.codingToGenomePosition(codingLen);
                                boolean bl = positive = transcript.getStrand() == Strand.POSITIVE;
                                if (positive && position < firstCodingPos || !positive && position > firstCodingPos) {
                                    int distance = Math.abs(position - firstCodingPos);
                                    positionString = transcriptName + ":c.-" + distance;
                                } else if (positive && position >= lastCodingPos || !positive && position <= lastCodingPos) {
                                    int distance = Math.abs(position - lastCodingPos) + 1;
                                    positionString = transcriptName + ":c.*" + distance;
                                }
                            }
                        }
                    } else {
                        int n;
                        int n2 = -1;
                        int nearestCodingPos = -1;
                        int minDistance = Integer.MAX_VALUE;
                        boolean positive = transcript.getStrand() == Strand.POSITIVE;
                        for (Exon exon : transcript.getExons()) {
                            int distToEnd;
                            if (exon.getCodingLength() == 0) continue;
                            int distToStart = Math.abs(position - exon.getStart());
                            if (distToStart > 0 && distToStart < minDistance) {
                                minDistance = distToStart;
                                n = exon.getStart();
                                nearestCodingPos = transcript.genomeToCodingPosition(exon.getCdStart());
                            }
                            if ((distToEnd = Math.abs(position - (exon.getEnd() - 1))) <= 0 || distToEnd >= minDistance) continue;
                            minDistance = distToEnd;
                            n = exon.getEnd() - 1;
                            nearestCodingPos = transcript.genomeToCodingPosition(exon.getCdEnd() - 1);
                        }
                        if (nearestCodingPos >= 0) {
                            int offset = position - n;
                            if (!positive) {
                                offset = -offset;
                            }
                            String sign = offset >= 0 ? "+" : "";
                            positionString = transcriptName + ":c." + (nearestCodingPos + 1) + sign + offset;
                        }
                    }
                }
                return (String)positionString + (char)reference + ">" + (char)alternate;
            }
            ChromAlias aliasRecord = genome.getAliasRecord(chr);
            String accession = chr;
            if (aliasRecord != null) {
                for (String string : aliasRecord.values()) {
                    if (!string.startsWith("NC_") && !string.startsWith("NT_") && !string.startsWith("NW_") && !string.startsWith("NG_") && !string.startsWith("NM_") && !string.startsWith("NR_") && !string.startsWith("NP_")) continue;
                    accession = string;
                    break;
                }
            }
            return accession + ":g." + (position + 1) + (char)reference + ">" + (char)alternate;
        }
        catch (IOException e) {
            log.error("Error getting HGVS position", e);
            return null;
        }
    }
}

