/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.igv.feature.genome.ChromAlias;
import org.igv.feature.genome.Genome;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;

public class ChromAliasManager {
    private static Logger log = LogManager.getLogger(ChromAliasManager.class);
    private Map<String, String> sequenceNames = new HashMap<String, String>();
    private Genome genome;
    private Map<String, String> aliasCache;

    public ChromAliasManager(Collection<String> sequenceNames, Genome genome) {
        for (String name : sequenceNames) {
            this.sequenceNames.put(name.toLowerCase(), name);
        }
        this.aliasCache = new HashMap<String, String>();
        this.genome = genome;
    }

    public String getAliasName(String chr) {
        if (this.genome == null) {
            return chr;
        }
        try {
            String alias;
            if (!this.aliasCache.containsKey(chr)) {
                ChromAlias aliasRecord = this.genome.getAliasRecord(chr);
                if (aliasRecord == null) {
                    this.aliasCache.put(chr, null);
                } else {
                    for (String alias2 : aliasRecord.values()) {
                        String lowerCase = alias2.toLowerCase();
                        if (!this.sequenceNames.containsKey(lowerCase)) continue;
                        this.aliasCache.put(chr, this.sequenceNames.get(lowerCase));
                    }
                }
            }
            return (alias = this.aliasCache.get(chr)) != null ? alias : chr;
        }
        catch (IOException e) {
            log.error("Error loading alias file ", e);
            return chr;
        }
    }
}

