/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.dranger;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.igv.feature.AbstractFeature;
import org.igv.feature.LocusScore;
import org.igv.feature.Strand;
import org.igv.track.WindowFunction;
import org.igv.ui.color.ColorUtilities;

public class DRangerFeature
extends AbstractFeature {
    private int index;
    String chr2;
    int pos2;
    Strand str2;
    private int tumreads;
    private int normreads;
    private String featureClass;
    private int span;
    private String site1;
    private String site2;
    private int quality;
    private int score;
    Color defaultColor = Color.blue;
    static Map<String, Color> colorMap = new HashMap<String, Color>();

    public DRangerFeature() {
    }

    public DRangerFeature(String chr, int pos1, Strand strand1, String chr2, int pos2, Strand str2) {
        super(chr, pos1 - 5, pos1 + 5, strand1);
        this.chr2 = chr2;
        this.pos2 = pos2;
        this.str2 = str2;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    public LocusScore copy() {
        DRangerFeature newFeat = new DRangerFeature();
        newFeat.setChr(this.getChr());
        newFeat.setStart(this.getStart());
        newFeat.setEnd(this.getEnd());
        newFeat.chr2 = this.chr2;
        newFeat.pos2 = this.pos2;
        newFeat.str2 = this.str2;
        newFeat.tumreads = this.tumreads;
        newFeat.normreads = this.normreads;
        newFeat.featureClass = this.featureClass;
        newFeat.span = this.span;
        newFeat.site1 = this.site1;
        newFeat.site2 = this.site2;
        newFeat.quality = this.quality;
        newFeat.score = this.score;
        return newFeat;
    }

    public void setSite1(String site1) {
        this.site1 = site1;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setTumreads(int tumreads) {
        this.tumreads = tumreads;
    }

    public void setNormreads(int normreads) {
        this.normreads = normreads;
    }

    public void setFeatureClass(String featureClass) {
        this.featureClass = featureClass;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void setScore(int score) {
        this.score = score;
    }

    @Override
    public Color getColor() {
        Color baseColor = this.defaultColor;
        if (this.featureClass != null && colorMap.containsKey(this.featureClass)) {
            baseColor = colorMap.get(this.featureClass);
        }
        float alpha = Math.min(1.0f, Math.max(0.15f, 0.15f + 0.28333333f * (float)this.score));
        return ColorUtilities.getCompositeColor(baseColor, alpha);
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        StringBuffer buf = new StringBuffer();
        if (this.index > 0) {
            buf.append("Index:   " + this.index + "<br>");
        }
        if (this.site1 != null) {
            buf.append("Site1:    " + this.site1 + "<br>");
        }
        if (this.site2 != null) {
            buf.append("Site2:    " + this.site2 + "<br>");
        }
        if (this.tumreads > 0) {
            buf.append("T reads: " + this.tumreads + "<br>");
        }
        if (this.normreads > 0) {
            buf.append("N reads: " + this.normreads + "<br>");
        }
        if (this.featureClass != null) {
            buf.append("Class: " + this.featureClass + "<br>");
        }
        if (this.span > 0) {
            buf.append("Span:    " + this.span + "<br>");
        }
        if (this.quality > 0) {
            buf.append("Quality:   " + this.quality + "<br>");
        }
        if (this.score > 0) {
            buf.append("Score:   " + this.score);
        }
        return buf.toString();
    }

    public void setSite2(String site2) {
        this.site2 = site2;
    }

    static {
        colorMap.put("deletion", Color.red);
        colorMap.put("inter_chr", Color.blue);
        colorMap.put("inversion", Color.green);
        colorMap.put("long_range", Color.MAGENTA);
        colorMap.put("tandem_dup", Color.cyan);
    }
}

