/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.bionano;

import org.igv.feature.AbstractFeature;
import org.igv.feature.bionano.SMAPFeature;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.track.WindowFunction;

public class SMAPPairedFeature
extends AbstractFeature {
    private static Logger log = LogManager.getLogger(SMAPPairedFeature.class);
    SMAPFeature feature1;
    SMAPFeature feature2;
    String type;

    public SMAPPairedFeature(SMAPFeature feature1, SMAPFeature feature2) {
        if (!feature1.getChr().equals(feature2.getChr())) {
            log.error("Inter-chromosomal linked features not supported");
            return;
        }
        this.setChr(feature1.getChr());
        if (feature1.getStart() < feature2.getStart()) {
            this.feature1 = feature1;
            this.feature2 = feature2;
        } else {
            this.feature1 = feature2;
            this.feature2 = feature1;
        }
        this.setStart(Math.min(feature1.getStart(), feature2.getStart()));
        this.setEnd(Math.max(feature1.getEnd(), feature2.getEnd()));
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.feature1.getValueString(position, mouseX, windowFunction));
        buf.append("<hr>");
        buf.append(this.feature2.getValueString(position, mouseX, windowFunction));
        return buf.toString();
    }
}

