/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.basepair;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.igv.feature.FeatureUtils;
import org.igv.feature.basepair.BasePairFeature;

public class BasePairData {
    Map<String, List<BasePairFeature>> featureMap = new HashMap<String, List<BasePairFeature>>();

    public void addFeature(BasePairFeature feature) {
        String chr = feature.getChr();
        List<BasePairFeature> featureList = this.featureMap.get(chr);
        if (featureList == null) {
            featureList = new ArrayList<BasePairFeature>();
            this.featureMap.put(chr, featureList);
        }
        featureList.add(feature);
    }

    public void finish() {
        for (List<BasePairFeature> featureList : this.featureMap.values()) {
            FeatureUtils.sortFeatureList(featureList);
        }
    }

    public List<BasePairFeature> getFeatures(String chr) {
        return this.featureMap.get(chr);
    }
}

