/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.aa;

import org.igv.feature.Strand;
import org.igv.feature.aa.AminoAcid;
import org.igv.feature.genome.Genome;
import org.igv.track.SequenceTrack;

public class Codon {
    private int proteinPosition;
    private int[] genomePositions = new int[]{-1, -1, -1};
    private int nextPos = 0;
    private AminoAcid aminoAcid;
    private Strand strand;
    private int incr = 1;
    private String chr;
    private String sequence;

    Codon(String chr, int proteinPosition) {
        this(chr, proteinPosition, Strand.POSITIVE);
    }

    public Codon(String chr, int proteinPosition, Strand strand) {
        this.proteinPosition = proteinPosition;
        this.strand = strand;
        this.chr = chr;
        if (this.strand == Strand.NEGATIVE) {
            this.nextPos = 2;
            this.incr = -1;
        }
    }

    public void setNextGenomePosition(int gp) {
        try {
            this.genomePositions[this.nextPos] = gp;
            this.nextPos += this.incr;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("Genome positions have already been set, cannot set any more");
        }
    }

    public boolean isGenomePositionsSet() {
        boolean set = true;
        for (int ii : this.genomePositions) {
            set &= ii >= 0;
        }
        return set;
    }

    public void setAminoAcid(AminoAcid aa) {
        this.aminoAcid = aa;
    }

    public int getProteinPosition() {
        return this.proteinPosition;
    }

    public int[] getGenomePositions() {
        return this.genomePositions;
    }

    public AminoAcid getAminoAcid() {
        return this.aminoAcid;
    }

    public void calcSequence(Genome genome) {
        if (!this.isGenomePositionsSet()) {
            throw new IllegalStateException("Must set genome positions first");
        }
        int[] positions = this.getGenomePositions();
        Object aas = "";
        for (int start : positions) {
            byte[] nucSequence = genome.getSequence(this.chr, start, start + 1);
            if (nucSequence == null) continue;
            aas = (String)aas + new String(nucSequence);
        }
        if (this.strand == Strand.NEGATIVE) {
            aas = SequenceTrack.getReverseComplement((String)aas);
        }
        this.sequence = aas;
    }

    public String getSequence() {
        return this.sequence;
    }
}

