/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.aa;

import java.util.List;
import org.igv.feature.Strand;
import org.igv.feature.aa.CodonAA;

public class AminoAcidSequence {
    private final Strand strand;
    private final int start;
    private final List<CodonAA> sequence;
    private boolean nonNullSequence;
    private final Integer id;

    public AminoAcidSequence(Strand strand, int startPosition, List<CodonAA> sequence, Integer codonTableKey) {
        this.strand = strand;
        this.start = startPosition;
        this.sequence = sequence;
        this.id = codonTableKey;
        this.nonNullSequence = false;
        for (CodonAA aa : sequence) {
            if (aa == null) continue;
            this.nonNullSequence = true;
            break;
        }
    }

    public Strand getStrand() {
        return this.strand;
    }

    public int getStart() {
        return this.start;
    }

    public List<CodonAA> getSequence() {
        return this.sequence;
    }

    public boolean hasNonNullSequence() {
        return this.nonNullSequence;
    }

    public Integer getId() {
        return this.id;
    }

    public String getSequenceString() {
        Object ss = "";
        for (CodonAA c : this.sequence) {
            ss = (String)ss + c.getAminoAcid().getSymbol();
        }
        return ss;
    }
}

