/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.igv.Globals;
import org.igv.feature.AbstractFeatureParser;
import org.igv.feature.BasicFeature;
import org.igv.feature.Exon;
import org.igv.feature.FeatureParser;
import org.igv.feature.FeatureUtils;
import org.igv.feature.IExon;
import org.igv.feature.Locus;
import org.igv.feature.SequenceOntology;
import org.igv.feature.Strand;
import org.igv.feature.tribble.IGVBEDCodec;
import org.igv.util.ParsingUtils;
import org.igv.util.ResourceLocator;

public class FeatureFileUtils {
    public static void main(String[] args) throws IOException {
        FeatureFileUtils.splitRepeatMasker(args[0], args[1], args[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitRepeatMasker(String iFile, String outputDirectory, String prefix) throws IOException {
        BufferedReader br = null;
        HashMap<String, PrintWriter> pws = new HashMap<String, PrintWriter>();
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(iFile));
            File dir = new File(outputDirectory);
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = nextLine.split("\t");
                String repClass = tokens[11].replace("?", "");
                PrintWriter pw = (PrintWriter)pws.get(repClass);
                if (pw == null) {
                    File f = new File(dir, prefix + repClass + ".bed");
                    pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                    pws.put(repClass, pw);
                }
                pw.println(tokens[5] + "\t" + tokens[6] + "\t" + tokens[7] + "\t" + tokens[10] + "\t" + tokens[1] + "\t" + tokens[9]);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            for (PrintWriter pw : pws.values()) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void computeBedDensity(String iFile, String oFile, int windowSize, int step) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(iFile);
            pw = new PrintWriter(new BufferedWriter(new FileWriter(oFile)));
            LinkedHashMap<Integer, Window> openWindows = new LinkedHashMap<Integer, Window>();
            int lastWindowOutput = 0;
            String lastChr = null;
            while ((nextLine = br.readLine()) != null) {
                int w;
                String[] tokens;
                if (nextLine.startsWith("track") || nextLine.startsWith("#") || (tokens = Globals.tabPattern.split(nextLine)).length < 3) continue;
                String chr = tokens[0];
                int start = Integer.parseInt(tokens[1]);
                int end = Integer.parseInt(tokens[2]);
                if (!chr.equals(lastChr)) {
                    lastWindowOutput = 0;
                    for (Window window : openWindows.values()) {
                        w = window.idx;
                        int windowCenter = w * step + windowSize / 2;
                        int windowStart = windowCenter - step / 2;
                        int windowEnd = windowStart + step;
                        pw.println(lastChr + "\t" + windowStart + "\t" + windowEnd + "\t" + window.count);
                    }
                    openWindows.clear();
                    lastChr = chr;
                }
                int startWindow = start / step;
                int endWindow = (end + windowSize) / step;
                for (w = startWindow; w < endWindow; ++w) {
                    Window window = (Window)openWindows.get(w);
                    if (window == null) {
                        window = new Window(w);
                        openWindows.put(w, window);
                    }
                    window.increment();
                }
                if (startWindow <= lastWindowOutput) continue;
                for (w = lastWindowOutput; w < startWindow; ++w) {
                    Window window = (Window)openWindows.get(w);
                    if (window == null) continue;
                    int windowCenter = w * step + windowSize / 2;
                    int windowStart = windowCenter - step / 2;
                    int windowEnd = windowStart + step;
                    pw.println(chr + "\t" + windowStart + "\t" + windowEnd + "\t" + window.count);
                }
                for (w = lastWindowOutput; w < startWindow; ++w) {
                    openWindows.remove(w);
                }
                lastWindowOutput = startWindow - 1;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void probeToBed(String iFile, String oFile, boolean includeMultiMappings) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(iFile);
            pw = new PrintWriter(new FileWriter(oFile));
            br.readLine();
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = Globals.commaPattern.split(nextLine);
                String probe = tokens[0];
                if (tokens.length < 1 || tokens.length > 2 && !includeMultiMappings) continue;
                for (int i = 1; i < tokens.length; ++i) {
                    String loc = tokens[i];
                    String[] locParts = Globals.colonPattern.split(loc);
                    String chr = locParts[0];
                    int start = Integer.parseInt(locParts[1]) - 1;
                    int end = Integer.parseInt(locParts[2]);
                    String strand = locParts[3];
                    pw.println(chr + "\t" + start + "\t" + end + "\t" + probe + "\t1000\t" + strand);
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static void splitGffFileByType(String gffFile, String outputDirectory) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(gffFile));
        String ext = "." + gffFile.substring(gffFile.length() - 4);
        HashMap<Object, PrintWriter> writers = new HashMap<Object, PrintWriter>();
        while ((nextLine = br.readLine()) != null) {
            if ((nextLine = nextLine.trim()).startsWith("#")) continue;
            String[] tokens = Globals.tabPattern.split(nextLine.trim().replaceAll("\"", ""), -1);
            Object type = tokens[2];
            if (SequenceOntology.geneParts.contains(type)) {
                type = "gene";
            }
            if (writers.containsKey(type)) continue;
            writers.put(type, new PrintWriter(new FileWriter(new File(outputDirectory, (String)type + ext))));
        }
        br.close();
        br = new BufferedReader(new FileReader(gffFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if ((nextLine = nextLine.trim()).startsWith("#")) {
                for (PrintWriter pw : writers.values()) {
                    pw.println(nextLine);
                }
                continue;
            }
            String[] tokens = Globals.tabPattern.split(nextLine.trim().replaceAll("\"", ""), -1);
            String type = tokens[2];
            if (SequenceOntology.geneParts.contains(type)) {
                type = "gene";
            }
            if ((currentWriter = (PrintWriter)writers.get(type)) != null) {
                currentWriter.println(nextLine);
                continue;
            }
            System.out.println("No writer for: " + type);
        }
        br.close();
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createCanonicalGeneFile(String iFile, String outputFile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            br = new BufferedReader(new FileReader(iFile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            FeatureParser parser = AbstractFeatureParser.getInstanceFor(new ResourceLocator(iFile), null);
            List<Feature> features = parser.loadFeatures(br, null);
            IGVBEDCodec codec = new IGVBEDCodec();
            HashMap genes = new HashMap();
            for (Feature f : features) {
                BasicFeature transcript = (BasicFeature)f;
                String geneName = transcript.getName();
                ArrayList<BasicFeature> genelist = (ArrayList<BasicFeature>)genes.get(geneName);
                if (genelist == null) {
                    genelist = new ArrayList<BasicFeature>();
                    genes.put(geneName, genelist);
                }
                boolean foundOverlap = false;
                for (BasicFeature gene : genelist) {
                    if (!gene.overlaps(transcript)) continue;
                    gene.setThickStart(Math.min(gene.getThickStart(), transcript.getThickStart()));
                    gene.setThickEnd(Math.max(gene.getThickEnd(), transcript.getThickEnd()));
                    FeatureFileUtils.mergeExons(gene, transcript.getExons());
                    foundOverlap = true;
                    break;
                }
                if (foundOverlap) continue;
                genelist.add(transcript);
            }
            for (List geneList : genes.values()) {
                for (BasicFeature gene : geneList) {
                    pw.println(codec.encode(gene));
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createTSSFile(String iFile, String outputFile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            br = new BufferedReader(new FileReader(iFile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            FeatureParser parser = AbstractFeatureParser.getInstanceFor(new ResourceLocator(iFile), null);
            List<Feature> features = parser.loadFeatures(br, null);
            IGVBEDCodec codec = new IGVBEDCodec();
            HashMap genes = new HashMap();
            int lastTSS = -1;
            for (Feature f : features) {
                BasicFeature transcript = (BasicFeature)f;
                int tss = transcript.getStrand() == Strand.POSITIVE ? f.getStart() : f.getEnd();
                if (tss == lastTSS) continue;
                int tssEnd = transcript.getStrand() == Strand.POSITIVE ? tss + 20 : tss - 20;
                pw.println(transcript.getChr() + "\t" + Math.min(tss, tssEnd) + "\t" + Math.max(tss, tssEnd));
                lastTSS = tss;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refgeneToBed(String iFile, String outputFile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(iFile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
                    pw.println(nextLine);
                    continue;
                }
                String[] tokens = Globals.whitespacePattern.split(nextLine);
                String chr = tokens[2];
                int start = Integer.parseInt(tokens[4]);
                String end = tokens[5];
                String name = tokens[12];
                String score = "1000";
                String strand = tokens[3];
                String thickStart = tokens[6];
                String thickEnd = tokens[7];
                String itemRGB = ".";
                int blockCount = Integer.parseInt(tokens[8]);
                String exonStarts = tokens[9];
                String[] stok = Globals.commaPattern.split(exonStarts);
                String[] etok = Globals.commaPattern.split(tokens[10]);
                Object blockStarts = "";
                Object blockSizes = "";
                for (int i = 0; i < blockCount; ++i) {
                    int bs = Integer.parseInt(stok[i]);
                    blockStarts = (String)blockStarts + String.valueOf(bs - start);
                    blockSizes = (String)blockSizes + String.valueOf(Integer.parseInt(etok[i]) - bs);
                    if (i == blockCount - 1) continue;
                    blockStarts = (String)blockStarts + ",";
                    blockSizes = (String)blockSizes + ",";
                }
                pw.println(chr + "\t" + start + "\t" + end + "\t" + name + "\t" + score + "\t" + strand + "\t" + thickStart + "\t" + thickEnd + "\t" + itemRGB + "\t" + blockCount + "\t" + (String)blockSizes + "\t" + (String)blockStarts);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static void mergeExons(BasicFeature gene, List<Exon> exons) {
        HashSet<Exon> exonProxies = new HashSet<Exon>(gene.getExons());
        for (Exon exon : gene.getExons()) {
            exonProxies.add((Exon)Exon.getExonProxy(exon));
        }
        for (Exon exon : exons) {
            IExon proxy = Exon.getExonProxy(exon);
            if (exonProxies.contains(proxy)) continue;
            gene.addExon(exon);
        }
        FeatureUtils.sortFeatureList(gene.getExons());
    }

    static void covertProbeMapToBedFile(String probeMapFile, String bedFile) throws FileNotFoundException, IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(probeMapFile));
        PrintWriter pw = new PrintWriter(new FileWriter(bedFile));
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            Locus locus = Locus.fromString(tokens[1].trim());
            pw.println(locus.getChr() + "\t" + locus.getStart() + "\t" + locus.getEnd() + "\t" + tokens[0].trim());
        }
        br.close();
        pw.close();
    }

    static void splitEmblFileByType(String emblFile, String outputDirectory) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(emblFile));
        HashSet<String> codes = new HashSet<String>();
        while ((nextLine = br.readLine()) != null) {
            String code;
            if (!nextLine.startsWith("FT") || nextLine.length() <= 19 || (code = nextLine.substring(5, 19).trim()).length() <= 0) continue;
            codes.add(code);
        }
        br.close();
        HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
        for (String string : codes) {
            writers.put(string, new PrintWriter(new FileWriter(new File(outputDirectory, string + ".embl"))));
        }
        br = new BufferedReader(new FileReader(emblFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.startsWith("ID")) {
                for (PrintWriter pw : writers.values()) {
                    pw.println(nextLine);
                }
                continue;
            }
            if (nextLine.startsWith("FT")) {
                String string = nextLine.substring(5, 19).trim();
                if (string.length() > 0) {
                    currentWriter = (PrintWriter)writers.get(string);
                }
                if (currentWriter == null) continue;
                currentWriter.println(nextLine);
                continue;
            }
            currentWriter = null;
        }
        br.close();
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
    }

    static void createImports(String inputFile, String outputFile, String genome, String source, String table) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            pw.println("INSERT INTO " + table + "(GENOME, CHR, LOCUSSTART, LOCUSEND, NAME, SOURCE) VALUES('" + genome + "', '" + tokens[2] + "', " + tokens[4] + ", " + tokens[5] + ", '" + tokens[12] + "', '" + source + "');");
        }
        br.close();
        pw.close();
    }

    static class Window {
        int idx;
        int count;

        Window(int idx) {
            this.idx = idx;
        }

        void increment() {
            ++this.count;
        }
    }
}

