/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.igv.feature.AbstractFeatureParser;
import org.igv.feature.FeatureParser;
import org.igv.feature.genome.Genome;
import org.igv.track.TrackProperties;
import org.igv.util.ResourceLocator;

public class DataURLParser {
    List<Feature> features;
    TrackProperties trackProperties;

    public List<Feature> parseFeatures(String dataURL, String format, Genome genome) {
        if (!dataURL.startsWith("data:")) {
            throw new Error("Not a dataURL: " + dataURL);
        }
        int commaIndex = dataURL.indexOf(44);
        if (commaIndex < 0) {
            throw new Error("dataURL missing commas");
        }
        String contents = URLDecoder.decode(dataURL.substring(commaIndex + 1), StandardCharsets.UTF_8);
        ResourceLocator locator = new ResourceLocator("");
        locator.setFormat(format);
        FeatureParser fp = AbstractFeatureParser.getInstanceFor(locator, genome);
        if (fp == null) {
            throw new Error("Unsupported format: " + format);
        }
        BufferedReader reader = new BufferedReader(new StringReader(contents));
        this.features = fp.loadFeatures(reader, genome);
        this.trackProperties = fp.getTrackProperties();
        return this.features;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public static String createDataURL(File file) throws IOException {
        String actual = Files.readString(Paths.get(file.getAbsolutePath(), new String[0]));
        return "data:," + URLEncoder.encode(actual, "utf-8");
    }
}

