/*
 * Decompiled with CFR 0.152.
 */
package org.igv.exceptions;

import java.io.IOException;

public class HttpResponseException
extends IOException {
    int statusCode;
    String message;
    String details;

    public HttpResponseException(int statusCode, String message, String details) {
        this.statusCode = statusCode;
        this.details = details;
        if (message != null && message.length() > 0) {
            this.message = message;
        } else {
            switch (statusCode) {
                case 407: {
                    this.message = "Proxy authentication required (status code " + statusCode + ")";
                }
                case 403: {
                    this.message = "Access Forbidden (status code " + statusCode + ")";
                }
                case 404: {
                    this.message = "File not found (status code " + statusCode + ")";
                }
                case 401: {
                    this.message = "Not authorized (status code " + statusCode + ")";
                }
            }
            this.message = "HTTP access error (status code " + statusCode + ")";
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        if (this.details == null) {
            return this.message;
        }
        return this.message + " <br> " + this.details;
    }
}

