/*
 * Decompiled with CFR 0.152.
 */
package org.igv.encode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.igv.encode.FileRecord;
import org.igv.ui.IGV;

public class TrackChooserModel
extends AbstractTableModel {
    private String[] columnHeadings;
    private List<FileRecord> records;
    private final TableRowSorter<TrackChooserModel> sorter;

    public TrackChooserModel(List<String> headings, List<FileRecord> records) {
        this.records = records;
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("");
        for (String h : headings) {
            String heading = h.trim();
            if (heading.length() <= 0 || "path".equals(heading)) continue;
            tmp.add(heading);
        }
        this.columnHeadings = tmp.toArray(new String[tmp.size()]);
        this.sorter = new TableRowSorter<TrackChooserModel>(this);
        this.sorter.setStringConverter(new TableStringConverter(this){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                return value == null ? "" : value.toString();
            }
        });
    }

    public TableRowSorter<TrackChooserModel> getSorter() {
        return this.sorter;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : String.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnHeadings[column];
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnHeadings.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.records.size() || columnIndex >= this.columnHeadings.length) {
            return null;
        }
        FileRecord record = this.records.get(rowIndex);
        if (columnIndex == 0) {
            return record.isSelected();
        }
        String att = this.columnHeadings[columnIndex];
        return record.getAttributeValue(att);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.records.get(row).setSelected((Boolean)value);
        }
        this.fireTableCellUpdated(row, col);
    }

    public void updateSelections() {
        Set<Object> loadedPaths = IGV.hasInstance() ? IGV.getInstance().getLoadedPaths() : Collections.emptySet();
        for (int row = 0; row < this.records.size(); ++row) {
            FileRecord record = this.records.get(row);
            record.setSelected(loadedPaths.contains(record.getPath()));
        }
        this.fireTableDataChanged();
    }

    public List<FileRecord> getRecords() {
        return this.records;
    }
}

