/*
 * Decompiled with CFR 0.152.
 */
package org.igv.charts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class ChartLayout
implements LayoutManager2,
Serializable {
    public static final String CHART = "Chart";
    public static final String XAXIS = "XAxis";
    public static final String YAXIS = "YAxis";
    public static final String TITLE = "Title";
    public static final String LEGEND = "Legend";
    int hgap = 2;
    int vgap = 2;
    Component title;
    Component yAxis;
    Component legend;
    Component xAxis;
    Component chart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (CHART.equals(name)) {
                this.chart = comp;
            } else if (TITLE.equals(name)) {
                this.title = comp;
            } else if (XAXIS.equals(name)) {
                this.xAxis = comp;
            } else if (YAXIS.equals(name)) {
                this.yAxis = comp;
            } else if (LEGEND.equals(name)) {
                this.legend = comp;
            } else {
                throw new IllegalArgumentException("Unknown chart component: " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (comp == this.chart) {
                this.chart = null;
            } else if (comp == this.title) {
                this.title = null;
            } else if (comp == this.xAxis) {
                this.xAxis = null;
            } else if (comp == this.legend) {
                this.legend = null;
            } else if (comp == this.yAxis) {
                this.yAxis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            if (this.legend != null) {
                d = this.legend.getMinimumSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.xAxis != null) {
                d = this.xAxis.getMinimumSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.chart != null) {
                d = this.chart.getMinimumSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.title != null) {
                d = this.title.getMinimumSize();
                dim.height += d.height + this.vgap;
            }
            if (this.yAxis != null) {
                d = this.yAxis.getMinimumSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            if (this.legend != null) {
                d = this.legend.getPreferredSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.xAxis != null) {
                d = this.xAxis.getPreferredSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.chart != null) {
                d = this.chart.getPreferredSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if (this.title != null) {
                d = this.title.getPreferredSize();
                dim.height += d.height + this.vgap;
            }
            if (this.yAxis != null) {
                d = this.yAxis.getPreferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            int titleHeight = this.title == null ? 0 : this.title.getPreferredSize().height;
            int xAxisHeight = this.xAxis == null ? 0 : this.xAxis.getPreferredSize().height;
            int yAxisWidth = this.yAxis == null ? 0 : this.yAxis.getPreferredSize().width;
            int legendWidth = this.legend == null ? 0 : this.legend.getPreferredSize().width;
            int x1 = left + yAxisWidth + (yAxisWidth == 0 ? 0 : this.hgap);
            int x2 = right - legendWidth - (legendWidth == 0 ? 0 : this.hgap);
            int y1 = top + titleHeight + (titleHeight == 0 ? 0 : this.vgap);
            int y2 = bottom - xAxisHeight - (xAxisHeight == 0 ? 0 : this.vgap);
            if (this.title != null) {
                this.title.setBounds(left, top, right - left, titleHeight);
            }
            if (this.xAxis != null) {
                this.xAxis.setBounds(x1, y2 + this.vgap, x2 - x1, xAxisHeight);
            }
            if (this.legend != null) {
                this.legend.setBounds(right - legendWidth, y1, legendWidth, y2 - y1);
            }
            if (this.yAxis != null) {
                this.yAxis.setBounds(left, y1, yAxisWidth, y2 - y1);
            }
            if (this.chart != null) {
                this.chart.setBounds(x1, y1, x2 - x1, y2 - y1);
            }
        }
    }
}

