/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.igv.bedpe.BedPE;
import org.igv.bedpe.BedPERenderer;
import org.igv.bedpe.BedPEShape;
import org.igv.bedpe.ContactMapView;
import org.igv.bedpe.InteractionSource;
import org.igv.bedpe.NestedArcRenderer;
import org.igv.bedpe.PEBlockRenderer;
import org.igv.bedpe.ProportionalArcRenderer;
import org.igv.event.IGVEvent;
import org.igv.event.IGVEventObserver;
import org.igv.feature.LocusScore;
import org.igv.jbrowse.CircularViewUtilities;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.renderer.GraphicUtils;
import org.igv.track.AbstractTrack;
import org.igv.track.RenderContext;
import org.igv.track.TrackClickEvent;
import org.igv.track.TrackMenuUtils;
import org.igv.ui.FontManager;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.IGVPopupMenu;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.util.MessageUtils;
import org.igv.ui.util.UIUtilities;
import org.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InteractionTrack
extends AbstractTrack
implements IGVEventObserver {
    private static final Logger log = LogManager.getLogger(InteractionTrack.class);
    static Map<String, String> normalizationLabels = new LinkedHashMap<String, String>();
    protected InteractionSource featureSource;
    private JCheckBoxMenuItem autoscaleCB;
    private JMenuItem maxScoreItem;
    Direction direction = Direction.UP;
    protected GraphType graphType = GraphType.NESTED_ARC;
    private ArcOption arcOption = ArcOption.ALL;
    int thickness = 1;
    boolean autoscale = true;
    double maxScore = -1.0;
    int gap = 5;
    boolean showBlocks = false;
    protected boolean isHIC = false;
    private Map<GraphType, BedPERenderer> renderers;
    ContactMapView contactMapView;
    float transparency = 1.0f;
    protected String normalization = "NONE";
    protected int maxFeatureCount = 20000;
    int[] markerBounds = null;
    transient Map<ReferenceFrame, List<BedPE>> lastRenderedFeatures = new HashMap<ReferenceFrame, List<BedPE>>();
    transient Map<ReferenceFrame, LoadedInterval> loadedIntervalMap = new HashMap<ReferenceFrame, LoadedInterval>();

    public InteractionTrack() {
    }

    public InteractionTrack(ResourceLocator locator, InteractionSource src) {
        super(locator);
        String blockString;
        String directionString;
        this.featureSource = src;
        this.setHeight(250, true);
        this.setDefaultColor(new Color(180, 25, 137));
        this.renderers = new HashMap<GraphType, BedPERenderer>();
        this.renderers.put(GraphType.NESTED_ARC, new NestedArcRenderer(this));
        this.renderers.put(GraphType.PROPORTIONAL_ARC, new ProportionalArcRenderer(this));
        this.renderers.put(GraphType.BLOCK, new PEBlockRenderer(this));
        String typeString = PreferencesManager.getPreferences().get("ARC_TYPE");
        if (typeString != null) {
            try {
                this.graphType = GraphType.valueOf(typeString);
            }
            catch (IllegalArgumentException e) {
                log.error("Illegal graph type: " + typeString, e);
            }
        }
        if ((directionString = PreferencesManager.getPreferences().get("ARC_DIRECTION")) != null) {
            try {
                this.direction = Direction.valueOf(directionString);
            }
            catch (IllegalArgumentException e) {
                log.error("Illegal arc direction: " + directionString, e);
                this.direction = Direction.UP;
            }
        } else {
            this.direction = Direction.UP;
        }
        if ((blockString = PreferencesManager.getPreferences().get("ARC_BLOCKS")) != null) {
            try {
                this.showBlocks = Boolean.parseBoolean(blockString);
            }
            catch (IllegalArgumentException e) {
                log.error("Illegal arc blocks option: " + blockString, e);
            }
        }
    }

    void setContactMapView(ContactMapView contactMapView) {
        this.contactMapView = contactMapView;
    }

    protected boolean isShowFeatures(ReferenceFrame frame) {
        if (frame.getChrName().equals("All")) {
            return true;
        }
        double windowSize = frame.getEnd() - frame.getOrigin();
        int vw = this.getVisibilityWindow();
        return vw <= 0 || windowSize <= (double)vw;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        LoadedInterval interval = this.loadedIntervalMap.get(frame);
        boolean b = interval != null && interval.contains(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd(), frame.getZoom(), this.normalization);
        return b;
    }

    @Override
    public void load(ReferenceFrame frame) {
        String chr = frame.getChrName();
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        int zoom = frame.getZoom();
        int w = (end - start) / 2;
        start = Math.max(0, start - w);
        end += w;
        try {
            List<BedPE> features = this.featureSource.getFeatures(chr, start, end, frame.getScale(), this.normalization, this.maxFeatureCount);
            LoadedInterval interval = new LoadedInterval(chr, start, end, zoom, this.normalization, features);
            this.loadedIntervalMap.put(frame, interval);
        }
        catch (IOException e) {
            log.error("Error loading features", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RenderContext context, Rectangle trackRectangle) {
        Graphics2D g2d = context.getGraphics();
        Rectangle clip = new Rectangle(g2d.getClip().getBounds());
        g2d.setClip(trackRectangle.intersection(clip.getBounds()));
        context.clearGraphicsCache();
        ReferenceFrame referenceFrame = context.getReferenceFrame();
        if (!this.isShowFeatures(referenceFrame)) {
            String message = "Zoom in to see features, or right-click to increase Feature Visibility Window.";
            GraphicUtils.drawCenteredText(message, trackRectangle, context.getGraphics());
            return;
        }
        try {
            LoadedInterval interval;
            String chr = referenceFrame.getChrName();
            if (this.normalization != null && !this.normalization.equals("NONE") && !this.featureSource.hasNormalizationVector(this.normalization, chr, context.getScale())) {
                String message = "Normalization '" + this.normalization + "' not available at this resolution. Switching normalization to 'NONE'.";
                this.normalization = "NONE";
                UIUtilities.invokeOnEventThread(() -> MessageUtils.showMessage(message));
            }
            if ((interval = this.loadedIntervalMap.get(referenceFrame)) == null) {
                return;
            }
            List<BedPE> features = interval.features();
            List<BedPE> filteredFeatures = this.filterFeaturesForZoom(features, interval, referenceFrame);
            if (filteredFeatures != null && !filteredFeatures.isEmpty()) {
                if (this.graphType == GraphType.PROPORTIONAL_ARC) {
                    if (this.autoscale || this.maxScore <= 0.0) {
                        this.maxScore = this.autoscale(features);
                    }
                    this.drawScale(context, trackRectangle);
                }
                this.renderers.get((Object)this.graphType).render(filteredFeatures, context, trackRectangle, this.arcOption);
            }
            if (this.showBlocks) {
                this.renderers.get((Object)GraphType.BLOCK).render(filteredFeatures, context, trackRectangle, this.arcOption);
            }
            if (this.contactMapView != null && !FrameManager.isGeneListMode()) {
                // empty if block
            }
        }
        finally {
            context.clearGraphicsCache();
            g2d.setClip(clip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawScale(RenderContext context, Rectangle arect) {
        if (!context.multiframe) {
            Graphics2D g = context.getGraphic2DForColor(Color.black);
            Font font = g.getFont();
            Font smallFont = FontManager.getFont(8);
            try {
                g.setFont(smallFont);
                String minString = "0";
                String fmtString = this.maxScore > 10.0 ? "%.0f" : "%.2f";
                String maxString = String.format(fmtString, this.maxScore);
                String scale = "[" + minString + " - " + maxString + "]";
                g.drawString(scale, arect.x + 5, arect.y + 10);
            }
            finally {
                g.setFont(font);
            }
        }
    }

    private double autoscale(List<BedPE> features) {
        double maxScore = 0.0;
        for (BedPE f : features) {
            maxScore = Math.max(maxScore, (double)f.getScore());
        }
        return maxScore;
    }

    protected List<BedPE> filterFeaturesForZoom(List<BedPE> features, LoadedInterval interval, ReferenceFrame referenceFrame) {
        return features;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        menu.add(TrackMenuUtils.getTrackRenameItem(Collections.singleton(this)));
        JMenuItem item = new JMenuItem("Set Track Height...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackHeight(Collections.singleton(this)));
        menu.add(item);
        item = new JMenuItem("Set Track Color...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackColor(Collections.singleton(this)));
        menu.add(item);
        item = new JMenuItem("Unset Track Color");
        item.addActionListener(evt -> {
            this.setColor(null);
            this.repaint();
        });
        menu.add(item);
        if (!this.isHIC) {
            menu.addSeparator();
            menu.add(new JLabel("<html><b>Graph Type</b>"));
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, GraphType> modes = new LinkedHashMap<String, GraphType>(4);
            modes.put("Nested Arcs", GraphType.NESTED_ARC);
            modes.put("Proportional Arcs", GraphType.PROPORTIONAL_ARC);
            for (Map.Entry entry : modes.entrySet()) {
                JRadioButtonMenuItem mm = new JRadioButtonMenuItem((String)entry.getKey());
                mm.setSelected(this.graphType == entry.getValue());
                mm.addActionListener(evt -> {
                    this.graphType = (GraphType)((Object)((Object)entry.getValue()));
                    PreferencesManager.getPreferences().put("ARC_TYPE", ((GraphType)((Object)((Object)entry.getValue()))).toString());
                    this.autoscaleCB.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
                    this.maxScoreItem.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
                    this.repaint();
                });
                group.add(mm);
                menu.add(mm);
            }
            menu.addSeparator();
            menu.add(new JLabel("<html><b>Arcs</b>"));
            ButtonGroup group2 = new ButtonGroup();
            LinkedHashMap<String, ArcOption> modes2 = new LinkedHashMap<String, ArcOption>(4);
            modes2.put("All", ArcOption.ALL);
            modes2.put("One End In View", ArcOption.ONE_END);
            modes2.put("Both Ends In View", ArcOption.BOTH_ENDS);
            for (Map.Entry entry : modes2.entrySet()) {
                JRadioButtonMenuItem mm = new JRadioButtonMenuItem((String)entry.getKey());
                mm.setSelected(this.arcOption == entry.getValue());
                mm.addActionListener(evt -> {
                    this.arcOption = (ArcOption)((Object)((Object)entry.getValue()));
                    this.repaint();
                });
                group2.add(mm);
                menu.add(mm);
            }
        }
        menu.addSeparator();
        JCheckBoxMenuItem showBlocksCB = new JCheckBoxMenuItem("Show Blocks");
        showBlocksCB.setSelected(this.showBlocks);
        showBlocksCB.addActionListener(e -> {
            this.showBlocks = showBlocksCB.isSelected();
            PreferencesManager.getPreferences().put("ARC_BLOCKS", String.valueOf(showBlocksCB.isSelected()));
            this.repaint();
        });
        menu.add(showBlocksCB);
        if (!this.isHIC) {
            menu.addSeparator();
            this.autoscaleCB = new JCheckBoxMenuItem("Autoscale");
            this.autoscaleCB.setSelected(this.autoscale);
            this.autoscaleCB.addActionListener(e -> {
                this.autoscale = this.autoscaleCB.isSelected();
                this.repaint();
            });
            menu.add(this.autoscaleCB);
            this.maxScoreItem = new JMenuItem("Set Max Score...");
            this.maxScoreItem.addActionListener(e -> {
                String maxScoreString = MessageUtils.showInputDialog("Enter maximum score:", String.valueOf(this.maxScore));
                if (maxScoreString != null) {
                    try {
                        double ms = Double.parseDouble(maxScoreString);
                        if (ms > 0.0) {
                            this.maxScore = ms;
                            this.autoscale = false;
                            this.repaint();
                        } else {
                            MessageUtils.showMessage("maximum score must be > 0");
                        }
                    }
                    catch (NumberFormatException e1) {
                        MessageUtils.showMessage("maximum score must be a number");
                    }
                }
            });
            menu.add(this.maxScoreItem);
            this.autoscaleCB.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
            this.maxScoreItem.setEnabled(this.graphType == GraphType.PROPORTIONAL_ARC);
        }
        menu.addSeparator();
        item = new JMenuItem("Toggle Arc Orientation");
        item.addActionListener(evt -> {
            this.direction = this.direction == Direction.UP ? Direction.DOWN : Direction.UP;
            this.repaint();
        });
        menu.add(item);
        item = new JMenuItem("Set Line Thickness...");
        item.addActionListener(e -> {
            String t = MessageUtils.showInputDialog("Line thickness", String.valueOf(this.thickness));
            if (t != null) {
                try {
                    this.thickness = Integer.parseInt(t);
                    this.repaint();
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showErrorMessage("Line thickness must be an integer", e1);
                }
            }
        });
        menu.add(item);
        if (this.isHIC) {
            this.addHICItems(te, menu);
        } else {
            menu.addSeparator();
            menu.add(TrackMenuUtils.getChangeFeatureWindow(Collections.singletonList(this)));
            if (PreferencesManager.getPreferences().getAsBoolean("CIRC_VIEW_ENABLED") && CircularViewUtilities.ping()) {
                menu.addSeparator();
                JMenuItem circViewItem = new JMenuItem("Add Features to Circular View");
                circViewItem.addActionListener(e -> {
                    List<ReferenceFrame> frames = te.getFrame() != null ? Collections.singletonList(te.getFrame()) : FrameManager.getFrames();
                    List<BedPE> visibleFeatures = this.getVisibleFeatures(frames);
                    CircularViewUtilities.sendBedpeToJBrowse(visibleFeatures, this.getName(), this.getColor());
                });
                menu.add(circViewItem);
                menu.addSeparator();
            }
        }
        return menu;
    }

    void addHICItems(TrackClickEvent te, IGVPopupMenu menu) {
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        double tolerance = frame.getScale() * 3.0;
        LoadedInterval interval = this.loadedIntervalMap.get(frame);
        if (interval == null) {
            return "";
        }
        List<BedPE> features = interval.features();
        if (features == null) {
            return "";
        }
        ArrayList<BedPE> candidates = new ArrayList<BedPE>();
        for (BedPE bedPE : features) {
            if ((double)bedPE.getEnd() < position - tolerance) continue;
            if ((double)bedPE.getStart() > position + tolerance) break;
            candidates.add(bedPE);
        }
        Comparator<BedPE> sorter = this.graphType == GraphType.PROPORTIONAL_ARC ? Comparator.comparingDouble(LocusScore::getScore) : Comparator.comparingDouble(BedPE::getCenterDistance);
        candidates.sort(sorter);
        for (BedPE f : candidates) {
            BedPEShape s = f.getShape();
            if (s != null && !s.contains(mouseX, mouseY)) continue;
            return f.getValueString();
        }
        return super.getValueStringAt(chr, position, mouseX, mouseY, frame);
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("direction", String.valueOf((Object)this.direction));
        element.setAttribute("thickness", String.valueOf(this.thickness));
        element.setAttribute("graphType", String.valueOf((Object)this.graphType));
        element.setAttribute("arcOption", String.valueOf((Object)this.arcOption));
        element.setAttribute("showBlocks", String.valueOf(this.showBlocks));
        element.setAttribute("autoscale", String.valueOf(this.autoscale));
        if (this.transparency != 1.0f) {
            element.setAttribute("transparency", String.valueOf(this.transparency));
        }
        if (!this.autoscale) {
            element.setAttribute("maxScore", String.valueOf(this.maxScore));
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        String typeString;
        super.unmarshalXML(element, version);
        if (element.hasAttribute("arcOption")) {
            typeString = element.getAttribute("arcOption").toUpperCase();
            this.arcOption = ArcOption.valueOf(typeString);
        }
        if (element.hasAttribute("direction")) {
            this.direction = Direction.valueOf(element.getAttribute("direction"));
        }
        if (element.hasAttribute("thickness")) {
            this.thickness = Integer.parseInt(element.getAttribute("thickness"));
        }
        if (element.hasAttribute("graphType")) {
            typeString = element.getAttribute("graphType").toUpperCase();
            if (typeString.equals("ARC")) {
                typeString = "NESTED_ARC";
            }
            this.graphType = GraphType.valueOf(typeString);
        }
        if (element.hasAttribute("showBlocks")) {
            this.showBlocks = Boolean.parseBoolean(element.getAttribute("showBlocks"));
        }
        if (element.hasAttribute("autoscale")) {
            this.autoscale = Boolean.parseBoolean(element.getAttribute("autoscale"));
        }
        if (element.hasAttribute("maxScore")) {
            this.maxScore = Double.parseDouble(element.getAttribute("maxScore"));
        }
        if (element.hasAttribute("transparency")) {
            this.transparency = Float.parseFloat(element.getAttribute("transparency"));
        }
    }

    public List<BedPE> getVisibleFeatures(List<ReferenceFrame> frames) {
        if (frames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BedPE> inView = new ArrayList<BedPE>();
        for (ReferenceFrame f : frames) {
            LoadedInterval interval = this.loadedIntervalMap.get(f);
            if (interval == null) continue;
            inView.addAll(interval.features());
        }
        return inView;
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof FrameManager.ChangeEvent) {
            HashSet<ReferenceFrame> frames = new HashSet<ReferenceFrame>(FrameManager.getFrames());
            this.loadedIntervalMap.keySet().removeIf(f -> !frames.contains(f));
        }
    }

    public void setMarkerBounds(int[] markerBounds) {
        this.markerBounds = markerBounds;
        this.repaint();
    }

    static {
        normalizationLabels.put("NONE", "None");
        normalizationLabels.put("VC", "Coverage");
        normalizationLabels.put("VC_SQRT", "Coverage - Sqrt");
        normalizationLabels.put("KR", "Balanced (Knight-Ruiz)");
        normalizationLabels.put("INTER_VC", "Interchromosomal Coverage");
        normalizationLabels.put("INTER_VC_SQRT", "Interchromosomal Coverage - Sqrt");
        normalizationLabels.put("INTER_KR", "Interchromosomal Balanced");
        normalizationLabels.put("GW_VC", "Genome-wide Coverage");
        normalizationLabels.put("GW_VC_SQRT", "Genome-wide Coverage - Sqrt");
        normalizationLabels.put("GW_KR", "Genome-wide Balanced");
    }

    static enum Direction {
        UP,
        DOWN;

    }

    static enum GraphType {
        BLOCK,
        NESTED_ARC,
        PROPORTIONAL_ARC;

    }

    static enum ArcOption {
        ALL,
        ONE_END,
        BOTH_ENDS;

    }

    public record LoadedInterval(String chr, int start, int end, int zoom, String normalization, List<BedPE> features) {
        String getKey() {
            return this.chr + "_" + this.start + "_" + this.end + "_" + this.zoom + "_" + this.normalization;
        }

        boolean contains(String chr, int start, int end, int zoom, String normalization) {
            return !(!this.chr.equals(chr) || this.start > start || this.end < end || this.zoom != -1 && this.zoom != zoom || this.normalization != null && !this.normalization.equals(normalization));
        }
    }
}

