/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import org.igv.bedpe.BedPE;
import org.igv.bedpe.ContactMapView;
import org.igv.bedpe.HicSource;
import org.igv.bedpe.InteractionTrack;
import org.igv.hic.HicFile;
import org.igv.renderer.ContinuousColorScale;
import org.igv.track.TrackClickEvent;
import org.igv.ui.IGV;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.IGVPopupMenu;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HicInteractionTrack
extends InteractionTrack {
    public HicInteractionTrack() {
    }

    public HicInteractionTrack(ResourceLocator locator, HicSource source) {
        super(locator, source);
        this.maxFeatureCount = 5000;
        this.graphType = InteractionTrack.GraphType.NESTED_ARC;
        this.isHIC = true;
        this.setUseScore(false);
        this.setDefaultColor(Color.red);
    }

    @Override
    protected List<BedPE> filterFeaturesForZoom(List<BedPE> features, InteractionTrack.LoadedInterval interval, ReferenceFrame referenceFrame) {
        if (interval.zoom() < referenceFrame.getZoom()) {
            int start = (int)referenceFrame.getOrigin();
            int end = (int)referenceFrame.getEnd();
            int w = end - start;
            int finalStart = start - w;
            int finalEnd = end + w;
            return features.stream().takeWhile(f -> f.getStart() <= finalEnd).filter(f -> f.getEnd() >= finalStart).toList();
        }
        return features;
    }

    @Override
    void addHICItems(TrackClickEvent te, IGVPopupMenu menu) {
        JMenuItem transparencyItem = new JMenuItem("Set Transparency...");
        transparencyItem.addActionListener(e -> {
            JSlider slider = new JSlider(1, 100, (int)(this.transparency * 100.0f));
            slider.setMajorTickSpacing(10);
            slider.setPaintTicks(true);
            JLabel valueLabel = new JLabel(String.format("%.2f", Float.valueOf(this.transparency)));
            slider.addChangeListener(changeEvent -> {
                float value;
                JSlider source = (JSlider)changeEvent.getSource();
                this.transparency = value = (float)source.getValue() / 100.0f;
                valueLabel.setText(String.format("%.2f", Float.valueOf(value)));
                this.repaint();
            });
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)slider, "Center");
            panel.add((Component)valueLabel, "South");
            Frame parent = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            JOptionPane.showMessageDialog(parent, panel, "Set Transparency for " + this.getDisplayName(), -1);
        });
        menu.add(transparencyItem);
        JMenuItem maxFeatureCountItem = new JMenuItem("Set Maximum Feature Count...");
        maxFeatureCountItem.addActionListener(e -> {
            JSlider slider = new JSlider(1000, 20000, this.maxFeatureCount);
            slider.setMajorTickSpacing(5000);
            slider.setPaintTicks(true);
            JLabel valueLabel = new JLabel(String.valueOf(this.maxFeatureCount));
            slider.addChangeListener(changeEvent -> {
                int value;
                JSlider source = (JSlider)changeEvent.getSource();
                this.maxFeatureCount = value = source.getValue();
                valueLabel.setText(String.valueOf(value));
                this.loadedIntervalMap.clear();
                this.repaint();
            });
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)slider, "Center");
            panel.add((Component)valueLabel, "South");
            Frame parent = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            JOptionPane.showMessageDialog(parent, panel, "Set Max Feature Count for " + this.getDisplayName(), -1);
        });
        menu.add(maxFeatureCountItem);
        List<String> normalizationTypes = this.featureSource.getNormalizationTypes();
        if (normalizationTypes != null && normalizationTypes.size() > 1) {
            menu.addSeparator();
            menu.add(new JLabel("<html><b>Normalization</b>"));
            ButtonGroup normGroup = new ButtonGroup();
            for (String type : normalizationTypes) {
                String label = normalizationLabels.getOrDefault(type, type);
                JRadioButtonMenuItem normItem = new JRadioButtonMenuItem(label);
                normItem.setSelected(type.equals(this.normalization));
                normItem.addActionListener(e -> {
                    this.normalization = type;
                    if (this.contactMapView != null) {
                        this.contactMapView.setNormalization(type);
                    }
                    this.repaint();
                });
                normGroup.add(normItem);
                menu.add(normItem);
            }
        }
        menu.addSeparator();
        JMenuItem mapItem = new JMenuItem("Contact Map View...");
        mapItem.setEnabled(this.contactMapView == null && !FrameManager.isGeneListMode());
        mapItem.addActionListener(e -> {
            ReferenceFrame frame;
            ReferenceFrame referenceFrame = frame = te.getFrame() != null ? te.getFrame() : FrameManager.getDefaultFrame();
            if (this.contactMapView == null) {
                ContinuousColorScale colorScale = this.getColorScale();
                HicFile hicFile = ((HicSource)this.featureSource).getHicFile();
                ContactMapView.showPopup(this, hicFile, this.normalization, frame, colorScale.getMaxColor());
            }
        });
        menu.add(mapItem);
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        String nviString = ((HicSource)this.featureSource).getNVIString();
        if (nviString != null) {
            element.setAttribute("nvi", nviString);
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (element.hasAttribute("nvi")) {
            String nviString = element.getAttribute("nvi");
            ((HicSource)this.featureSource).setNVIString(nviString);
        }
    }
}

