/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.igv.Globals;
import org.igv.bedpe.InteractionTrack;
import org.igv.event.IGVEvent;
import org.igv.event.IGVEventBus;
import org.igv.event.IGVEventObserver;
import org.igv.event.ViewChange;
import org.igv.hic.ContactRecord;
import org.igv.hic.HicFile;
import org.igv.hic.Region;
import org.igv.renderer.ContinuousColorScale;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.panel.RulerPanel;

public class ContactMapView
extends JPanel
implements IGVEventObserver {
    private InteractionTrack track;
    private HicFile hicFile;
    private String normalization;
    private Color color;
    private Color backgroundColor;
    private Map<String, ContinuousColorScale> colorScaleCache = new HashMap<String, ContinuousColorScale>();
    private ReferenceFrame frame;
    private int binSize;
    private int startBin;
    private int nBins;
    private RulerPanel rulerPanel;
    private JTextField maxField;
    private JSlider maxSlider;
    private JLabel binSizeLabel;
    private double sliderMinValue = 0.0;
    private double sliderMaxValue = 100.0;
    private final Object sliderThrottleLock = new Object();
    private volatile long lastSliderApplyTime = 0L;
    private Timer sliderThrottleTimer = null;
    private volatile double pendingSliderValue = Double.NaN;
    private volatile List<ContactRecord> cachedRecords;
    private volatile boolean isLoading = false;
    private volatile String loadingError = null;
    private final ExecutorService dataFetchExecutor = Executors.newSingleThreadExecutor();
    private Future<?> currentFetchTask;
    private volatile String dataCacheKey = null;

    public ContactMapView(final InteractionTrack track, HicFile hicFile, String normalization, ReferenceFrame frame, Color color) {
        int nBins;
        this.track = track;
        this.hicFile = hicFile;
        this.normalization = normalization;
        this.frame = frame;
        this.color = color;
        this.backgroundColor = Globals.isDarkMode() ? Color.BLACK : Color.WHITE;
        this.binSize = hicFile.getBinSize(frame.getChrName(), frame.getScale());
        this.startBin = (int)(frame.getOrigin() / (double)this.binSize);
        int endBin = (int)(frame.getEnd() / (double)this.binSize);
        this.nBins = nBins = endBin - this.startBin;
        frame.setOrigin(this.startBin * this.binSize);
        frame.setScale(this.binSize);
        frame.setWidthInPixels(nBins);
        this.setPreferredSize(new Dimension(nBins, nBins));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ContactMapView.this.updateFrameForSize();
                if (ContactMapView.this.rulerPanel != null) {
                    ContactMapView.this.rulerPanel.repaint();
                }
                ContactMapView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                double scaleFactor = (double)ContactMapView.this.getWidth() / (double)ContactMapView.this.nBins;
                int binX = (int)((double)e.getX() / scaleFactor) + ContactMapView.this.startBin;
                int binY = (int)((double)e.getY() / scaleFactor) + ContactMapView.this.startBin;
                int coordX = binX * ContactMapView.this.binSize + ContactMapView.this.binSize / 2;
                int coordY = binY * ContactMapView.this.binSize + ContactMapView.this.binSize / 2;
                track.setMarkerBounds(new int[]{coordX, coordY});
            }
        });
        this.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                track.setMarkerBounds(null);
            }
        });
        track.setContactMapView(this);
        this.fetchDataAsync();
        IGVEventBus.getInstance().subscribe(ViewChange.class, this);
    }

    private String generateCacheKey() {
        return String.format("%s:%d:%d:%d:%s", this.frame.getChrName(), (int)this.frame.getOrigin(), (int)this.frame.getEnd(), this.binSize, this.normalization);
    }

    private String getColorScaleCacheKey() {
        return this.normalization + "_" + this.binSize;
    }

    private void fetchDataAsync() {
        String newCacheKey = this.generateCacheKey();
        if (newCacheKey.equals(this.dataCacheKey) && this.cachedRecords != null && !this.isLoading) {
            return;
        }
        if (this.currentFetchTask != null && !this.currentFetchTask.isDone()) {
            this.currentFetchTask.cancel(true);
        }
        this.isLoading = true;
        this.loadingError = null;
        this.repaint();
        String chrName = this.frame.getChrName();
        int origin = (int)this.frame.getOrigin();
        int end = (int)this.frame.getEnd();
        int currentBinSize = this.binSize;
        String fetchCacheKey = newCacheKey;
        int countThreshold = chrName.equalsIgnoreCase("all") ? 100 : ContactMapView.getCountThreshold(this.binSize);
        this.currentFetchTask = this.dataFetchExecutor.submit(() -> {
            try {
                Region region = new Region(chrName, origin, end);
                List<ContactRecord> records = this.hicFile.getContactRecords(region, region, "BP", currentBinSize, this.normalization, true, countThreshold);
                SwingUtilities.invokeLater(() -> {
                    this.cachedRecords = records;
                    this.dataCacheKey = fetchCacheKey;
                    this.isLoading = false;
                    this.loadingError = null;
                    this.repaint();
                });
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(() -> {
                    this.dataCacheKey = fetchCacheKey;
                    this.isLoading = false;
                    this.loadingError = e.getMessage();
                    this.repaint();
                });
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> {
                    this.dataCacheKey = fetchCacheKey;
                    this.isLoading = false;
                    this.loadingError = "Unexpected error: " + e.getMessage();
                    this.repaint();
                });
            }
        });
    }

    private static int getCountThreshold(int binSize) {
        if (binSize <= 5000) {
            return 0;
        }
        if (binSize >= 250000) {
            return 10;
        }
        return (int)Math.round((double)(binSize - 5000) * 10.0 / 245000.0);
    }

    public void dispose() {
        if (this.currentFetchTask != null) {
            this.currentFetchTask.cancel(true);
        }
        this.dataFetchExecutor.shutdown();
        try {
            if (!this.dataFetchExecutor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.dataFetchExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.dataFetchExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setReferenceFrame(ReferenceFrame newFrame) {
        int requestedNBins;
        String currentChr = this.frame.getChrName();
        int newBinSize = this.hicFile.getBinSize(newFrame.getChrName(), newFrame.getScale());
        if (newBinSize == this.binSize && newFrame.getChrName().equals(currentChr)) {
            this.startBin = (int)(newFrame.getOrigin() / (double)this.binSize);
            this.frame.setOrigin(this.startBin * this.binSize);
            int endBin = this.startBin + this.nBins;
            int genomicEnd = endBin * this.binSize;
            this.updateFrameForSize();
            this.fetchDataAsync();
            return;
        }
        this.frame = new ReferenceFrame(newFrame);
        this.binSize = newBinSize;
        if (this.binSizeLabel != null) {
            this.binSizeLabel.setText(this.formatBinSize(this.binSize));
        }
        int genomicSpan = (int)(newFrame.getEnd() - newFrame.getOrigin());
        this.nBins = requestedNBins = (int)Math.ceil((double)genomicSpan / (double)this.binSize);
        this.startBin = (int)(newFrame.getOrigin() / (double)this.binSize);
        this.frame.setOrigin(this.startBin * this.binSize);
        int endBin = this.startBin + this.nBins;
        this.frame.setScale(this.binSize);
        this.frame.setWidthInPixels(this.nBins);
        this.updateFrameForSize();
        this.fetchDataAsync();
        if (this.rulerPanel != null) {
            this.rulerPanel.repaint();
        }
        this.repaint();
    }

    private void updateFrameForSize() {
        int currentWidth = this.getWidth();
        if (currentWidth <= 0) {
            return;
        }
        double pixelsPerBin = (double)currentWidth / (double)this.nBins;
        double newScale = (double)this.binSize / pixelsPerBin;
        this.frame.setScale(newScale);
        this.frame.setWidthInPixels(currentWidth);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        int size = Math.min(pref.width, pref.height);
        return new Dimension(size, size);
    }

    @Override
    public Dimension getMinimumSize() {
        int minSize = Math.max(100, this.nBins / 10);
        return new Dimension(minSize, minSize);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension max = super.getMaximumSize();
        int size = Math.min(max.width, max.height);
        return new Dimension(size, size);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int size = Math.min(width, height);
        super.setBounds(x, y, size, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g.create();
        try {
            Image img;
            if (this.isLoading) {
                this.drawLoadingIndicator(g2D);
            } else if (this.loadingError != null) {
                g2D.setColor(Color.RED);
                g2D.drawString("Error: " + this.loadingError, 10, 20);
            } else if (this.cachedRecords != null && (img = this.renderMapFromCache()) != null) {
                g2D.drawImage(img, 0, 0, null);
            }
        }
        finally {
            g2D.dispose();
        }
    }

    private void drawLoadingIndicator(Graphics2D g2D) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.cachedRecords != null) {
            Image img = this.renderMapFromCache();
            if (img != null) {
                g2D.drawImage(img, 0, 0, null);
            }
            g2D.setColor(new Color(255, 255, 255, 128));
            g2D.fillRect(0, 0, width, height);
        }
        g2D.setColor(Color.DARK_GRAY);
        String message = "Loading...";
        FontMetrics fm = g2D.getFontMetrics();
        int textWidth = fm.stringWidth(message);
        int textHeight = fm.getHeight();
        g2D.drawString(message, (width - textWidth) / 2, (height + textHeight) / 2);
    }

    private Image renderMapFromCache() {
        if (this.cachedRecords == null) {
            return null;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, width, height);
        g2d.dispose();
        double scaleFactor = (double)width / (double)this.nBins;
        String colorScaleKey = this.getColorScaleCacheKey();
        ContinuousColorScale colorScale = this.colorScaleCache.get(colorScaleKey);
        if (colorScale == null) {
            double upper = this.initializeColorScale(this.cachedRecords);
            colorScale = new ContinuousColorScale(0.0, upper, this.backgroundColor, this.color);
            this.colorScaleCache.put(colorScaleKey, colorScale);
            this.maxField.setText(String.format("%.2f", colorScale.getMaximum()));
            this.updateSliderFromValue(colorScale.getMaximum());
        }
        for (ContactRecord record : this.cachedRecords) {
            int binX = record.bin1() - this.startBin;
            int binY = record.bin2() - this.startBin;
            int x = (int)((double)binX * scaleFactor);
            int y = (int)((double)binY * scaleFactor);
            if (x < 0 || y < 0) continue;
            Color featureColor = colorScale.getColor(record.normCounts());
            int pixelSize = Math.max(1, (int)Math.ceil(scaleFactor));
            for (int dx = 0; dx < pixelSize && x + dx < width; ++dx) {
                for (int dy = 0; dy < pixelSize && y + dy < height; ++dy) {
                    if (x + dx < width && y + dy < height) {
                        img.setRGB(x + dx, y + dy, featureColor.getRGB());
                    }
                    if (y + dx >= width || x + dy >= height) continue;
                    img.setRGB(y + dx, x + dy, featureColor.getRGB());
                }
            }
        }
        return img;
    }

    public static void showPopup(final InteractionTrack track, HicFile hicFile, String normalization, ReferenceFrame frame, Color color) {
        ReferenceFrame refFrame = new ReferenceFrame(frame);
        SwingUtilities.invokeLater(() -> {
            JFrame jf = new JFrame(track.getDisplayName());
            jf.setDefaultCloseOperation(2);
            JPanel mainPanel = new JPanel(new BorderLayout());
            final ContactMapView contactMapView = new ContactMapView(track, hicFile, normalization, refFrame, color);
            mainPanel.add((Component)contactMapView, "Center");
            JPanel topPanel = new JPanel(new BorderLayout());
            JPanel controlPanel = contactMapView.createControlPanel();
            topPanel.add((Component)controlPanel, "North");
            final RulerPanel rulerPanel = new RulerPanel(refFrame);
            Dimension rulerSize = new Dimension(contactMapView.getPreferredSize().width, 50);
            rulerPanel.setPreferredSize(rulerSize);
            topPanel.add((Component)rulerPanel, "Center");
            mainPanel.add((Component)topPanel, "North");
            contactMapView.rulerPanel = rulerPanel;
            contactMapView.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int width = contactMapView.getWidth();
                    rulerPanel.setPreferredSize(new Dimension(width, 50));
                    rulerPanel.revalidate();
                }
            });
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    IGVEventBus.getInstance().unsubscribe(contactMapView);
                    contactMapView.dispose();
                    track.setContactMapView(null);
                }
            });
            jf.getContentPane().add(mainPanel);
            jf.pack();
            jf.setLocationRelativeTo(null);
            jf.setVisible(true);
        });
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel maxLabel = new JLabel("Color Scale Max:");
        maxLabel.setAlignmentY(0.5f);
        controlPanel.add(maxLabel);
        controlPanel.add(Box.createHorizontalStrut(5));
        this.maxSlider = new JSlider(0, 100, 50);
        this.maxSlider.setPreferredSize(new Dimension(133, 25));
        this.maxSlider.setMaximumSize(new Dimension(133, 25));
        this.maxSlider.setAlignmentY(0.5f);
        this.maxSlider.setToolTipText(String.format("Range: %.2f - %.2f", this.sliderMinValue, this.sliderMaxValue));
        this.maxSlider.addChangeListener(e -> {
            double value = this.sliderMinValue + (this.sliderMaxValue - this.sliderMinValue) * (double)this.maxSlider.getValue() / 100.0;
            this.maxField.setText(String.format("%.2f", value));
            this.maxSlider.setToolTipText(String.format("Value: %.2f (Range: %.2f - %.2f)", value, this.sliderMinValue, this.sliderMaxValue));
            this.applySliderValueThrottled(value);
        });
        controlPanel.add(this.maxSlider);
        controlPanel.add(Box.createHorizontalStrut(5));
        this.maxField = new JTextField("10", 6);
        this.maxField.setMaximumSize(this.maxField.getPreferredSize());
        this.maxField.setAlignmentY(0.5f);
        this.maxField.addActionListener(e -> {
            try {
                double newMax = Double.parseDouble(this.maxField.getText().trim());
                String colorScaleKey = this.getColorScaleCacheKey();
                ContinuousColorScale colorScale = this.colorScaleCache.get(colorScaleKey);
                if (colorScale != null) {
                    colorScale.setPosEnd(newMax);
                    this.maxField.setText(String.format("%.2f", newMax));
                    this.updateSliderFromValue(newMax);
                    this.repaint();
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(controlPanel, "Invalid number format. Please enter a valid number.", "Input Error", 0);
            }
        });
        controlPanel.add(this.maxField);
        controlPanel.add(Box.createHorizontalStrut(5));
        JButton applyButton = new JButton("Apply");
        applyButton.setAlignmentY(0.5f);
        applyButton.addActionListener(e -> {
            try {
                String colorScaleKey = this.getColorScaleCacheKey();
                ContinuousColorScale colorScale = this.colorScaleCache.get(colorScaleKey);
                double newMax = Double.parseDouble(this.maxField.getText().trim());
                if (colorScale != null) {
                    colorScale.setPosEnd(newMax);
                    this.maxField.setText(String.format("%.2f", newMax));
                    this.updateSliderFromValue(newMax);
                    this.repaint();
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(controlPanel, "Invalid number format. Please enter a valid number.", "Input Error", 0);
            }
        });
        controlPanel.add(applyButton);
        controlPanel.add(Box.createHorizontalGlue());
        this.binSizeLabel = new JLabel(this.formatBinSize(this.binSize));
        this.binSizeLabel.setAlignmentY(0.5f);
        controlPanel.add(this.binSizeLabel);
        return controlPanel;
    }

    private void updateSliderFromValue(double value) {
        if (value > this.sliderMaxValue) {
            this.sliderMaxValue = value;
        }
        if (this.sliderMaxValue > this.sliderMinValue) {
            double normalized = (value - this.sliderMinValue) / (this.sliderMaxValue - this.sliderMinValue);
            int sliderPos = (int)Math.round(normalized * 100.0);
            sliderPos = Math.max(0, Math.min(100, sliderPos));
            this.maxSlider.setValue(sliderPos);
            this.maxSlider.setToolTipText(String.format("Value: %.2f (Range: %.2f - %.2f)", value, this.sliderMinValue, this.sliderMaxValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySliderValueThrottled(double value) {
        long THROTTLE_MS = 100L;
        Object object = this.sliderThrottleLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long elapsed = now - this.lastSliderApplyTime;
            if (elapsed >= 100L) {
                this.lastSliderApplyTime = now;
                SwingUtilities.invokeLater(() -> this.applySliderValue(value));
            } else {
                this.pendingSliderValue = value;
                int delay = (int)Math.max(1L, 100L - elapsed);
                if (this.sliderThrottleTimer != null && this.sliderThrottleTimer.isRunning()) {
                    this.sliderThrottleTimer.stop();
                }
                this.sliderThrottleTimer = new Timer(delay, e -> {
                    double v;
                    Object object = this.sliderThrottleLock;
                    synchronized (object) {
                        v = this.pendingSliderValue;
                        this.pendingSliderValue = Double.NaN;
                        this.lastSliderApplyTime = System.currentTimeMillis();
                    }
                    this.applySliderValue(v);
                });
                this.sliderThrottleTimer.setRepeats(false);
                this.sliderThrottleTimer.start();
            }
        }
    }

    private void applySliderValue(double value) {
        String colorScaleKey = this.getColorScaleCacheKey();
        ContinuousColorScale colorScale = this.colorScaleCache.get(colorScaleKey);
        if (colorScale != null) {
            colorScale.setPosEnd(value);
            this.repaint();
        }
    }

    private String formatBinSize(int binSize) {
        int actualBinSize = binSize;
        if (this.frame.getChrName().equalsIgnoreCase("all")) {
            actualBinSize *= 1000;
        }
        if (actualBinSize >= 1000000) {
            double mb = (double)actualBinSize / 1000000.0;
            if (mb == Math.floor(mb)) {
                return String.format("%d Mb", (int)mb);
            }
            return String.format("%.1f Mb", mb);
        }
        if (actualBinSize >= 1000) {
            double kb = (double)actualBinSize / 1000.0;
            if (kb == Math.floor(kb)) {
                return String.format("%d kb", (int)kb);
            }
            return String.format("%.1f kb", kb);
        }
        return actualBinSize + " bp";
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof ViewChange) {
            ViewChange vc = (ViewChange)event;
            if (!vc.panning) {
                this.setReferenceFrame(vc.referenceFrame);
            }
        }
    }

    private double initializeColorScale(List<ContactRecord> contactRecords) {
        if (contactRecords == null || contactRecords.isEmpty()) {
            return 10.0;
        }
        List counts = contactRecords.stream().map(ContactRecord::normCounts).sorted().collect(Collectors.toList());
        double percentile = this.frame.getChrName().equalsIgnoreCase("all") ? 0.98 : (this.binSize < 1000 ? 0.0 : (this.binSize <= 10000 ? 0.9 : 0.8));
        int index = (int)Math.ceil(percentile * (double)(counts.size() - 1));
        float midCount = ((Float)counts.get(index)).floatValue();
        float minCount = ((Float)counts.get(0)).floatValue();
        float maxCount = 4.0f * midCount;
        this.sliderMinValue = minCount;
        this.sliderMaxValue = maxCount;
        return midCount;
    }

    public void setNormalization(String type) {
        if (this.normalization != null && this.normalization.equals(type)) {
            return;
        }
        this.normalization = type;
        this.cachedRecords = null;
        this.dataCacheKey = null;
        this.fetchDataAsync();
    }
}

