/*
 * Decompiled with CFR 0.152.
 */
package org.igv.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.igv.Globals;
import org.igv.batch.CommandExecutor;
import org.igv.feature.genome.GenomeManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.IGV;
import org.igv.ui.WaitCursorManager;
import org.igv.ui.util.SnapshotUtilities;
import org.igv.util.FileUtils;
import org.igv.util.ParsingUtils;

public class BatchRunner {
    private static Logger log = LogManager.getLogger(BatchRunner.class);
    private String inputFile;
    private String rootPath;
    private IGV igv;

    public BatchRunner(String inputFile, IGV igv) {
        this.inputFile = inputFile;
        this.igv = igv;
        if (FileUtils.isRemote(inputFile)) {
            this.rootPath = inputFile;
        } else {
            File f = new File(inputFile);
            if (f.exists()) {
                this.rootPath = f.getParent();
            }
        }
    }

    public String getName() {
        return "batchExecution";
    }

    public static void setIsBatchMode(boolean isBatchMode) {
        Globals.setSuppressMessages(isBatchMode);
        Globals.setBatch(isBatchMode);
    }

    public void run() throws IOException {
        this.runWithDefaultGenome(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithDefaultGenome(String genomeId) throws IOException {
        log.info("Executing batch script: " + this.inputFile);
        BatchRunner.setIsBatchMode(true);
        CommandExecutor cmdExe = new CommandExecutor(this.igv, this.rootPath);
        WaitCursorManager.CursorToken cursorToken = null;
        BufferedReader reader = null;
        try {
            String inLine;
            cursorToken = WaitCursorManager.showWaitCursor();
            reader = ParsingUtils.openBufferedReader(this.inputFile);
            boolean firstCommand = true;
            while ((inLine = reader.readLine()) != null) {
                if (inLine.startsWith("#") || inLine.startsWith("//")) continue;
                if (firstCommand && genomeId != null && !inLine.toLowerCase().startsWith("genome")) {
                    log.debug("Loading genome " + genomeId);
                    GenomeManager.getInstance().loadGenomeById(genomeId);
                }
                log.debug("Executing Command: " + inLine);
                String result = cmdExe.execute(inLine);
                if (!result.equalsIgnoreCase("ok")) {
                    log.warn(inLine + " => " + result);
                }
                firstCommand = false;
            }
        }
        finally {
            BatchRunner.setIsBatchMode(false);
            SnapshotUtilities.resetMaxPanelHeight();
            if (cursorToken != null) {
                WaitCursorManager.removeWaitCursor(cursorToken);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Error closing reader", e);
                }
            }
        }
    }
}

