/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.genome;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.HostedGenomes;
import org.broad.igv.feature.genome.load.GenbankParser;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.genome.GenomeListItem;
import org.broad.igv.ui.genome.GenomeUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.json.JSONObject;

public class GenomeListManager {
    private static Logger log = LogManager.getLogger(GenomeListManager.class);
    private static GenomeListManager theInstance;
    private static final String REMOTE_GENOMES_FILE = "remote-genomes.txt";
    private static final GenomeListItem DEFAULT_GENOME;
    private Map<String, GenomeListItem> genomeItemMap = new HashMap<String, GenomeListItem>();
    private Map<String, GenomeListItem> remoteGenomesMap;
    private Map<String, GenomeListItem> downloadedGenomesMap;
    private static GenomeListSorter sorter;
    public static final String TEST_REMOTE_GENOMES_FILE;

    public static synchronized GenomeListManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeListManager();
        }
        return theInstance;
    }

    private GenomeListManager() {
    }

    public Map<String, GenomeListItem> getGenomeItemMap() throws IOException {
        if (this.genomeItemMap.isEmpty()) {
            this.rebuildGenomeItemMaps();
        }
        return this.genomeItemMap;
    }

    public void resetForTests() throws IOException {
        this.remoteGenomesMap = null;
        new File(TEST_REMOTE_GENOMES_FILE).delete();
        this.rebuildGenomeItemMaps();
    }

    public List<GenomeListItem> getGenomeTableRecords() {
        ArrayList<GenomeListItem> items = new ArrayList<GenomeListItem>(this.genomeItemMap.values());
        items.sort(sorter);
        return items;
    }

    public void addGenomeItem(GenomeListItem genomeListItem) {
        if (this.genomeItemMap.values().stream().anyMatch(item -> genomeListItem.equals(item))) {
            return;
        }
        this.genomeItemMap.put(genomeListItem.getId(), genomeListItem);
        GenomeListItem hostedListItem = HostedGenomes.getGenomeListItem(genomeListItem.getId());
        boolean isHosted = hostedListItem != null && hostedListItem.equals(genomeListItem);
        boolean isCached = DirectoryManager.getGenomeCacheDirectory().equals(new File(genomeListItem.getPath()).getParentFile());
        if (!isHosted && !isCached) {
            if (this.remoteGenomesMap == null) {
                this.remoteGenomesMap = new HashMap<String, GenomeListItem>();
            }
            if (hostedListItem == null || !hostedListItem.equals(genomeListItem)) {
                this.remoteGenomesMap.put(genomeListItem.getId(), genomeListItem);
                this.remoteGenomesMap.put(genomeListItem.getId(), genomeListItem);
                this.exportRemoteGenomesList();
            }
        }
        IGVEventBus.getInstance().post(new GenomeResetEvent());
    }

    public GenomeListItem getGenomeTableRecord(String genomeId) {
        GenomeListItem matchingItem = this.genomeItemMap.get(genomeId);
        if (matchingItem == null) {
            try {
                this.rebuildGenomeItemMaps();
            }
            catch (IOException e) {
                log.error("Error rebuilding genome item map", e);
            }
            matchingItem = this.genomeItemMap.get(genomeId);
        }
        return matchingItem;
    }

    private void rebuildGenomeItemMaps() throws IOException {
        this.remoteGenomesMap = null;
        this.downloadedGenomesMap = null;
        this.genomeItemMap.clear();
        try {
            this.genomeItemMap.putAll(this.getRemoteGenomesMap());
        }
        catch (IOException e) {
            log.error("Error updating remote genomes map", e);
        }
        this.genomeItemMap.putAll(this.getDownloadedGenomeMap());
        if (this.genomeItemMap.isEmpty()) {
            this.genomeItemMap.put(DEFAULT_GENOME.getId(), DEFAULT_GENOME);
        }
    }

    public Map<String, GenomeListItem> getDownloadedGenomeMap() {
        if (this.downloadedGenomesMap == null) {
            GenomeListItem hostedItem;
            String name;
            String id;
            File[] files;
            this.downloadedGenomesMap = new HashMap<String, GenomeListItem>();
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                return this.downloadedGenomesMap;
            }
            for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
                if (file.isDirectory()) continue;
                if (file.getName().toLowerCase().endsWith(".json")) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                        String line;
                        StringBuilder jsonContent = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            jsonContent.append(line);
                        }
                        JSONObject jsonObject = new JSONObject(jsonContent.toString());
                        GenomeConfig config = GenomeConfig.fromJson(jsonObject.toString());
                        id = config.id;
                        if (id == null) {
                            log.error("GenomeConfig ID is null for file: " + file.getAbsolutePath());
                            continue;
                        }
                        name = config.getName();
                        GenomeListItem item = new GenomeListItem(name, file.getAbsolutePath(), id);
                        if (GenomeUtils.isDeprecated(config) && (hostedItem = HostedGenomes.getGenomeListItem(id)) != null) {
                            item = hostedItem;
                        }
                        this.downloadedGenomesMap.put(id, item);
                    }
                    catch (Exception e) {
                        log.error("Error parsing genome json: " + file.getAbsolutePath(), e);
                    }
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".gbk")) continue;
                try {
                    String id2;
                    String name2 = id2 = new GenbankParser(file.getAbsolutePath()).getAccession();
                    GenomeListItem item = new GenomeListItem(name2, file.getAbsolutePath(), id2);
                    this.downloadedGenomesMap.put(id2, item);
                }
                catch (IOException e) {
                    log.error("Error parsing Genbank file: " + file.getAbsolutePath(), e);
                }
            }
            for (File file : files) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
                String path = file.getAbsolutePath();
                try (ZipFile zipFile = new ZipFile(path);){
                    ZipEntry zipEntry = zipFile.getEntry("property.txt");
                    if (zipEntry == null) {
                        throw new IOException("Missing genome archive property file.");
                    }
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        id = properties.getProperty("id");
                        if (this.downloadedGenomesMap.containsKey(id)) {
                            log.info("Ignoring deprecated .genome file for genome: " + id);
                            continue;
                        }
                        name = properties.getProperty("name");
                        GenomeListItem genomeListItem = new GenomeListItem(name, path, id);
                        hostedItem = HostedGenomes.getGenomeListItem(id);
                        String fastaURL = properties.getProperty("sequenceLocation");
                        if (hostedItem != null && fastaURL != null && GenomeUtils.isDeprecated(fastaURL)) {
                            log.warn("Genome file " + file.getName() + " is deprecated. Using hosted genome instead.");
                            genomeListItem = GenomeUtils.updateGenome(hostedItem);
                        }
                        this.downloadedGenomesMap.put(id, genomeListItem);
                    }
                }
                catch (Exception e) {
                    log.warn("Error reading genome archive file: " + path + ". It may not be a valid genome archive.");
                }
            }
        }
        return this.downloadedGenomesMap;
    }

    public void removeItems(List<GenomeListItem> removedValuesList) {
        boolean updateImportFile = false;
        for (GenomeListItem genomeListItem : removedValuesList) {
            String id = genomeListItem.getId();
            this.genomeItemMap.remove(id);
            if (this.remoteGenomesMap == null || !this.remoteGenomesMap.containsKey(id)) continue;
            this.remoteGenomesMap.remove(id);
            updateImportFile = true;
        }
        if (updateImportFile) {
            this.exportRemoteGenomesList();
        }
    }

    public void removeRemoteItem(String id) {
        if (this.remoteGenomesMap.containsKey(id)) {
            this.remoteGenomesMap.remove(id);
            this.exportRemoteGenomesList();
        }
    }

    private static BufferedReader getGenomeServerListReader() throws IOException {
        try {
            return ParsingUtils.openBufferedReader(PreferencesManager.getPreferences().getGenomeListURL());
        }
        catch (IOException e) {
            log.error("Error fetching genome list: ", e);
            return ParsingUtils.openBufferedReader(PreferencesManager.getPreferences().getBackupGenomeListURL());
        }
    }

    public Map<String, GenomeListItem> getRemoteGenomesMap() throws IOException {
        if (this.remoteGenomesMap == null) {
            File[] listFiles;
            boolean updateClientGenomeListFile = false;
            this.remoteGenomesMap = new HashMap<String, GenomeListItem>();
            for (File listFile : listFiles = new File[]{new File(DirectoryManager.getGenomeCacheDirectory(), this.getRemoteGenomesFilename()), new File(DirectoryManager.getGenomeCacheDirectory(), "user-defined-genomes.txt")}) {
                block14: {
                    if (!listFile.exists()) continue;
                    boolean mightBeProperties = false;
                    BufferedReader reader = new BufferedReader(new FileReader(listFile));
                    block8: while (true) {
                        String nextLine;
                        while ((nextLine = reader.readLine()) != null) {
                            String file;
                            if (nextLine.startsWith("#") || nextLine.trim().isEmpty()) {
                                mightBeProperties = true;
                                continue;
                            }
                            String[] fields = nextLine.split("\t");
                            if (fields.length < 3 && mightBeProperties && fields[0].contains("=")) {
                                fields = nextLine.split("\\\\t");
                                if (fields.length < 3) continue;
                                fields[0] = fields[0].substring(fields[0].indexOf("=") + 1);
                            }
                            if (!FileUtils.isRemote(file = fields[1]) && !FileUtils.resourceExists(file)) {
                                updateClientGenomeListFile = true;
                                continue;
                            }
                            try {
                                GenomeListItem item = new GenomeListItem(fields[0], file, fields[2]);
                                this.remoteGenomesMap.put(item.getId(), item);
                                continue block8;
                            }
                            catch (Exception e) {
                                log.error("Error updating remote genome list line: " + nextLine, e);
                            }
                        }
                        break block14;
                        {
                            continue block8;
                            break;
                        }
                        break;
                    }
                    finally {
                        reader.close();
                    }
                }
                if (!updateClientGenomeListFile) continue;
                this.exportRemoteGenomesList();
            }
        }
        return this.remoteGenomesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRemoteGenomesList() {
        if (this.remoteGenomesMap == null) {
            return;
        }
        File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.getRemoteGenomesFilename());
        File backup = null;
        if (listFile.exists()) {
            backup = new File(listFile.getAbsolutePath() + ".bak");
            try {
                FileUtils.copyFile(listFile, backup);
            }
            catch (IOException e) {
                log.error("Error backing up user-defined genome list file", e);
                backup = null;
            }
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
            for (GenomeListItem genomeListItem : this.remoteGenomesMap.values()) {
                writer.print(genomeListItem.getDisplayableName());
                writer.print("\t");
                writer.print(genomeListItem.getPath());
                writer.print("\t");
                writer.println(genomeListItem.getId());
            }
        }
        catch (Exception e) {
            if (backup != null) {
                try {
                    FileUtils.copyFile(backup, listFile);
                }
                catch (IOException e1) {
                    log.error("Error restoring genome-list file from backup");
                }
            }
            MessageUtils.showErrorMessage("Error updating user-defined genome list " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (backup != null) {
                backup.delete();
            }
        }
    }

    private String getRemoteGenomesFilename() {
        if (Globals.isTesting()) {
            return TEST_REMOTE_GENOMES_FILE;
        }
        return REMOTE_GENOMES_FILE;
    }

    static {
        DEFAULT_GENOME = new GenomeListItem("Human (hg38)", "https://raw.githubusercontent.com/igvteam/igv-data/refs/heads/main/genomes/legacy/json/hg38.json", "hg38");
        sorter = new GenomeListSorter();
        TEST_REMOTE_GENOMES_FILE = "test-remote-genomes_" + System.currentTimeMillis() + "_" + Math.random() + ".txt";
    }

    private static class GenomeListSorter
    implements Comparator<GenomeListItem> {
        private GenomeListSorter() {
        }

        @Override
        public int compare(GenomeListItem o1, GenomeListItem o2) {
            return o1.getDisplayableName().toLowerCase().compareTo(o2.getDisplayableName().toLowerCase());
        }
    }
}

