/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.hub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ucsc.hub.HubDescriptor;
import org.broad.igv.ucsc.hub.HubParser;
import org.broad.igv.ucsc.hub.Stanza;
import org.broad.igv.ucsc.hub.TrackConfigContainer;
import org.broad.igv.ucsc.hub.TrackDbHub;

public class Hub {
    private static Logger log = LogManager.getLogger(Hub.class);
    private final String url;
    private int order = 0;
    Stanza hubStanza;
    List<Stanza> genomeStanzas;
    List<Stanza> groupStanzas;
    Map<String, TrackDbHub> trackHubMap;
    private List<GenomeConfig> genomeConfigs;
    private static final Map<String, String> idMappings = Map.ofEntries(Map.entry("hg38", "GCF_000001405.40"), Map.entry("mm39", "GCF_000001635.27"), Map.entry("mm10", "GCF_000001635.26"), Map.entry("bosTau9", "GCF_002263795.1"), Map.entry("canFam4", "GCF_011100685.1"), Map.entry("canFam6", "GCF_000002285.5"), Map.entry("ce11", "GCF_000002985.6"), Map.entry("dm6", "GCF_000001215.4"), Map.entry("galGal6", "GCF_000002315.6"), Map.entry("gorGor6", "GCF_008122165.1"), Map.entry("macFas5", "GCA_000364345.1"), Map.entry("panTro6", "GCA_002880755.3"), Map.entry("rn6", "GCF_000001895.5"), Map.entry("rn7", "GCF_015227675.2"), Map.entry("sacCer3", "GCF_000146045.2"), Map.entry("sacCer2", "GCF_000146045.2"), Map.entry("susScr11", "GCF_000003025.6"), Map.entry("taeGut1", "GCF_000002275.3"), Map.entry("tetNig2", "GCF_000002275.3"), Map.entry("xenTro10", "GCF_000002035.6"), Map.entry("xenTro9", "GCF_000002035.6"), Map.entry("tair10", "GCF_000001735.4"));

    Hub(String url, Stanza hubStanza, List<Stanza> genomeStanzas, List<Stanza> trackStanzas, List<Stanza> groupStanzas) throws IOException {
        this.url = url;
        this.hubStanza = hubStanza;
        this.genomeStanzas = genomeStanzas;
        this.groupStanzas = groupStanzas;
        this.trackHubMap = new HashMap<String, TrackDbHub>();
        if (trackStanzas != null) {
            String genomeId = genomeStanzas.get(0).getProperty("genome");
            this.trackHubMap.put(genomeId, new TrackDbHub(trackStanzas, groupStanzas));
        }
    }

    public HubDescriptor getDescriptor() {
        String dbList = this.genomeStanzas.stream().map(stanza -> stanza.getProperty("genome")).collect(Collectors.joining(","));
        return new HubDescriptor(this.url, this.hubStanza.getProperty("shortLabel"), this.hubStanza.getProperty("longLabel"), dbList, this.hubStanza.getProperty("descriptionUrl"));
    }

    public boolean isOneFile() {
        return "on".equals(this.hubStanza.getProperty("useOneFile"));
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isAssemblyHub() {
        return this.genomeStanzas.stream().allMatch(gs -> gs.hasProperty("twoBitPath"));
    }

    public String getShortLabel() {
        return this.hubStanza.hasProperty("shortLabel") ? this.hubStanza.getProperty("shortLabel") : this.url;
    }

    public String getLongLabel() {
        return this.hubStanza.hasProperty("longLabel") ? this.hubStanza.getProperty("longLabel") : this.url;
    }

    public String getDescriptionURL() {
        return this.hubStanza.hasProperty("descriptionUrl") ? this.hubStanza.getProperty("descriptionUrl") : (this.hubStanza.hasProperty("desriptionUrl") ? this.hubStanza.getProperty("desriptionUrl") : null);
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.hubStanza.getProperty("shortLabel");
    }

    public String getDescription() {
        return this.hubStanza.getProperty("longLabel");
    }

    public List<TrackConfigContainer> getGroupedTrackConfigurations(String genomeId) {
        TrackDbHub trackHub = this.getTrackDbHub(genomeId);
        if (trackHub == null) {
            log.error("Could not get track hub for genome " + genomeId);
            return Collections.emptyList();
        }
        String longLabel = this.getLongLabel();
        String hubLabel = longLabel != null && longLabel.length() < 50 ? longLabel : this.getShortLabel();
        return trackHub.getGroupedTrackConfigurations(hubLabel);
    }

    private TrackDbHub getTrackDbHub(String genomeId) {
        TrackDbHub trackHub = this.trackHubMap.get(genomeId);
        if (trackHub == null && idMappings.containsKey(genomeId)) {
            trackHub = this.trackHubMap.get(idMappings.get(genomeId));
        }
        if (trackHub == null) {
            String alias = idMappings.get(genomeId);
            for (Stanza s : this.genomeStanzas) {
                if (!genomeId.equals(s.getProperty("genome")) && (alias == null || !alias.equals(s.getProperty("genome")))) continue;
                try {
                    String trackDbURL = s.getProperty("trackDb");
                    if (trackDbURL == null) {
                        log.error("No trackDb property found for genome " + genomeId);
                        return null;
                    }
                    List<Stanza> trackStanzas = HubParser.loadStanzas(trackDbURL);
                    trackHub = new TrackDbHub(trackStanzas, this.groupStanzas);
                    this.trackHubMap.put(genomeId, trackHub);
                }
                catch (IOException e) {
                    log.error("Error loading trackDb file: " + s.getProperty("trackDb"), e);
                }
            }
        }
        return trackHub;
    }

    public int getSupportedTrackCount(String genomeId) {
        TrackDbHub trackHub = this.getTrackDbHub(genomeId);
        if (trackHub == null) {
            return 0;
        }
        return trackHub.getSupportedTrackCount();
    }

    public List<GenomeConfig> getGenomeConfigs() {
        if (this.genomeConfigs == null) {
            this.genomeConfigs = new ArrayList<GenomeConfig>();
            for (Stanza genomeStanza : this.genomeStanzas) {
                TrackDbHub trackDbHub;
                GenomeConfig genomeConfig = new GenomeConfig();
                genomeConfig.id = genomeStanza.getProperty("genome");
                genomeConfig.nameSet = "ucsc";
                genomeConfig.wholeGenomeView = false;
                genomeConfig.accession = genomeStanza.getProperty("genome");
                genomeConfig.taxId = genomeStanza.getProperty("taxId");
                genomeConfig.scientificName = genomeStanza.getProperty("scientificName");
                genomeConfig.twoBitURL = genomeStanza.getProperty("twoBitPath");
                genomeConfig.defaultPos = genomeStanza.getProperty("defaultPos");
                genomeConfig.blat = genomeStanza.getProperty("blat");
                genomeConfig.chromAliasBbURL = genomeStanza.getProperty("chromAliasBb");
                genomeConfig.twoBitBptURL = genomeStanza.getProperty("twoBitBptURL");
                if (genomeConfig.twoBitBptURL == null) {
                    genomeConfig.twoBitBptURL = genomeStanza.getProperty("twoBitBptUrl");
                }
                genomeConfig.description = genomeStanza.getProperty("description");
                genomeConfig.organism = genomeStanza.getProperty("organism");
                genomeConfig.scientificName = genomeStanza.getProperty("scientificName");
                genomeConfig.infoURL = genomeStanza.getProperty("htmlPath");
                genomeConfig.chromSizesURL = genomeStanza.getProperty("chromSizes");
                if (this.isOneFile() && (trackDbHub = this.getTrackDbHub(genomeConfig.id)) != null) {
                    genomeConfig.cytobandBbURL = trackDbHub.findCytobandURL();
                }
                genomeConfig.getName();
                this.genomeConfigs.add(genomeConfig);
            }
        }
        return this.genomeConfigs;
    }
}

