/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ucsc.bb.BBFile;

public class BBFeatureSource
implements FeatureSource {
    private static Logger log = LogManager.getLogger(BBFeatureSource.class);
    private final Genome genome;
    Collection<WindowFunction> availableWindowFunctions = Arrays.asList(WindowFunction.min, WindowFunction.mean, WindowFunction.max, WindowFunction.none);
    BBFile reader;
    private int featureVisiblityWindow = -1;
    private Map<WindowFunction, List<LocusScore>> wholeGenomeScores;

    public BBFeatureSource(BBFile reader, Genome genome) throws IOException {
        this.genome = genome;
        this.reader = reader;
        this.featureVisiblityWindow = reader.getFeatureDensity() > 0.0 ? (int)(10000.0 / reader.getFeatureDensity()) : -1;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureVisiblityWindow;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            // empty if block
        }
    }

    public Iterator<IGVFeature> getFeatures(String chr, int start, int end) throws IOException {
        long rTreeOffset = this.reader.getHeader().fullIndexOffset;
        Integer chrIdx = this.reader.getIdForChr(chr);
        if (chrIdx == null) {
            return Collections.emptyIterator();
        }
        List<byte[]> chunks = this.reader.getLeafChunks(chrIdx, start, chrIdx, end, rTreeOffset);
        ArrayList<IGVFeature> features = new ArrayList<IGVFeature>();
        for (byte[] chunk : chunks) {
            features.addAll(this.reader.decodeFeatures(chr, chunk, chrIdx, start, end));
        }
        return new FeatureIterator(features, start, end);
    }

    @Override
    public boolean isSearchable() {
        return this.reader.isSearchable();
    }

    public List<IGVFeature> search(String term) {
        try {
            return this.reader.search(term);
        }
        catch (IOException e) {
            log.error("Error searching for: " + term, e);
            return null;
        }
    }

    static class FeatureIterator
    implements Iterator<IGVFeature> {
        List<IGVFeature> features;
        int idx;
        int start;
        int end;
        IGVFeature next;

        public FeatureIterator(List<IGVFeature> features, int start, int end) {
            this.features = features;
            this.start = start;
            this.end = end;
            this.advance();
        }

        private void advance() {
            if (this.idx == this.features.size()) {
                this.next = null;
            } else {
                while (this.idx < this.features.size()) {
                    this.next = this.features.get(this.idx++);
                    if (this.next.getStart() > this.end) {
                        this.next = null;
                        break;
                    }
                    if (this.next.getEnd() <= this.start) continue;
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IGVFeature next() {
            IGVFeature retValue = this.next;
            this.advance();
            return retValue;
        }
    }
}

