/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.seg;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.seg.SampleGroup;
import org.broad.igv.seg.SegmentedDataSet;
import org.broad.igv.session.RendererFactory;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.TrackFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SegTrack
extends AbstractTrack {
    private static final Logger log = LogManager.getLogger(SegTrack.class);
    SegmentedDataSet dataset;
    int sampleHeight = 15;
    int groupGap = 15;
    List<SampleGroup> sampleGroups;
    Renderer<LocusScore> renderer = new HeatmapRenderer();

    public SegTrack(ResourceLocator locator, String id, String name, SegmentedDataSet dataset, Genome genome) {
        super(locator, id, name);
        this.dataset = dataset;
        ArrayList<String> sampleNames = new ArrayList<String>(dataset.getSampleNames());
        this.sampleGroups = new ArrayList<SampleGroup>();
        this.sampleGroups.add(new SampleGroup("", sampleNames));
        this.setDataRange(new DataRange(0.0f, 1.0f, 2.0f));
        this.setTrackType(dataset.getType());
        this.initScale(dataset);
        this.groupSamplesByAttribute(null);
    }

    void initScale(SegmentedDataSet dataset) {
        float min = (float)dataset.getDataMin();
        float max = (float)dataset.getDataMax();
        boolean baseline = false;
        if (min > 0.0f) {
            min = 0.0f;
        }
        this.setDataRange(new DataRange(min, (float)baseline, max));
    }

    @Override
    public void setHeight(int height) {
        if (height <= 0) {
            return;
        }
        int nSamples = 0;
        for (SampleGroup group : this.sampleGroups) {
            nSamples += group.samples().size();
        }
        if (nSamples > 0) {
            this.sampleHeight = (height - (this.sampleGroups.size() - 1) * this.groupGap) / nSamples;
            if (this.sampleHeight < 1) {
                this.sampleHeight = 1;
            }
        }
    }

    @Override
    public int getHeight() {
        int nSamples = 0;
        for (SampleGroup group : this.sampleGroups) {
            nSamples += group.samples().size();
        }
        return nSamples * this.sampleHeight + (this.sampleGroups.size() - 1) * this.groupGap;
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int y = rect.y;
        for (SampleGroup group : this.sampleGroups) {
            for (String s : group.samples()) {
                Rectangle r = new Rectangle(rect.x, y, rect.width, this.sampleHeight);
                List<LocusScore> scores = this.dataset.getSegments(s, context.getChr());
                this.renderer.render(scores, context, r, this);
                y += this.sampleHeight;
            }
            y += this.groupGap;
        }
    }

    @Override
    public void renderAttributes(Graphics2D graphics, Rectangle trackRectangle, Rectangle visibleRect, List<String> attributeNames, List<MouseableRegion> mouseRegions) {
        AttributeManager attributeManager = AttributeManager.getInstance();
        int y = trackRectangle.y;
        for (SampleGroup group : this.sampleGroups) {
            for (String s : group.samples()) {
                if (y + this.sampleHeight > trackRectangle.y && y < trackRectangle.y + trackRectangle.height) {
                    int x = trackRectangle.x;
                    for (String name : attributeNames) {
                        String key = name.toUpperCase();
                        String attributeValue = attributeManager.getAttribute(s, key);
                        if (attributeValue != null) {
                            Rectangle rect = new Rectangle(x, y, 10, this.sampleHeight);
                            graphics.setColor(AttributeManager.getInstance().getColor(key, attributeValue));
                            graphics.fill(rect);
                            mouseRegions.add(new MouseableRegion(rect, key, attributeValue));
                        }
                        x += 11;
                    }
                }
                y += this.sampleHeight;
            }
            y += this.groupGap;
        }
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        int gap = Math.min(4, this.sampleHeight / 3);
        int fs = Math.min(this.fontSize, this.sampleHeight - gap);
        Font font = FontManager.getFont(fs);
        g2D.setFont(font);
        int y = trackRectangle.y;
        for (SampleGroup group : this.sampleGroups) {
            for (String s : group.samples()) {
                Rectangle r = new Rectangle(trackRectangle.x, y, trackRectangle.width, this.sampleHeight);
                GraphicUtils.drawWrappedText(s, r, g2D, false);
                y += this.sampleHeight;
            }
            y += this.groupGap;
        }
    }

    @Override
    public void sortSamplesByAttribute(Comparator<String> comparator) {
        for (SampleGroup group : this.sampleGroups) {
            group.samples().sort(comparator);
        }
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            if (Renderer.class.isAssignableFrom(rc)) {
                this.renderer = (Renderer)rc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception ex) {
            log.error("Error instantiating renderer ", ex);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = TrackMenuUtils.getPopupMenu(Collections.singletonList(this), "Menu", te);
        menu.addSeparator();
        TrackMenuUtils.addDataRendererItems(menu, Arrays.asList("Heatmap", "Bar Chart", "Points", "Line Plot"), Collections.singletonList(this));
        return menu;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        int trackY = mouseY - this.getY();
        int y = 0;
        for (SampleGroup group : this.sampleGroups) {
            int groupPixelHeight = group.samples().size() * this.sampleHeight;
            if (trackY >= y && trackY < y + groupPixelHeight) {
                int sampleIndex = (trackY - y) / this.sampleHeight;
                String sampleName = group.samples().get(sampleIndex);
                StringBuilder buf = new StringBuilder();
                LocusScore score = this.dataset.getSegmentAt(sampleName, chr, position, frame);
                if (score == null) {
                    return null;
                }
                buf.append(sampleName).append("<br>");
                if (this.getDataRange() != null && this.getRenderer() instanceof XYPlotRenderer) {
                    buf.append("Data scale: ").append(this.getDataRange().getMinimum()).append(" - ").append(this.getDataRange().getMaximum()).append("<br>");
                }
                buf.append(score.getValueString(position, mouseX, this.getWindowFunction()));
                return buf.toString();
            }
            if (trackY < y + groupPixelHeight + this.groupGap) {
                return null;
            }
            y += groupPixelHeight + this.groupGap;
        }
        return null;
    }

    @Override
    public int sampleCount() {
        int count = 0;
        for (SampleGroup group : this.sampleGroups) {
            count += group.samples().size();
        }
        return count;
    }

    @Override
    public void sortSamplesByValue(String chr, int start, int end, RegionScoreType type) {
        if (end <= start) {
            return;
        }
        for (SampleGroup group : this.sampleGroups) {
            HashMap<String, Float> sampleScores = new HashMap<String, Float>();
            for (String s : group.samples()) {
                List<LocusScore> scores = this.dataset.getSegments(s, chr);
                float regionScore = 0.0f;
                int intervalSum = 0;
                boolean hasNan = false;
                for (LocusScore score : scores) {
                    if (score.getEnd() < start || score.getStart() > end) continue;
                    int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                    float value = score.getScore();
                    if (Float.isNaN(value)) {
                        hasNan = true;
                        continue;
                    }
                    regionScore += value * (float)interval;
                    intervalSum += interval;
                }
                if (intervalSum <= 0) {
                    if (hasNan) {
                        sampleScores.put(s, Float.valueOf(Float.NaN));
                        continue;
                    }
                    sampleScores.put(s, Float.valueOf(-3.4028235E38f));
                    continue;
                }
                sampleScores.put(s, Float.valueOf(type == RegionScoreType.DELETION ? -regionScore : (regionScore /= (float)intervalSum)));
            }
            group.samples().sort((o1, o2) -> {
                Float v1 = (Float)sampleScores.get(o1);
                Float v2 = (Float)sampleScores.get(o2);
                if (v1.isNaN()) {
                    return v2.isNaN() ? 0 : 1;
                }
                if (v2.isNaN()) {
                    return -1;
                }
                return -Float.compare(v1.floatValue(), v2.floatValue());
            });
        }
    }

    @Override
    public boolean isFilterable() {
        return false;
    }

    @Override
    public void filterSamples(TrackFilter trackFilter) {
        if (trackFilter == null || trackFilter.isShowAll()) {
            ArrayList<String> sampleNames = new ArrayList<String>(this.dataset.getSampleNames());
            this.sampleGroups.clear();
            this.sampleGroups.add(new SampleGroup("All Samples", sampleNames));
        } else {
            List<String> filteredSamples = trackFilter.evaluateSamples(this.dataset.getSampleNames());
            this.sampleGroups.clear();
            this.sampleGroups.add(new SampleGroup("Filtered Samples", filteredSamples));
        }
    }

    @Override
    public void groupSamplesByAttribute(String attributeKey) {
        if (attributeKey == null && IGV.hasInstance()) {
            attributeKey = IGV.getInstance().getGroupByAttribute();
        }
        this.sampleGroups.clear();
        if (attributeKey == null) {
            ArrayList<String> sampleNames = new ArrayList<String>(this.dataset.getSampleNames());
            this.sampleGroups.add(new SampleGroup("", sampleNames));
            this.repaint();
        } else {
            AttributeManager attributeManager = AttributeManager.getInstance();
            LinkedHashMap<String, List> groupMap = new LinkedHashMap<String, List>();
            for (String sample : this.dataset.getSampleNames()) {
                String attributeValue = attributeManager.getAttribute(sample, attributeKey.toUpperCase());
                if (attributeValue == null) {
                    attributeValue = "";
                }
                List samples = groupMap.computeIfAbsent(attributeValue, k -> new ArrayList());
                samples.add(sample);
            }
            for (String key : groupMap.keySet()) {
                this.sampleGroups.add(new SampleGroup(key, (List)groupMap.get(key)));
            }
        }
        this.repaint();
    }

    @Override
    public void marshalXML(Document document, Element element) {
        RendererFactory.RendererType type;
        super.marshalXML(document, element);
        if (this.renderer != null && (type = RendererFactory.getRenderType(this.renderer)) != null) {
            element.setAttribute("renderer", type.name());
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        Class rendererClass;
        super.unmarshalXML(element, version);
        if (element.hasAttribute("renderer") && (rendererClass = RendererFactory.getRendererClass(element.getAttribute("renderer"))) != null) {
            try {
                this.renderer = (DataRenderer)rendererClass.newInstance();
            }
            catch (Exception e) {
                log.error("Error instantiating renderer: " + rendererClass.getName(), e);
            }
        }
    }

    public static boolean isSegFile(String pathOrURL) {
        String path;
        try {
            URL url = new URL(pathOrURL);
            path = url.getPath();
        }
        catch (MalformedURLException e) {
            path = pathOrURL;
        }
        String lowerPath = path.toLowerCase();
        return lowerPath.endsWith(".seg") || lowerPath.endsWith(".seg.gz");
    }
}

