/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.cram;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.broad.igv.DirectoryManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.util.HttpUtils;

public class ReferenceDiskCache {
    private static Logger log = LogManager.getLogger(ReferenceDiskCache.class);
    private static final ExecutorService threadExecutor = Executors.newFixedThreadPool(1);

    public static void saveSequence(String genomeId, String chr, byte[] bytes) throws IOException {
        threadExecutor.submit(() -> {
            File cacheDir = ReferenceDiskCache.getCacheDirectory();
            FileOutputStream fos = null;
            File outputFile = new File(cacheDir, ReferenceDiskCache.getFileName(genomeId, chr));
            try {
                FileOutputStream out = new FileOutputStream(outputFile);
                LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream((OutputStream)out);
                dos.writeInt(bytes.length);
                DeflaterOutputStream gzipOutputStream = new DeflaterOutputStream(out);
                gzipOutputStream.write(bytes);
                gzipOutputStream.flush();
                gzipOutputStream.close();
                ReferenceDiskCache.checkCacheSize();
            }
            catch (Exception e) {
                log.error("Error saving CRAM reference sequence", e);
                outputFile.delete();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readSequence(String genomeId, String chr) throws IOException {
        File cacheDirectory = ReferenceDiskCache.getCacheDirectory();
        File seqFile = new File(cacheDirectory, ReferenceDiskCache.getFileName(genomeId, chr));
        if (!seqFile.exists()) {
            return null;
        }
        try (FileInputStream fis = null;){
            fis = new FileInputStream(seqFile);
            LittleEndianDataInputStream dis = new LittleEndianDataInputStream((InputStream)fis);
            int size = dis.readInt();
            InflaterInputStream gis = new InflaterInputStream(fis);
            byte[] buffer = new byte[size];
            HttpUtils.readFully(gis, buffer);
            byte[] byArray = buffer;
            return byArray;
        }
    }

    private static File getCacheDirectory() {
        String rootDirectoryString = PreferencesManager.getPreferences().get("CRAM.CACHE_DIRECTORY");
        File rootDirectory = rootDirectoryString != null ? new File(rootDirectoryString) : new File(DirectoryManager.getIgvDirectory(), "cram");
        if (!rootDirectory.exists()) {
            rootDirectory.mkdir();
        }
        return rootDirectory;
    }

    private static synchronized void checkCacheSize() {
        File cacheDir = ReferenceDiskCache.getCacheDirectory();
        if (!cacheDir.exists()) {
            return;
        }
        File[] files = cacheDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".bin"));
        Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
        int maxSize = PreferencesManager.getPreferences().getAsInt("CRAM.CACHE_SIZE") * 1000;
        int totalSize = 0;
        for (File f : files) {
            if (totalSize > maxSize) {
                f.delete();
                continue;
            }
            totalSize = (int)((long)totalSize + f.length());
        }
    }

    public static void deleteCache(String genomeId, String chr) {
        new File(ReferenceDiskCache.getFileName(genomeId, chr)).delete();
    }

    private static String getFileName(String genomeId, String chr) {
        return String.valueOf(genomeId.hashCode()) + "-" + chr + ".bin";
    }
}

