/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.oauth;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.HashMap;
import java.util.UUID;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.oauth.OAuthURLForm;
import org.broad.igv.oauth.PKCEUtils;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.GoogleUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.JWTParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class OAuthProvider {
    private static Logger log = LogManager.getLogger(OAuthProvider.class);
    private static int TOKEN_EXPIRE_GRACE_TIME = 60000;
    private String authProvider = "";
    private String appIdURI;
    public static String findString = null;
    public static String replaceString = null;
    private String state = UUID.randomUUID().toString();
    private String redirectURI;
    private String clientId;
    private String clientSecret;
    private String authEndpoint;
    private String tokenEndpoint;
    private String accessToken;
    private String refreshToken;
    private String codeChallenge;
    private String codeVerifier;
    private String codeChallengeMethod;
    private long expirationTime;
    private String scope;
    private String[] hosts;
    private String currentUserName;
    private String currentUserID;
    private String currentUserEmail;
    private JSONObject response;

    public OAuthProvider(JSONObject obj) throws IOException {
        if (obj.has("installed") && !obj.has("client_id")) {
            obj = obj.getJSONObject("installed");
        }
        if (!obj.has("client_id") || !obj.has("auth_uri") && !obj.has("authorization_endpoint") || !obj.has("token_uri") && !obj.has("token_endpoint")) {
            throw new RuntimeException("oauthConfig is missing crucial attributes such as: client_id, client_secret,  authorization_endpoint/auth_uri, or token_endpoint/token_uri.");
        }
        this.clientId = obj.getString("client_id");
        this.authEndpoint = obj.has("auth_uri") ? obj.getString("auth_uri") : obj.getString("authorization_endpoint");
        this.tokenEndpoint = obj.has("token_uri") ? obj.getString("token_uri") : obj.getString("token_endpoint");
        String string = this.clientSecret = obj.has("client_secret") ? obj.getString("client_secret") : null;
        if (obj.has("auth_provider")) {
            this.authProvider = obj.getString("auth_provider");
        }
        if (obj.has("scope")) {
            this.scope = obj.getString("scope");
        } else if (this.isGoogle()) {
            String gsScope = "https://www.googleapis.com/auth/devstorage.read_only";
            String emailScope = "https://www.googleapis.com/auth/userinfo.email";
            this.scope = gsScope + "%20" + emailScope;
        }
        String string2 = obj.has("app_id_uri") ? obj.getString("app_id_uri") : (this.appIdURI = obj.has("resource") ? obj.getString("resource") : null);
        if (obj.has("hosts")) {
            Object hostsObj = obj.get("hosts");
            if (hostsObj instanceof JSONArray) {
                JSONArray hostsArrJson = (JSONArray)hostsObj;
                this.hosts = new String[hostsArrJson.length()];
                for (int i = 0; i < hostsArrJson.length(); ++i) {
                    this.hosts[i] = hostsArrJson.getString(i);
                }
            } else {
                this.hosts = new String[1];
                this.hosts[0] = obj.getString("hosts");
            }
        }
        if (obj.has("redirect_uris")) {
            JSONArray urisArray = obj.getJSONArray("redirect_uris");
            this.redirectURI = urisArray.getString(0);
        } else if (obj.has("redirect_uri")) {
            this.redirectURI = obj.getString("redirect_uri");
        } else {
            String portNumber = PreferencesManager.getPreferences().getPortNumber();
            this.redirectURI = "http://localhost:" + portNumber + "/oauthCallback";
        }
        this.codeVerifier = PKCEUtils.generateCodeVerifier();
        try {
            this.codeChallenge = PKCEUtils.generateCodeChallange(this.codeVerifier);
            this.codeChallengeMethod = "S256";
        }
        catch (Exception e) {
            this.codeChallenge = this.codeVerifier;
            this.codeChallengeMethod = "plain";
            log.error("Error encoding PKCE challenge", e);
        }
        findString = obj.has("find_string") ? obj.getString("find_string") : null;
        replaceString = obj.has("replace_string") ? obj.getString("replace_string") : null;
    }

    public String getState() {
        return this.state;
    }

    public void openAuthorizationPage() throws IOException, URISyntaxException {
        if (!CommandListener.isListening()) {
            CommandListener.start();
        }
        if (!CommandListener.isListening()) {
            String ac = MessageUtils.showInputDialog("The IGV port listener is off and is required for OAuth authentication through IGV<br/>.  If you have an access token obtained by other means enter it here.");
            if (ac != null) {
                this.setAccessToken(ac);
            }
        } else {
            Desktop desktop;
            String url = this.authEndpoint + "?state=" + this.state + "&redirect_uri=" + URLEncoder.encode(this.redirectURI, "utf-8") + "&client_id=" + this.clientId + "&response_type=code&code_challenge=" + this.codeChallenge + "&code_challenge_method=" + this.codeChallengeMethod;
            if (this.scope != null) {
                url = url + "&scope=" + this.scope;
            }
            if (this.appIdURI != null) {
                url = url + "&resource=" + this.appIdURI;
            }
            if ((desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
            } else {
                OAuthURLForm.open(IGV.getInstance().getMainFrame(), url);
            }
        }
    }

    public void fetchAccessToken(String authorizationCode) throws IOException {
        URL url = HttpUtils.createURL(this.tokenEndpoint);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", authorizationCode);
        params.put("client_id", this.clientId);
        if (this.clientSecret != null) {
            params.put("client_secret", this.clientSecret);
        }
        params.put("state", this.state);
        params.put("redirect_uri", this.redirectURI);
        params.put("grant_type", "authorization_code");
        params.put("code_verifier", this.codeVerifier);
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        try {
            String res = HttpUtils.getInstance().doPost(url, params);
            this.response = new JSONObject(res);
            this.accessToken = this.response.getString("access_token");
            this.refreshToken = this.response.getString("refresh_token");
            this.expirationTime = System.currentTimeMillis() + (long)(this.response.getInt("expires_in") * 1000);
            if (this.response.has("id_token")) {
                JSONObject payload = JWTParser.getPayload(this.response.getString("id_token"));
                this.fetchUserProfile(payload);
            }
            if (this.isLoggedIn()) {
                IGVEventBus.getInstance().post(new AuthStateEvent(true, this.authProvider, this.getCurrentUserName()));
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private void refreshAccessToken() throws IOException {
        log.debug("Refresh access token");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh_token", this.refreshToken);
        params.put("client_id", this.clientId);
        if (this.clientSecret != null) {
            params.put("client_secret", this.clientSecret);
        }
        params.put("grant_type", "refresh_token");
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        URL url = HttpUtils.createURL(this.tokenEndpoint);
        String responseString = HttpUtils.getInstance().doPost(url, params);
        this.response = new JSONObject(responseString);
        if (this.response.has("access_token")) {
            this.accessToken = this.response.getString("access_token");
            if (this.response.has("refresh_token")) {
                this.refreshToken = this.response.getString("refresh_token");
            }
            this.expirationTime = System.currentTimeMillis() + (long)(this.response.getInt("expires_in") * 1000);
        } else {
            this.logout();
            try {
                this.openAuthorizationPage();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public JSONObject fetchUserProfile(JSONObject jwt_payload) {
        try {
            String string = this.currentUserName = jwt_payload.has("name") ? jwt_payload.getString("name") : null;
            if (this.currentUserName == null && jwt_payload.has("cognito:username")) {
                this.currentUserName = jwt_payload.getString("cognito:username");
            }
            this.currentUserEmail = jwt_payload.has("email") ? jwt_payload.getString("email") : null;
            this.currentUserID = jwt_payload.has("id") ? jwt_payload.getString("id") : null;
            return jwt_payload;
        }
        catch (Throwable exception) {
            log.error(exception);
            return null;
        }
    }

    public String getAccessToken() {
        if (this.accessToken == null || System.currentTimeMillis() > this.expirationTime - (long)TOKEN_EXPIRE_GRACE_TIME) {
            log.debug("Refreshing access token!");
            if (this.refreshToken != null) {
                try {
                    this.refreshAccessToken();
                }
                catch (IOException e) {
                    log.error("Error fetching access token", e);
                }
            }
        }
        return this.accessToken;
    }

    public Duration getExpirationTime() {
        Duration expiration = Duration.ofMillis(this.expirationTime - System.currentTimeMillis());
        log.debug("Current expiration time of credentials (and presigned urls is): " + expiration.toSeconds() + " seconds and expirationTime in class is: " + this.expirationTime);
        return expiration;
    }

    public boolean isLoggedIn() {
        return this.accessToken != null;
    }

    public String getCurrentUserName() {
        return this.currentUserName != null ? this.currentUserName : (this.currentUserEmail != null ? this.currentUserEmail : this.currentUserID);
    }

    public String getCurrentUserEmail() {
        return this.currentUserEmail;
    }

    public void logout() {
        this.accessToken = null;
        this.refreshToken = null;
        this.expirationTime = -1L;
        this.currentUserName = null;
        IGVEventBus.getInstance().post(new AuthStateEvent(false, this.authProvider, null));
    }

    public JSONObject getAuthorizationResponse() {
        if (this.response == null) {
            this.checkLogin();
        }
        return this.response;
    }

    public synchronized void checkLogin() {
        if (!this.isLoggedIn()) {
            try {
                this.openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error("Error fetching oAuth tokens", ex);
            }
        }
        int i = 0;
        while (!this.isLoggedIn() && i < 1200) {
            ++i;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean appliesToUrl(URL url) {
        if (this.hosts != null && this.hosts.length > 0) {
            for (String host : this.hosts) {
                if (url.getHost() == null || !url.getHost().equals(host)) continue;
                return true;
            }
        }
        if (this.isGoogle()) {
            return GoogleUtils.isGoogleURL(url.toExternalForm());
        }
        return false;
    }

    public boolean isGoogle() {
        return this.authEndpoint.contains("accounts.google.com");
    }

    public void setAuthProvider(String authProvider) {
        this.authProvider = authProvider;
    }

    public String getAuthProvider() {
        return this.authProvider;
    }

    public record AuthStateEvent(boolean authenticated, String authProvider, String userName) implements IGVEvent
    {
    }
}

