/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.util.LinkedHashMap;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;

public class EncodePeakCodec
extends UCSCCodec {
    Genome genome;

    public EncodePeakCodec() {
        this((Genome)null);
    }

    public EncodePeakCodec(Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
    }

    public BasicFeature decode(String[] tokens) {
        int strandChar;
        int tokenCount = tokens.length;
        if (tokenCount < 9) {
            return null;
        }
        String c = tokens[0];
        String chr = this.genome == null ? c : this.genome.getCanonicalChrName(c);
        int start = Integer.parseInt(tokens[1]);
        int end = Integer.parseInt(tokens[2]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        feature.setName(tokens[3]);
        feature.setScore(Float.parseFloat(tokens[4]));
        String strandString = tokens[5].trim();
        int n = strandChar = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        Strand strand = strandChar == 45 ? Strand.NEGATIVE : (strandChar == 43 ? Strand.POSITIVE : Strand.NONE);
        feature.setStrand(strand);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (tokens.length > 6) {
            attributes.put("signalValue", tokens[6]);
        }
        if (tokens.length > 7) {
            attributes.put("pValue", tokens[7]);
        }
        if (tokens.length > 8) {
            attributes.put("qValue", tokens[8]);
        }
        if (tokens.length > 9) {
            attributes.put("peak", tokens[9]);
        }
        feature.setAttributes(attributes);
        return feature;
    }

    public boolean canDecode(String s) {
        return s.toLowerCase().endsWith("peak");
    }
}

