/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.HttpUtils;

public class SeekableServiceStream
extends SeekableStream {
    static Logger log = LogManager.getLogger(SeekableServiceStream.class);
    public static final String WEBSERVICE_URL = "https://igv.org/genomes/range.php";
    private long position = 0L;
    private long contentLength = Long.MAX_VALUE;
    private URL wrappedURL;

    public SeekableServiceStream(URL url) {
        this.wrappedURL = url;
    }

    public long length() {
        if (this.contentLength == Long.MAX_VALUE) {
            try {
                this.contentLength = HttpUtils.getInstance().getContentLength(this.wrappedURL);
            }
            catch (IOException e) {
                log.error("Error fetching content length for: " + String.valueOf(this.wrappedURL), e);
            }
        }
        return this.contentLength;
    }

    public boolean eof() throws IOException {
        return this.position >= this.contentLength;
    }

    public String getSource() {
        return this.wrappedURL.toExternalForm();
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public long skip(long n) throws IOException {
        this.position += n;
        return n;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n;
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        URL url = HttpUtils.createURL("https://igv.org/genomes/range.php?file=" + this.wrappedURL.toExternalForm() + "&position=" + this.position + "&length=" + length);
        try (InputStream is = null;){
            int count;
            is = HttpUtils.getInstance().openConnectionStream(url);
            for (n = 0; n < length; n += count) {
                count = is.read(buffer, offset + n, length - n);
                if (count >= 0) continue;
                int n2 = n;
                return n2;
            }
            this.position += (long)n;
            count = n;
            return count;
        }
    }

    public void close() throws IOException {
    }

    public byte[] readBytes(long position, int nBytes) throws IOException {
        this.position = position;
        byte[] buffer = new byte[nBytes];
        this.read(buffer, 0, nBytes);
        return buffer;
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableServiceStream.  Must read in blocks.");
    }
}

