/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import htsjdk.tribble.util.URLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.stream.IGVUrlHelperFactory;

public class IGVUrlHelper
implements URLHelper {
    static Logger log = LogManager.getLogger(IGVUrlHelperFactory.class);
    URL url;
    private static Map<URL, Long> contentLengths = new HashMap<URL, Long>();

    public IGVUrlHelper(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public long getContentLength() throws IOException {
        if (contentLengths.containsKey(this.url)) {
            return contentLengths.get(this.url);
        }
        long length = HttpUtils.getInstance().getContentLength(this.url);
        contentLengths.put(this.url, length);
        return length;
    }

    public InputStream openInputStream() throws IOException {
        return HttpUtils.getInstance().openConnectionStream(this.url);
    }

    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        String byteRange = "bytes=" + start + "-" + end;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Range", byteRange);
        URL url = this.addStartEndQueryString(start, end);
        return HttpUtils.getInstance().openConnectionStream(url, params);
    }

    private URL addStartEndQueryString(long start, long end) throws MalformedURLException {
        String surl = this.url.toExternalForm();
        Object nurl = surl;
        String toadd = String.format("start=%d&end=%d", start, end);
        String[] parts = surl.split("\\?", 2);
        if (parts.length == 2) {
            nurl = String.format("%s?%s", parts[0], toadd);
            nurl = (String)nurl + "&" + parts[1];
        }
        if (log.isTraceEnabled()) {
            log.trace("old url: " + surl);
            log.trace("HttpUtils.createURL: " + (String)nurl);
        }
        return HttpUtils.createURL((String)nurl);
    }

    public boolean exists() {
        boolean exists = HttpUtils.getInstance().resourceAvailable(this.url.toExternalForm());
        return exists;
    }
}

