/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.function.Consumer;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.StringUtils;

public class RuntimeUtils {
    private static Logger log = LogManager.getLogger(RuntimeUtils.class);

    public static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return freeMemory + (maxMemory - allocatedMemory);
    }

    public static double getAvailableMemoryFraction() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (double)(freeMemory + (maxMemory - allocatedMemory)) / (double)maxMemory;
    }

    public static String exec(String command) throws IOException, InterruptedException {
        String line;
        Process process;
        List<String> commandArgs = StringUtils.breakQuotedString(command, ' ');
        if (commandArgs.size() == 1) {
            process = Runtime.getRuntime().exec(command);
        } else {
            String[] args = commandArgs.toArray(new String[0]);
            process = Runtime.getRuntime().exec(args);
        }
        StringBuilder results = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            results.append(line);
            results.append('\n');
        }
        reader.close();
        StringBuilder errors = new StringBuilder();
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((line = errorReader.readLine()) != null) {
            errors.append(line);
            errors.append('\n');
        }
        errorReader.close();
        int exitValue = process.waitFor();
        if (exitValue != 0) {
            throw new RuntimeException(errorReader.toString());
        }
        process.destroy();
        return results.toString();
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

