/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.util.collections.CollUtils;

public class FilterElement {
    private String attributeKey;
    private Operator comparisonOperator = Operator.EQUAL;
    private String expectedValue;
    private BooleanOperator booleanOperator = BooleanOperator.AND;

    public FilterElement(String attributeKey, Operator comparisonOperator, String expectedValue) {
        if (attributeKey != null) {
            this.attributeKey = attributeKey.trim();
        }
        if (comparisonOperator != null) {
            this.comparisonOperator = comparisonOperator;
        }
        if (expectedValue != null) {
            this.expectedValue = new String(expectedValue).toUpperCase().trim();
        }
    }

    public String toString() {
        return "FilterElement{attributeKey='" + this.attributeKey + "', comparisonOperator=" + String.valueOf(this.comparisonOperator) + ", expectedValue='" + this.expectedValue + "}";
    }

    public boolean test(String attributeValue) {
        boolean result = false;
        if (this.expectedValue == null) {
            this.expectedValue = "";
        }
        if (attributeValue == null) {
            attributeValue = "";
        }
        attributeValue = attributeValue.toUpperCase().trim();
        boolean isComparableNumeric = this.isNumber(attributeValue);
        boolean isExpectedValueNumeric = this.isNumber(this.expectedValue);
        int comparison = 0;
        if (isComparableNumeric && isExpectedValueNumeric) {
            Double number1 = Double.parseDouble(attributeValue);
            Double number2 = Double.parseDouble(this.expectedValue);
            comparison = number1.compareTo(number2);
        } else if (isExpectedValueNumeric && attributeValue.equals("")) {
            Double number1 = Double.MIN_VALUE;
            Double number2 = Double.parseDouble(this.expectedValue);
            comparison = number1.compareTo(number2);
        } else {
            comparison = attributeValue.compareTo(this.expectedValue);
        }
        if (this.comparisonOperator.equals(Operator.EQUAL)) {
            result = comparison == 0;
        } else if (this.comparisonOperator.equals(Operator.NOT_EQUAL)) {
            result = comparison != 0;
        } else if (this.comparisonOperator.equals(Operator.GREATER_THAN)) {
            result = comparison > 0;
        } else if (this.comparisonOperator.equals(Operator.LESS_THAN)) {
            result = comparison < 0;
        } else if (this.comparisonOperator.equals(Operator.GREATER_THAN_OR_EQUAL)) {
            result = comparison >= 0;
        } else if (this.comparisonOperator.equals(Operator.LESS_THAN_OR_EQUAL)) {
            result = comparison <= 0;
        } else if (this.comparisonOperator.equals(Operator.CONTAINS)) {
            result = attributeValue.indexOf(this.expectedValue) != -1;
        } else if (this.comparisonOperator.equals(Operator.DOES_NOT_CONTAIN)) {
            result = attributeValue.indexOf(this.expectedValue) == -1;
        } else if (this.comparisonOperator.equals(Operator.STARTS_WITH)) {
            result = attributeValue.startsWith(this.expectedValue);
        }
        return result;
    }

    public Operator getComparisonOperator() {
        return this.comparisonOperator;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public String getValue() {
        return this.expectedValue;
    }

    public boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).equals("")) {
            return false;
        }
        char[] charcters = string.toCharArray();
        boolean withDecimal = false;
        boolean isNegative = false;
        int len = charcters.length;
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(charcters[i])) continue;
            if (charcters[i] == '.') {
                if (withDecimal) {
                    return false;
                }
                withDecimal = true;
                continue;
            }
            if (charcters[i] == '-') {
                if (isNegative) {
                    return false;
                }
                if (i == 0) {
                    isNegative = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean evaluate(Track track) {
        String attributeKey = this.getAttributeKey();
        String attribute = track.getAttributeValue(attributeKey);
        return this.test(attribute);
    }

    public boolean evaluateSample(String sample) {
        String attributeKey = this.getAttributeKey();
        String attribute = AttributeManager.getInstance().getAttribute(sample, attributeKey);
        return this.test(attribute);
    }

    public static enum Operator implements CollUtils.Valued
    {
        EQUAL("is equal to"),
        NOT_EQUAL("is not equal to"),
        GREATER_THAN("is greater than"),
        LESS_THAN("is less than"),
        GREATER_THAN_OR_EQUAL("is greater than or equal to"),
        LESS_THAN_OR_EQUAL("is less than or equal to"),
        STARTS_WITH("starts with"),
        CONTAINS("contains"),
        DOES_NOT_CONTAIN("does not contain");

        String value;

        private Operator(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum BooleanOperator {
        AND("AND"),
        OR("OR");

        String value;

        private BooleanOperator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

