/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ultima.render;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import java.awt.Color;
import java.awt.Graphics2D;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ultima.render.ColorMap;

public class FlowIndelRendering {
    private static final String TAG_T0 = "t0";
    private static final String ATTR_TP = "tp";
    private static final String RG_ATTR_PL = "PL";
    private static final String RG_ATTR_MC = "mc";
    private static final String RG_ATTR_PL_ULTIMA = "ULTIMA";
    private static final double MIN_POSSIBLE_QUALITY = 0.0;
    public static final int COLORMAP_SIZE = 44;
    private static ColorMap indelColorMap = ColorMap.getJet(44);

    public boolean handlesAlignment(Alignment alignment) {
        if (!(alignment instanceof SAMAlignment)) {
            return false;
        }
        return FlowIndelRendering.isFlow(((SAMAlignment)alignment).getRecord());
    }

    public static boolean isFlow(SAMRecord record) {
        SAMReadGroupRecord readGroup = record.getReadGroup();
        if (readGroup == null) {
            return false;
        }
        if (!RG_ATTR_PL_ULTIMA.equals(readGroup.getAttribute(RG_ATTR_PL)) && readGroup.getAttribute(RG_ATTR_MC) == null) {
            return false;
        }
        return record.hasAttribute(ATTR_TP);
    }

    public boolean handlesBlock(AlignmentBlock block) {
        return true;
    }

    public boolean handlesGap(Gap gap) {
        return true;
    }

    public void renderSmallInsertion(Alignment alignment, AlignmentBlock block, RenderContext context, int h, int x, int y, AlignmentTrack.RenderOptions renderOptions) {
        int pxWing = h > 10 ? 2 : (h > 5 ? 1 : 0);
        int hairline = 2;
        if (renderOptions.isIndelQualColoring()) {
            pxWing = Math.min(pxWing, Math.max(1, (int)(1.0 / context.getScale())));
            hairline = Math.min(hairline, pxWing);
        }
        Graphics2D g = context.getGraphics();
        g.fillRect(x, y, hairline, h);
        g.fillRect(x - pxWing, y, hairline + 2 * pxWing, hairline);
        g.fillRect(x - pxWing, y + h - hairline, hairline + 2 * pxWing, hairline);
        double q = this.getInsertionQuality(alignment, block, renderOptions);
        if (!Double.isNaN(q) && renderOptions.isIndelQualColoring()) {
            Color currentColor = g.getColor();
            g.setColor(new Color(indelColorMap.getColor((int)q)));
            g.fillRect(x - pxWing, (int)((double)y + (double)(h - hairline) * ((42.0 - q) / 42.0)) - 1, hairline + 2 * pxWing, hairline * 2);
            g.setColor(currentColor);
        }
    }

    public void renderSmallInsertionWings(Alignment alignment, AlignmentBlock block, RenderContext context, int pxH, int pxTop, int pxRight, int pxLeft, AlignmentTrack.RenderOptions renderOptions) {
        int pxWing = pxH > 10 ? 2 : 1;
        Graphics2D g = context.getGraphics();
        int hairline = 2;
        double locScale = context.getScale();
        if (renderOptions.isIndelQualColoring()) {
            pxWing = Math.min(pxWing, Math.max(1, (int)(1.0 / locScale)));
            hairline = Math.min(hairline, pxWing);
        }
        Color currentColor = g.getColor();
        g.setColor(AlignmentRenderer.purple);
        g.fillRect(pxLeft - pxWing, pxTop, pxRight - pxLeft + hairline * pxWing, hairline);
        g.fillRect(pxLeft - pxWing, pxTop + pxH - hairline, pxRight - pxLeft + hairline * pxWing, hairline);
        g.setColor(currentColor);
        double q = this.getInsertionQuality(alignment, block, renderOptions);
        if (!Double.isNaN(q) && renderOptions.isIndelQualColoring()) {
            currentColor = g.getColor();
            g.setColor(new Color(indelColorMap.getColor((int)q)));
            g.fillRect(pxLeft - pxWing, (int)((double)pxTop + (double)(pxH - hairline) * ((42.0 - q) / 42.0)), pxRight - pxLeft + hairline * pxWing, hairline);
            g.setColor(currentColor);
        }
    }

    public void renderDeletionGap(Alignment alignment, Gap gap, int y, int h, int x, int w, RenderContext context, AlignmentTrack.RenderOptions renderOptions) {
        if (!renderOptions.isIndelQualColoring()) {
            return;
        }
        AlignmentBlock[] blocks = this.getGapWrappingBlocks(alignment, gap);
        if (blocks == null) {
            return;
        }
        AlignmentBlock abPrev = blocks[0];
        AlignmentBlock abNext = blocks[1];
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        char nextBlcokFirstBase = Character.toUpperCase((char)abNext.getBases().getByte(0));
        char gapLastBase = Character.toUpperCase((char)genome.getReference(alignment.getChr(), gap.getStart() + gap.getnBases() - 1));
        boolean isForwardHmer = gapLastBase == nextBlcokFirstBase;
        char prevBlcokLastBase = Character.toUpperCase((char)abPrev.getBases().getByte(abPrev.getBasesLength() - 1));
        char gapFirstBase = Character.toUpperCase((char)genome.getReference(alignment.getChr(), gap.getStart()));
        boolean isBackwardsHmer = gapFirstBase == prevBlcokLastBase;
        boolean isHmer = isBackwardsHmer ^ isForwardHmer;
        if (isHmer) {
            isHmer = this.gapIsAllSameBase(genome, alignment, gap);
        }
        double q = Double.NaN;
        if (isHmer) {
            Hmer hmer;
            record = ((SAMAlignment)alignment).getRecord();
            Hmer hmer2 = hmer = isForwardHmer ? this.findHmer(record, abNext.getIndexOnRead(), (byte)gapLastBase, false, true) : this.findHmer(record, abPrev.getIndexOnRead() + abPrev.getBasesLength() - 1, (byte)gapFirstBase, true, false);
            q = hmer.size() >= this.getMC(record) ? 0.0 : this.getQualityFromTP(record, hmer, gap.getnBases(), renderOptions);
        } else if (gap.getnBases() == 1) {
            record = ((SAMAlignment)alignment).getRecord();
            double qBefore = this.getQualityFromT0(record, abPrev, false);
            double qAfter = this.getQualityFromT0(record, abNext, true);
            q = Double.isNaN(qBefore) ? qAfter : (Double.isNaN(qAfter) ? qBefore : Math.max(qBefore, qAfter));
        }
        if (Double.isNaN(q)) {
            return;
        }
        int hairline = Math.min(2, (int)(1.0 / context.getScale()));
        Graphics2D g = context.getGraphics();
        Color currentColor = g.getColor();
        g.setColor(new Color(indelColorMap.getColor((int)q)));
        g.fillRect(x + (int)((double)w * q / 42.0) - hairline, y, hairline * 2, h);
        g.setColor(currentColor);
    }

    private double getInsertionQuality(Alignment alignment, AlignmentBlock block, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentBlock[] blocks = this.getBlockWrappingBlocks(alignment, block);
        if (blocks == null) {
            return Double.NaN;
        }
        AlignmentBlock abPrev = blocks[0];
        AlignmentBlock abNext = blocks[1];
        char nextBlcokFirstBase = Character.toUpperCase((char)abNext.getBases().getByte(0));
        char blockLastBase = Character.toUpperCase((char)block.getBases().getByte(block.getBasesLength() - 1));
        boolean isForwardHmer = blockLastBase == nextBlcokFirstBase;
        char prevBlcokLastBase = Character.toUpperCase((char)abPrev.getBases().getByte(abPrev.getBasesLength() - 1));
        char blockFirstBase = Character.toUpperCase((char)block.getBases().getByte(0));
        boolean isBackwardsHmer = blockFirstBase == prevBlcokLastBase;
        boolean isHmer = isBackwardsHmer ^ isForwardHmer;
        if (isHmer) {
            isHmer = this.blockIsAllSameBase(block);
        }
        SAMRecord record = ((SAMAlignment)alignment).getRecord();
        Double q = Double.NaN;
        if (!isBackwardsHmer && !isForwardHmer && block.getBasesLength() == 1) {
            Hmer hmer = new Hmer();
            hmer.start = hmer.end = block.getIndexOnRead();
            q = this.getQualityFromTP(record, hmer, -hmer.size(), renderOptions);
            return q;
        }
        if (!isHmer) {
            return Double.NaN;
        }
        if (isForwardHmer) {
            Hmer hmer = this.findHmer(record, abNext.getIndexOnRead(), (byte)nextBlcokFirstBase, true, true);
            q = this.getQualityFromTP(record, hmer, -hmer.backwardsSize, renderOptions);
        } else if (isBackwardsHmer) {
            Hmer hmer = this.findHmer(record, abPrev.getIndexOnRead() + abPrev.getBasesLength() - 1, (byte)prevBlcokLastBase, true, true);
            q = this.getQualityFromTP(record, hmer, -hmer.forwardSize, renderOptions);
        }
        return q;
    }

    private AlignmentBlock[] getBlockWrappingBlocks(Alignment alignment, AlignmentBlock block) {
        AlignmentBlock abPrev = null;
        AlignmentBlock abNext = null;
        for (AlignmentBlock b : alignment.getAlignmentBlocks()) {
            if (b.getEnd() == block.getStart()) {
                abPrev = b;
                continue;
            }
            if (b.getStart() != block.getStart()) continue;
            abNext = b;
        }
        if (abPrev != null && abNext != null) {
            return new AlignmentBlock[]{abPrev, abNext};
        }
        return null;
    }

    private AlignmentBlock[] getGapWrappingBlocks(Alignment alignment, Gap gap) {
        int blockIndex;
        boolean blockFound = false;
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        for (blockIndex = 0; blockIndex < blocks.length; ++blockIndex) {
            if (blocks[blockIndex].getEnd() == gap.getStart()) {
                blockFound = true;
                break;
            }
            if (blocks[blockIndex].getEnd() > gap.getStart()) break;
        }
        if (blockFound && blockIndex < blocks.length - 1) {
            return new AlignmentBlock[]{alignment.getAlignmentBlocks()[blockIndex], alignment.getAlignmentBlocks()[blockIndex + 1]};
        }
        return null;
    }

    private double getQualityFromTP(SAMRecord record, Hmer hmer, int tpValue, AlignmentTrack.RenderOptions renderOptions) {
        byte[] tp = record.getByteArrayAttribute(ATTR_TP);
        if (!renderOptions.isIndelQualUsesMin()) {
            for (int ofs = hmer.start; ofs <= hmer.end; ++ofs) {
                boolean isCenteralBaseInHmer;
                if (tp[ofs] != tpValue) continue;
                double q = record.getBaseQualities()[ofs];
                boolean bl = isCenteralBaseInHmer = ofs - hmer.start == hmer.end - ofs;
                if (isCenteralBaseInHmer) {
                    return q;
                }
                return -10.0 * Math.log10(Math.pow(10.0, q / -10.0) * 2.0);
            }
            byte[] quals = record.getBaseQualities();
            if (quals.length == 0) {
                return Double.NaN;
            }
            double q = Double.MIN_VALUE;
            for (byte qual : quals) {
                q = Math.max((double)qual, q);
            }
            return q;
        }
        double q = Double.MAX_VALUE;
        for (int ofs = hmer.start; ofs <= hmer.end; ++ofs) {
            q = Math.min(q, (double)record.getBaseQualities()[ofs]);
        }
        return q;
    }

    private double getQualityFromT0(SAMRecord record, AlignmentBlock block, boolean delIsBeforeBlock) {
        int t0Index;
        String t0Attribute = record.getStringAttribute(TAG_T0);
        if (t0Attribute == null) {
            return Double.NaN;
        }
        byte[] t0 = t0Attribute.getBytes();
        int n = t0Index = delIsBeforeBlock ? block.getIndexOnRead() : block.getIndexOnRead() + block.getLength() - 1;
        if (t0Index < 0 || t0Index >= t0.length) {
            return Double.NaN;
        }
        return t0[t0Index] - 33;
    }

    private int getMC(SAMRecord record) {
        try {
            if (record.getReadGroup() == null) {
                return 0;
            }
            return Integer.parseInt(record.getReadGroup().getAttribute(RG_ATTR_MC));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Hmer findHmer(SAMRecord record, int start, byte base, boolean walkBackwards, boolean walkForward) {
        Hmer hmer = new Hmer();
        hmer.end = hmer.start = start;
        byte[] bases = record.getReadBases();
        if (walkBackwards) {
            while (hmer.start > 0 && bases[hmer.start - 1] == base) {
                --hmer.start;
                ++hmer.backwardsSize;
            }
        }
        if (walkForward) {
            while (hmer.end + 1 < bases.length && bases[hmer.end + 1] == base) {
                ++hmer.end;
                ++hmer.forwardSize;
            }
        }
        return hmer;
    }

    private boolean gapIsAllSameBase(Genome genome, Alignment alignment, Gap gap) {
        byte base = genome.getReference(alignment.getChr(), gap.getStart());
        for (int i = 1; i < gap.getnBases(); ++i) {
            if (genome.getReference(alignment.getChr(), gap.getStart() + i) == base) continue;
            return false;
        }
        return true;
    }

    private boolean blockIsAllSameBase(AlignmentBlock block) {
        byte base = block.getBases().getByte(0);
        for (int i = 1; i < block.getBasesLength(); ++i) {
            if (block.getBases().getByte(i) == base) continue;
            return false;
        }
        return true;
    }

    static class Hmer {
        int start;
        int end;
        int backwardsSize = 0;
        int forwardSize = 0;

        Hmer() {
        }

        int size() {
            return this.end - this.start + 1;
        }
    }
}

