/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGVDialog;

public class LoadFromURLDialog
extends IGVDialog {
    boolean canceled = false;
    String fileURL;
    String indexURL;
    JTextField fileField;
    JTextField indexField;

    public LoadFromURLDialog(Frame owner, boolean isHtsget) {
        super(owner, isHtsget ? "htsget URL" : "Load from URL");
        this.initComponents(isHtsget);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.canceled = false;
        this.fileURL = this.fileField.getText().trim();
        this.indexURL = this.indexField.getText().trim();
        if (this.indexURL.length() == 0) {
            this.indexURL = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<String> getFileURLs() {
        return LoadFromURLDialog.splitOnWhiteSpace(this.fileURL);
    }

    private static List<String> splitOnWhiteSpace(String string) {
        if (string != null && !string.isBlank()) {
            String[] inputs = Globals.whitespacePattern.split(string.trim());
            return Arrays.asList(inputs);
        }
        return Collections.emptyList();
    }

    public List<String> getIndexURLs() {
        return LoadFromURLDialog.splitOnWhiteSpace(this.indexURL);
    }

    private void initComponents(boolean isHtsget) {
        JPanel dialogPane = new JPanel(new BorderLayout(0, 12));
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        JPanel buttonBar = new JPanel(new GridBagLayout());
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.fileField = new JTextField(50);
        this.indexField = new JTextField(50);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        contentPanel.add((Component)new JLabel("File URL:"), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        contentPanel.add((Component)this.fileField, gbc);
        if (!isHtsget) {
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 5, 0);
            contentPanel.add((Component)new JLabel("<html><i>Specify url to an index file. <b>Required for BAM and indexed files</b></i>"), gbc);
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 0, 5);
            contentPanel.add((Component)new JLabel("Index URL:"), gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            contentPanel.add((Component)this.indexField, gbc);
        }
        GridBagConstraints gbcButtons = new GridBagConstraints();
        gbcButtons.gridx = 0;
        gbcButtons.weightx = 1.0;
        buttonBar.add(Box.createHorizontalGlue(), gbcButtons);
        gbcButtons.gridx = 1;
        gbcButtons.weightx = 0.0;
        buttonBar.add((Component)okButton, gbcButtons);
        gbcButtons.gridx = 2;
        buttonBar.add((Component)cancelButton, gbcButtons);
        dialogPane.add((Component)contentPanel, "Center");
        dialogPane.add((Component)buttonBar, "South");
        this.setContentPane(dialogPane);
        okButton.addActionListener(this::okButtonActionPerformed);
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.fileField.addActionListener(this::okButtonActionPerformed);
        this.indexField.addActionListener(this::okButtonActionPerformed);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.getRootPane().setDefaultButton(okButton);
    }
}

