/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.supdiagram;

import java.awt.Polygon;
import java.awt.geom.Point2D;
import org.broad.igv.feature.Strand;

public class AlignmentArrow
extends Polygon {
    public static final int ARROW_PX_WIDTH = 5;
    final Strand strand;

    public AlignmentArrow(int midline, int height, int left, int right, Strand strand) {
        int floor = midline - height;
        int startAdjusted = left - (strand == Strand.NEGATIVE ? 5 : 0);
        int endAdjusted = right + (strand == Strand.POSITIVE ? 5 : 0);
        int[] xPoly = new int[]{startAdjusted, left, right, endAdjusted, right, left};
        int[] yPoly = new int[]{floor + height / 2, floor, floor, floor + height / 2, floor + height, floor + height};
        this.xpoints = xPoly;
        this.ypoints = yPoly;
        this.npoints = xPoly.length;
        this.strand = strand;
        this.invalidate();
    }

    public Point2D getTip() {
        int x = this.strand == Strand.NEGATIVE ? this.xpoints[0] : this.xpoints[3];
        return new Point2D.Double(x, this.ypoints[0]);
    }

    public Point2D getTail() {
        int x = this.strand == Strand.NEGATIVE ? this.xpoints[3] : this.xpoints[0];
        return new Point2D.Double(x, this.ypoints[0]);
    }
}

