/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broad.igv.Globals;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.ViewChange;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.CytobandRenderer;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IGVMouseInputAdapter;

public class CytobandPanel
extends JPanel {
    private static int bandHeight = 10;
    private final boolean darkMode;
    private boolean isDragging = false;
    double cytobandScale;
    ReferenceFrame frame;
    private CytobandRenderer cytobandRenderer;
    private List<Cytoband> currentCytobands;

    public CytobandPanel(ReferenceFrame frame) {
        this(frame, true);
    }

    public CytobandPanel(ReferenceFrame frame, boolean mouseable) {
        this.frame = frame;
        this.darkMode = Globals.isDarkMode();
        if (mouseable) {
            this.initMouseAdapter();
        }
        this.cytobandRenderer = new CytobandRenderer(this.darkMode);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.darkMode) {
            this.setBackground(UIManager.getColor("Panel.background"));
        }
        if (PreferencesManager.getPreferences().getAntiAliasing()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.frame.getChrName().equals("All") || this.getWidth() < 10) {
            return;
        }
        int dataPanelWidth = this.getWidth();
        Rectangle cytoRect = new Rectangle(0, 10, dataPanelWidth, bandHeight);
        Chromosome chromosome = this.getReferenceFrame().getChromosome();
        if (chromosome == null) {
            return;
        }
        this.currentCytobands = GenomeManager.getInstance().getCurrentGenome().getCytobands(this.getReferenceFrame().getChrName());
        if (this.currentCytobands == null) {
            return;
        }
        this.cytobandRenderer.drawIdeogram(this.currentCytobands, g, cytoRect, this.frame);
        int chromosomeLength = this.getReferenceFrame().getMaxCoordinate();
        this.cytobandScale = (double)chromosomeLength / (double)dataPanelWidth;
        if (this.getReferenceFrame().getZoom() > 0) {
            double origin = this.frame.getOrigin();
            double end = this.frame.getEnd();
            int pixelStart = (int)(origin / this.cytobandScale);
            int pixelEnd = (int)(end / this.cytobandScale);
            int pixelSpan = Math.max(0, pixelEnd - pixelStart);
            int height = (int)cytoRect.getHeight();
            g.setColor(Color.RED);
            int y = (int)cytoRect.getY() + 5;
            g.drawRect(pixelStart, y, pixelSpan, height);
            g.drawRect(pixelStart - 1, y - 1, pixelSpan + 2, height + 2);
            g.drawRect(pixelStart - 2, y - 2, pixelSpan + 4, height + 4);
            if (pixelSpan < 2) {
                g.drawRect(pixelStart - 2, y - 2, pixelSpan + 4, height + 4);
            }
        }
    }

    private void initMouseAdapter() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolTipText("<html>Click anywhere on the chromosome<br/>to center view at that location.");
        IGVMouseInputAdapter mouseAdapter = new IGVMouseInputAdapter(){
            private final ReferenceFrame referenceFrame;
            int lastMousePressX;
            double viewOrigin;
            double viewEnd;
            {
                this.referenceFrame = CytobandPanel.this.getReferenceFrame();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void igvMouseClicked(MouseEvent e) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                int mouseX = e.getX();
                int clickCount = e.getClickCount();
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    double newLocation = CytobandPanel.this.cytobandScale * (double)mouseX;
                    if (clickCount > 1) {
                        int newZoom = this.referenceFrame.getZoom() + 1;
                        this.referenceFrame.doSetZoomCenter(newZoom, newLocation);
                    } else {
                        this.referenceFrame.centerOnLocation(newLocation);
                    }
                    ViewChange result = ViewChange.LocusChangeResult(this.referenceFrame.chrName, this.referenceFrame.origin, this.referenceFrame.getEnd(), true);
                    IGVEventBus.getInstance().post(result);
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.lastMousePressX = e.getX();
                this.viewOrigin = CytobandPanel.this.frame.getOrigin();
                this.viewEnd = CytobandPanel.this.frame.getEnd();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                if (CytobandPanel.this.isDragging) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        this.referenceFrame.setOrigin(this.viewOrigin);
                        this.referenceFrame.recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                    ViewChange result = ViewChange.LocusChangeResult(this.referenceFrame.chrName, this.referenceFrame.origin, this.referenceFrame.getEnd(), true);
                    IGVEventBus.getInstance().post(result);
                }
                CytobandPanel.this.isDragging = false;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                CytobandPanel.this.isDragging = true;
                int x = e.getX();
                int delta = x - this.lastMousePressX;
                if (delta != 0 && CytobandPanel.this.cytobandScale > 0.0) {
                    double chrLength = CytobandPanel.this.frame.getChromosomeLength();
                    double deltaBP = Math.min(Math.max(-this.viewOrigin, (double)delta * CytobandPanel.this.cytobandScale), chrLength - this.viewEnd);
                    this.viewOrigin += deltaBP;
                    this.viewEnd += deltaBP;
                    CytobandPanel.this.repaint();
                }
                this.lastMousePressX = x;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private ReferenceFrame getReferenceFrame() {
        return this.frame;
    }
}

