/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.color;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;

public class PaletteColorTable
implements ColorTable {
    LinkedHashMap<String, Color> colorMap;
    Color[] colors;
    Color defaultColor;

    public PaletteColorTable() {
        this.colorMap = new LinkedHashMap();
    }

    public PaletteColorTable(Color defaultColor) {
        this.defaultColor = defaultColor;
        this.colorMap = new LinkedHashMap();
    }

    public PaletteColorTable(ColorPalette palette) {
        if (palette != null) {
            this.colors = palette.getColors();
        }
        this.colorMap = new LinkedHashMap();
    }

    public void put(String key, Color c) {
        this.colorMap.put(key.toLowerCase(), c);
    }

    @Override
    public Color get(String key) {
        Color c = this.colorMap.get(key = key.toLowerCase());
        if (c == null) {
            if (this.defaultColor != null) {
                c = this.defaultColor;
            } else {
                int colorIdx = this.colorMap.size();
                c = this.colors != null && colorIdx < this.colors.length ? this.colors[colorIdx] : ColorUtilities.randomColor(colorIdx);
                this.colorMap.put(key, c);
            }
        }
        return c;
    }

    public Collection<String> getKeys() {
        return this.colorMap.keySet();
    }

    public Set<Map.Entry<String, Color>> entrySet() {
        return this.colorMap.entrySet();
    }

    public String getMapAsString() {
        StringBuffer buf = new StringBuffer();
        boolean firstEntry = true;
        for (Map.Entry<String, Color> entry : this.colorMap.entrySet()) {
            if (!firstEntry) {
                buf.append(";");
            }
            String cs = ColorUtilities.colorToString(entry.getValue());
            buf.append(entry.getKey());
            buf.append("=");
            buf.append(cs);
            firstEntry = false;
        }
        return buf.toString();
    }

    public void restoreMapFromString(String string) {
        String[] tokens;
        if (string == null || string.isEmpty()) {
            return;
        }
        this.colorMap.clear();
        for (String t : tokens = Globals.semicolonPattern.split(string)) {
            String[] kv = Globals.equalPattern.split(t);
            this.colorMap.put(kv[0], ColorUtilities.stringToColor(kv[1]));
        }
    }

    public Map<String, String> getPersistentState() {
        HashMap<String, String> state = new HashMap<String, String>();
        if (this.colorMap != null && this.colorMap.size() > 0) {
            state.put("colorMap", this.getMapAsString());
        }
        return state;
    }

    public void restorePersistentState(Map<String, String> values) {
        String colorMapString = values.get("colorMap");
        if (colorMapString != null) {
            this.restoreMapFromString(colorMapString);
        }
    }

    public LinkedHashMap<String, Color> getColorMap() {
        return this.colorMap;
    }
}

