/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.jidesoft.swing.JideSplitPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.ToolTipManager;
import org.broad.igv.Globals;
import org.broad.igv.batch.BatchRunner;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.TrackGroupEvent;
import org.broad.igv.event.ViewChange;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.mcp.IGVMcpServer;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesEditor;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.InsertionSelectionEvent;
import org.broad.igv.sam.SortOption;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.IndexAwareSessionReader;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.session.SessionWriter;
import org.broad.igv.session.UCSCSessionReader;
import org.broad.igv.session.autosave.AutosaveTimerTask;
import org.broad.igv.session.autosave.SessionAutosaveManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.Autoscaler;
import org.broad.igv.ui.DesktopIntegration;
import org.broad.igv.ui.IGVContentPane;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.Main;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.RecentFileSet;
import org.broad.igv.ui.RecentUrlsSet;
import org.broad.igv.ui.ShowDetailsBehavior;
import org.broad.igv.ui.StatusWindow;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionNavigatorDialog;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RegionOfInterestTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.CheckListDialog;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.ImageFileTypes;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.TrackFilter;
import org.broad.igv.util.URLUtils;
import org.broad.igv.variant.VariantTrack;

public class IGV
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(IGV.class);
    private static IGV theInstance;
    public static final String DATA_PANEL_NAME = "DataPanel";
    public static final String FEATURE_PANEL_NAME = "FeaturePanel";
    private Frame mainFrame;
    private JRootPane rootPane;
    private IGVContentPane contentPane;
    private IGVMenuBar menuBar;
    private StatusWindow statusWindow;
    Component glassPane;
    GhostGlassPane dNdGlassPane;
    public static Cursor fistCursor;
    public static Cursor zoomInCursor;
    public static Cursor zoomOutCursor;
    public static Cursor dragNDropCursor;
    private Session session;
    private Timer sessionAutosaveTimer = new Timer();
    private Map<String, List<Track>> overlayTracksMap = new HashMap<String, List<Track>>();
    private Set<Track> overlaidTracks = new HashSet<Track>();
    private RecentFileSet recentSessionList;
    private RecentUrlsSet recentUrlsList;
    private boolean rulerEnabled;
    private boolean isLoading = false;
    private Collection<? extends Track> pending = null;
    public static final ExecutorService threadExecutor;

    public static IGV createInstance(Frame frame, Main.IGVArgs igvArgs) {
        if (theInstance != null) {
            throw new RuntimeException("Only a single instance is allowed.");
        }
        theInstance = new IGV(frame, igvArgs);
        return theInstance;
    }

    public static IGV getInstance() {
        if (theInstance == null) {
            throw new RuntimeException("IGV has not been initialized.  Must call createInstance(Frame) first");
        }
        return theInstance;
    }

    public static boolean hasInstance() {
        return theInstance != null;
    }

    static void destroyInstance() {
        IGVMenuBar.destroyInstance();
        theInstance = null;
    }

    private IGV(Frame frame, Main.IGVArgs igvArgs) {
        theInstance = this;
        IGVPreferences preferences = PreferencesManager.getPreferences();
        this.session = new Session(null);
        this.mainFrame = frame;
        this.mainFrame.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
                IGVPopupMenu.closeAll();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }
        });
        this.createHandCursor();
        this.createZoomCursors();
        this.createDragAndDropCursor();
        this.mainFrame.setTitle("IGV");
        if (this.mainFrame instanceof JFrame) {
            JFrame jf = (JFrame)this.mainFrame;
            this.rootPane = jf.getRootPane();
        } else {
            this.rootPane = new JRootPane();
            this.mainFrame.add(this.rootPane);
        }
        this.contentPane = new IGVContentPane(this);
        this.menuBar = IGVMenuBar.createInstance(this);
        this.rootPane.setContentPane(this.contentPane);
        this.rootPane.setJMenuBar(this.menuBar);
        this.glassPane = this.rootPane.getGlassPane();
        this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
        this.dNdGlassPane = new GhostGlassPane();
        this.mainFrame.pack();
        this.mainFrame.setMinimumSize(new Dimension(300, 300));
        Dimension screenBounds = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle applicationBounds = preferences.getApplicationFrameBounds();
        GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphDev = graphEnv.getScreenDevices();
        Rectangle[] boundsArr = new Rectangle[graphDev.length];
        for (int i = 0; i < graphDev.length; ++i) {
            GraphicsConfiguration curCon = graphDev[i].getDefaultConfiguration();
            boundsArr[i] = curCon.getBounds();
        }
        boolean isNullOrNotContained = true;
        if (applicationBounds != null) {
            int userX = applicationBounds.x;
            int userY = applicationBounds.y;
            double userMaxX = applicationBounds.getMaxX();
            double userMaxY = applicationBounds.getMaxY();
            for (Rectangle curScreen : boundsArr) {
                if (!curScreen.contains(userX, userY)) continue;
                isNullOrNotContained = false;
                if (!(userMaxX >= curScreen.getMaxX()) && !(userMaxY >= curScreen.getMaxY())) break;
                applicationBounds = new Rectangle(curScreen.x, curScreen.y, Math.min(1150, curScreen.width), Math.min(800, curScreen.height));
                break;
            }
        }
        if (isNullOrNotContained) {
            applicationBounds = new Rectangle(0, 0, Math.min(1150, screenBounds.width), Math.min(800, screenBounds.height));
        }
        this.mainFrame.setBounds(applicationBounds);
        this.subscribeToEvents();
        if (PreferencesManager.getPreferences().getAsInt("AUTOSAVES_TO_KEEP") > 0) {
            int timerDelay = PreferencesManager.getPreferences().getAsInt("AUTOSAVE_FREQUENCY") * 60000;
            this.sessionAutosaveTimer.scheduleAtFixedRate((TimerTask)new AutosaveTimerTask(this), timerDelay, (long)timerDelay);
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public Frame getMainFrame() {
        return this.mainFrame;
    }

    public GhostGlassPane getDnDGlassPane() {
        return this.dNdGlassPane;
    }

    public void startDnD() {
        this.rootPane.setGlassPane(this.dNdGlassPane);
        this.dNdGlassPane.setVisible(true);
    }

    public void endDnD() {
        this.rootPane.setGlassPane(this.glassPane);
        this.glassPane.setVisible(false);
    }

    public Dimension getPreferredSize() {
        return UIConstants.preferredSize;
    }

    public void addRegionOfInterest(RegionOfInterest roi) {
        this.session.addRegionOfInterestWithNoListeners(roi);
        RegionOfInterestPanel.setSelectedRegion(roi);
        this.repaint();
    }

    public void beginROI(JButton button) {
        for (TrackPanel tp : this.getTrackPanels()) {
            TrackPanelScrollPane tsv = tp.getScrollPane();
            DataPanelContainer dpc = tsv.getDataPanel();
            for (Component c : dpc.getComponents()) {
                if (!(c instanceof DataPanel)) continue;
                DataPanel dp = (DataPanel)c;
                RegionOfInterestTool regionOfInterestTool = new RegionOfInterestTool(dp, button);
                dp.setCurrentTool(regionOfInterestTool);
            }
        }
    }

    public void endROI() {
        for (TrackPanel tp : this.getTrackPanels()) {
            DataPanelContainer dp = tp.getScrollPane().getDataPanel();
            dp.setCurrentTool(null);
        }
    }

    public void focusSearchBox() {
        this.contentPane.getCommandBar().focusSearchBox();
    }

    public void enableExtrasMenu() {
        this.menuBar.enableExtrasMenu();
    }

    public Future loadTracks(final Collection<ResourceLocator> locators) {
        Future<Void> toRet = null;
        if (locators != null && !locators.isEmpty()) {
            this.contentPane.getStatusBar().setMessage("Loading ...");
            NamedRunnable runnable = new NamedRunnable(){

                @Override
                public void run() {
                    List<Map<TrackPanelScrollPane, Integer>> trackPanelAttrs = IGV.this.getTrackPanelAttrs();
                    MessageCollection messages = new MessageCollection();
                    for (ResourceLocator locator : locators) {
                        File trackSetFile;
                        if (locator.isLocal() && !(trackSetFile = new File(locator.getPath())).exists()) {
                            messages.append("File not found: " + locator.getPath() + "\n");
                            continue;
                        }
                        try {
                            List<Track> tracks = IGV.this.load(locator);
                            IGV.this.addTracks(tracks);
                        }
                        catch (Exception e) {
                            log.error("Error loading track", e);
                            messages.append("Error loading " + String.valueOf(locator) + ": " + e.getMessage());
                        }
                    }
                    if (!messages.isEmpty()) {
                        for (String message : messages.getMessages()) {
                            MessageUtils.showMessage(message);
                        }
                    }
                    IGV.this.resetPanelHeights(trackPanelAttrs.get(0), trackPanelAttrs.get(1));
                    IGV.this.showLoadedTrackCount();
                    IGV.this.revalidateTrackPanels();
                }

                @Override
                public String getName() {
                    return "Load Tracks";
                }
            };
            toRet = LongRunningTask.submit(runnable);
        }
        log.debug("Finish loadTracks");
        return toRet;
    }

    public List<Map<TrackPanelScrollPane, Integer>> getTrackPanelAttrs() {
        HashMap<TrackPanelScrollPane, Integer> trackCountMap = new HashMap<TrackPanelScrollPane, Integer>();
        HashMap<TrackPanelScrollPane, Integer> panelSizeMap = new HashMap<TrackPanelScrollPane, Integer>();
        for (TrackPanel tp : this.getTrackPanels()) {
            TrackPanelScrollPane sp = tp.getScrollPane();
            trackCountMap.put(sp, sp.getDataPanel().getAllTracks().size());
            panelSizeMap.put(sp, sp.getDataPanel().getHeight());
        }
        return Arrays.asList(trackCountMap, panelSizeMap);
    }

    public void resetPanelHeights(Map<TrackPanelScrollPane, Integer> trackCountMap, Map<TrackPanelScrollPane, Integer> panelSizeMap) {
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            double totalHeight = 0.0;
            for (TrackPanel tp : this.getTrackPanels()) {
                int prevTrackCount;
                TrackPanelScrollPane sp = tp.getScrollPane();
                if (trackCountMap.containsKey(sp) && (prevTrackCount = ((Integer)trackCountMap.get(sp)).intValue()) != sp.getDataPanel().getAllTracks().size()) {
                    int scrollPosition = (Integer)panelSizeMap.get(sp);
                    if (prevTrackCount != 0 && sp.getVerticalScrollBar().isShowing()) {
                        sp.getVerticalScrollBar().setMaximum(sp.getDataPanel().getHeight());
                        sp.getVerticalScrollBar().setValue(scrollPosition);
                    }
                }
                if (sp.getTrackPanel().getTracks().size() <= 0) continue;
                totalHeight += (double)Math.min(300, sp.getTrackPanel().getPreferredPanelHeight());
            }
            JideSplitPane centerSplitPane = this.contentPane.getMainPanel().getCenterSplitPane();
            int htotal = centerSplitPane.getHeight();
            int y = 0;
            int i = 0;
            for (Component c : centerSplitPane.getComponents()) {
                if (!(c instanceof TrackPanelScrollPane)) continue;
                TrackPanel trackPanel = ((TrackPanelScrollPane)((Object)c)).getTrackPanel();
                if (trackPanel.getTracks().size() > 0) {
                    int panelWeight = Math.min(300, trackPanel.getPreferredPanelHeight());
                    int dh = (int)((double)panelWeight / totalHeight * (double)htotal);
                    y += dh;
                }
                centerSplitPane.setDividerLocation(i, y);
                ++i;
            }
            this.contentPane.getMainPanel().invalidate();
        });
    }

    public void setGeneList(GeneList geneList) {
        this.setGeneList(geneList, true);
    }

    public void setGeneList(final GeneList geneList, final boolean recordHistory) {
        final WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        UIUtilities.invokeOnEventThread(new NamedRunnable(){

            @Override
            public void run() {
                try {
                    if (geneList == null) {
                        IGV.this.session.setCurrentGeneList(null);
                    } else {
                        if (recordHistory) {
                            IGV.this.session.getHistory().push("List: " + geneList.getName(), 0);
                        }
                        IGV.this.session.setCurrentGeneList(geneList);
                    }
                    IGV.this.resetFrames();
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public String getName() {
                return "Set gene list";
            }
        });
    }

    public void setDefaultFrame(String searchString) {
        FrameManager.setToDefaultFrame(searchString);
        this.resetFrames();
    }

    public final void doViewPreferences() {
        try {
            PreferencesEditor.open(this.mainFrame);
        }
        catch (Exception e) {
            log.error("Error opening preference dialog", e);
        }
    }

    public final void saveStateForExit() {
        RecentUrlsSet recentUrls;
        RecentFileSet recentSessions = this.getRecentSessionList();
        if (!recentSessions.isEmpty()) {
            PreferencesManager.getPreferences().setRecentSessions(recentSessions.asString());
        }
        if (!(recentUrls = this.getRecentUrls()).isEmpty()) {
            PreferencesManager.getPreferences().setRecentUrls(recentUrls.asString());
        }
        this.stopTimedAutosave();
        if (PreferencesManager.getPreferences().getAsBoolean("AUTOSAVE_ON_EXIT")) {
            try {
                SessionAutosaveManager.saveExitSessionAutosaveFile(this.session);
            }
            catch (Exception e) {
                log.error("Error autosaving session", e);
            }
        }
    }

    public final void doShowAttributeDisplay(boolean enableAttributeView) {
        boolean oldState = PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views");
        if (oldState != enableAttributeView) {
            PreferencesManager.getPreferences().setShowAttributeView(enableAttributeView);
            this.repaint();
        }
    }

    public final void doSelectDisplayableAttribute() {
        List<String> allAttributes = AttributeManager.getInstance().getAttributeNames();
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        CheckListDialog dlg = new CheckListDialog(this.mainFrame, allAttributes, hiddenAttributes, false);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            IGV.getInstance().getSession().setHiddenAttributes(dlg.getNonSelections());
            this.revalidateTrackPanels();
        }
    }

    public final void saveImage(Component target, String extension) {
        this.saveImage(target, "igv_snapshot", extension);
    }

    public final void saveImage(Component target, String title, String extension) {
        if ("png".equalsIgnoreCase(extension) || "svg".equalsIgnoreCase(extension)) {
            this.contentPane.getStatusBar().setMessage("Creating image...");
            File defaultFile = new File(title + "." + extension);
            this.createSnapshot(target, defaultFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSnapshot(Component target, File defaultFile) {
        File file = this.selectSnapshotFile(defaultFile);
        if (file == null) {
            return;
        }
        WaitCursorManager.CursorToken token = null;
        try {
            token = WaitCursorManager.showWaitCursor();
            this.contentPane.getStatusBar().setMessage("Exporting image: " + defaultFile.getAbsolutePath());
            String msg = this.createSnapshotNonInteractive(target, file, false);
            if (msg != null && msg.toLowerCase().startsWith("error")) {
                MessageUtils.showMessage(msg);
            }
        }
        catch (Exception e) {
            log.error("Error creating exporting image ", e);
            MessageUtils.showMessage("Error creating the image file: " + String.valueOf(defaultFile) + "<br> " + e.getMessage());
        }
        finally {
            if (token != null) {
                WaitCursorManager.removeWaitCursor(token);
            }
            this.resetStatusMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSnapshotNonInteractive(Component target, File file, boolean batch) throws Exception {
        ImageFileTypes.Type type;
        log.debug("Creating snapshot: " + file.getName());
        String extension = FileUtils.getFileExtension(file.getAbsolutePath());
        if (extension == null) {
            extension = ".png";
            file = new File(file.getAbsolutePath() + extension);
        }
        if ((type = ImageFileTypes.getImageFileType(extension)) == ImageFileTypes.Type.NULL) {
            String message = "ERROR: Unknown file extension " + extension;
            log.error(message);
            return message;
        }
        if (type == ImageFileTypes.Type.EPS || type == ImageFileTypes.Type.JPEG) {
            String message = "ERROR: " + String.valueOf((Object)type) + " output is not supported.  Try '.png' or '.svg'";
            log.error(message);
            return message;
        }
        try {
            String string = SnapshotUtilities.doComponentSnapshot(target, file, type, batch);
            return string;
        }
        finally {
            log.debug("Finished creating snapshot: " + file.getName());
        }
    }

    public File selectSnapshotFile(File defaultFile) {
        File snapshotDirectory = PreferencesManager.getPreferences().getLastSnapshotDirectory();
        FileDialog fc = new FileDialog(this.mainFrame, "Save image", 1);
        if (snapshotDirectory != null) {
            fc.setDirectory(snapshotDirectory.getAbsolutePath());
        }
        fc.setFile(defaultFile.getName());
        fc.setFilenameFilter((dir, name) -> name.endsWith(".jpeg") || name.endsWith(".jpg") || name.endsWith(".png") || name.endsWith(".svg"));
        fc.setVisible(true);
        String file = fc.getFile();
        if (file != null) {
            String directory = fc.getDirectory();
            if (directory != null) {
                PreferencesManager.getPreferences().setLastSnapshotDirectory(directory);
            }
            return new File(directory, file);
        }
        return null;
    }

    private void createZoomCursors() throws HeadlessException, IndexOutOfBoundsException {
        if (zoomInCursor == null || zoomOutCursor == null) {
            Image zoomInImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_IN).getImage();
            Image zoomOutImage = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_OUT).getImage();
            Point hotspot = new Point(10, 10);
            zoomInCursor = this.createCustomCursor(zoomInImage, hotspot, "Zoom in", 1);
            zoomOutCursor = this.createCustomCursor(zoomOutImage, hotspot, "Zoom out", 0);
        }
    }

    private void createHandCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (fistCursor == null) {
            final BufferedImage handImage = new BufferedImage(32, 32, 2);
            Graphics2D g = handImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
            g.fill(rect);
            g = handImage.createGraphics();
            boolean ready = g.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.FIST).getImage(), 0, 0, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    if ((infoflags & 0x20) != 0) {
                        fistCursor = IGV.this.createCustomCursor(handImage, new Point(8, 6), "Move", 12);
                        return false;
                    }
                    return true;
                }
            });
            if (ready) {
                try {
                    fistCursor = this.createCustomCursor(handImage, new Point(8, 6), "Move", 12);
                }
                catch (Exception e) {
                    log.warn("Warning: could not create fistCursor");
                    fistCursor = Cursor.getPredefinedCursor(13);
                }
            }
        }
    }

    private void createDragAndDropCursor() throws HeadlessException, IndexOutOfBoundsException {
        if (dragNDropCursor == null) {
            ImageIcon icon = IconFactory.getInstance().getIcon(IconFactory.IconID.DRAG_AND_DROP);
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            final BufferedImage dragNDropImage = new BufferedImage(width, height, 2);
            Graphics2D g = dragNDropImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
            g.fill(rect);
            g = dragNDropImage.createGraphics();
            Image image = icon.getImage();
            boolean ready = g.drawImage(image, 0, 0, new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    if ((infoflags & 0x20) != 0) {
                        dragNDropCursor = IGV.this.createCustomCursor(dragNDropImage, new Point(0, 0), "Drag and Drop", 1);
                        return false;
                    }
                    return true;
                }
            });
            if (ready) {
                dragNDropCursor = this.createCustomCursor(dragNDropImage, new Point(0, 0), "Drag and Drop", 0);
            }
        }
    }

    private Cursor createCustomCursor(Image image, Point hotspot, String name, int defaultCursor) {
        try {
            return this.mainFrame.getToolkit().createCustomCursor(image, hotspot, name);
        }
        catch (Exception e) {
            log.warn("Could not create cursor: " + name);
            return Cursor.getPredefinedCursor(defaultCursor);
        }
    }

    private void subscribeToEvents() {
        IGVEventBus.getInstance().subscribe(ViewChange.class, this);
        IGVEventBus.getInstance().subscribe(InsertionSelectionEvent.class, this);
        IGVEventBus.getInstance().subscribe(GenomeChangeEvent.class, this);
    }

    public void setStatusBarMessage(String message) {
        if (message.equals("Done.")) {
            this.resetStatusMessage();
        }
        this.contentPane.getStatusBar().setMessage(message);
    }

    public void setStatusBarMessag2(String message) {
        this.contentPane.getStatusBar().setMessage2(message);
    }

    public void setStatusBarMessage3(String message) {
        this.contentPane.getStatusBar().setMessage3(message);
    }

    public void enableStopButton(boolean enable) {
        this.contentPane.getStatusBar().enableStopButton(enable);
    }

    public void resetToFactorySettings() {
        try {
            PreferencesManager.getPreferences().clear();
            boolean isShow = PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views");
            this.doShowAttributeDisplay(isShow);
            Preferences prefs = Preferences.userNodeForPackage(Globals.class);
            prefs.remove("igvDir");
            this.repaint();
        }
        catch (Exception e) {
            String message = "Failure while resetting preferences!";
            log.error(message, e);
            MessageUtils.showMessage(message + ": " + e.getMessage());
        }
    }

    public boolean isFilterMatchAll() {
        TrackFilter trackFilter = this.session.getFilter();
        return trackFilter != null && trackFilter.isMatchAll();
    }

    public boolean isFilterShowAllTracks() {
        TrackFilter trackFilter = this.session.getFilter();
        return trackFilter != null && trackFilter.isShowAll();
    }

    public TrackPanelScrollPane addDataPanel(String name) {
        return this.contentPane.getMainPanel().addDataPanel(name);
    }

    public TrackPanel getTrackPanel(String name) {
        for (TrackPanel sp : this.getTrackPanels()) {
            if (!name.equals(sp.getName())) continue;
            return sp;
        }
        TrackPanelScrollPane sp = this.addDataPanel(name);
        return sp.getTrackPanel();
    }

    public List<TrackPanel> getTrackPanels() {
        return this.contentPane.getMainPanel().getTrackPanels();
    }

    public boolean scrollToTrack(String trackName) {
        boolean found = false;
        for (TrackPanel tp : this.getTrackPanels()) {
            if (!tp.getScrollPane().getNamePanel().scrollTo(trackName)) continue;
            found = true;
        }
        return found;
    }

    public void scrollToTop() {
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.getScrollPane().getNamePanel().scrollToPosition(0);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void resetSession(String sessionPath) {
        this.session.reset(sessionPath);
        AttributeManager.getInstance().clearAllAttributes();
        this.mainFrame.setTitle(sessionPath == null ? "IGV" : sessionPath);
        this.menuBar.resetSessionActions();
        this.getMainPanel().resetPanels();
        this.getMainPanel().updatePanelDimensions();
        this.revalidateTrackPanels();
    }

    public void newSession() {
        this.resetSession(null);
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        if (currentGenome != null) {
            GenomeManager.getInstance().restoreGenomeTracks(currentGenome);
        }
        this.menuBar.disableReloadSession();
        this.goToLocus(GenomeManager.getInstance().getCurrentGenome().getHomeChromosome());
        this.revalidateTrackPanels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSession(String sessionPath, String locus) {
        InputStream inputStream = null;
        try {
            this.setStatusBarMessage("Opening session...");
            inputStream = new BufferedInputStream(ParsingUtils.openInputStreamGZ(new ResourceLocator(sessionPath)));
            boolean success = this.loadSessionFromStream(sessionPath, inputStream);
            if (success) {
                String searchText;
                this.session.setPath(sessionPath);
                String string = searchText = locus == null ? this.session.getLocus() : locus;
                if (!FrameManager.isGeneListMode() && searchText != null && searchText.trim().length() > 0) {
                    this.goToLocus(searchText);
                }
                this.mainFrame.setTitle("IGV - Session: " + sessionPath);
                this.getRecentSessionList().add(sessionPath);
                this.menuBar.enableReloadSession();
                RegionNavigatorDialog.destroyInstance();
            }
            boolean searchText = success;
            return searchText;
        }
        catch (Exception e) {
            String message = "Error loading session session: " + e.getMessage();
            MessageUtils.showMessage(message);
            this.getRecentSessionList().remove(sessionPath);
            log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing session stream", iOException);
                }
            }
            this.resetStatusMessage();
        }
    }

    public boolean loadSessionFromStream(String sessionPath, InputStream inputStream) throws IOException {
        SessionReader sessionReader = sessionPath != null && (sessionPath.endsWith(".session") || sessionPath.endsWith(".session.txt")) ? new UCSCSessionReader(this) : (sessionPath != null && (sessionPath.endsWith(".idxsession") || sessionPath.endsWith(".idxsession.txt")) ? new IndexAwareSessionReader(this) : new IGVSessionReader(this));
        sessionReader.loadSession(inputStream, this.session, sessionPath);
        double[] dividerFractions = this.session.getDividerFractions();
        if (dividerFractions != null) {
            this.contentPane.getMainPanel().setDividerFractions(dividerFractions);
        }
        this.session.clearDividerLocations();
        this.revalidateTrackPanels();
        return true;
    }

    public void saveSession(File targetFile) throws IOException {
        new SessionWriter().saveSession(this.session, targetFile);
        String sessionPath = targetFile.getAbsolutePath();
        this.session.setPath(sessionPath);
        this.mainFrame.setTitle("IGV - Session: " + sessionPath);
        this.getRecentSessionList().add(sessionPath);
        this.menuBar.enableReloadSession();
        PreferencesManager.getPreferences().setLastTrackDirectory(targetFile.getParentFile());
    }

    public void resetStatusMessage() {
        UIUtilities.invokeAndWaitOnEventThread(() -> this.contentPane.getStatusBar().setMessage(this.getVisibleTrackCount() + " tracks loaded"));
    }

    public void showLoadedTrackCount() {
        int visibleTrackCount = this.getVisibleTrackCount();
        this.contentPane.getStatusBar().setMessage(visibleTrackCount + (visibleTrackCount == 1 ? " track" : " tracks"));
    }

    private void closeWindow(ProgressBar.ProgressDialog progressDialog) {
        UIUtilities.invokeOnEventThread(() -> progressDialog.setVisible(false));
    }

    public void goToLocus(String locus) {
        this.contentPane.getCommandBar().searchByLocus(locus);
    }

    public void tweakPanelDivider() {
        this.contentPane.getMainPanel().tweakPanelDivider();
    }

    public void removeDataPanel(String name) {
        this.contentPane.getMainPanel().removeDataPanel(name);
    }

    public void removeTrackPanel(TrackPanel trackPanel) {
        this.contentPane.getMainPanel().removeTrackPanel(trackPanel);
    }

    public boolean panelIsRemovable(TrackPanel trackPanel) {
        return this.contentPane.getMainPanel().panelIsRemovable(trackPanel);
    }

    public MainPanel getMainPanel() {
        return this.contentPane.getMainPanel();
    }

    public RecentFileSet getRecentSessionList() {
        if (this.recentSessionList == null) {
            this.recentSessionList = PreferencesManager.getPreferences().getRecentSessions();
            this.recentSessionList.removeIf(file -> !new File((String)file).exists());
        }
        return this.recentSessionList;
    }

    public RecentUrlsSet getRecentUrls() {
        if (this.recentUrlsList == null) {
            this.recentUrlsList = PreferencesManager.getPreferences().getRecentUrls();
        }
        return this.recentUrlsList;
    }

    public void addToRecentUrls(Collection<ResourceLocator> toAdd) {
        RecentUrlsSet recentFiles = this.getRecentUrls();
        recentFiles.addAll(toAdd);
        if (!recentFiles.isEmpty()) {
            this.menuBar.showRecentFilesMenu();
        }
    }

    public IGVContentPane getContentPane() {
        return this.contentPane;
    }

    public boolean isShowDetailsOnClick() {
        return this.contentPane != null && this.contentPane.getCommandBar().getDetailsBehavior() == ShowDetailsBehavior.CLICK;
    }

    public boolean isShowDetailsOnHover() {
        return this.contentPane != null && this.contentPane.getCommandBar().getDetailsBehavior() == ShowDetailsBehavior.HOVER;
    }

    public void openStatusWindow() {
        if (this.statusWindow == null) {
            this.statusWindow = new StatusWindow();
        }
        this.statusWindow.setVisible(true);
    }

    public void setStatusWindowText(String text) {
        if (this.statusWindow != null && this.statusWindow.isVisible()) {
            this.statusWindow.updateText(text);
        }
    }

    public void addTracks(List<Track> trackList) {
        Map<String, List<Track>> map = trackList.stream().collect(Collectors.groupingBy(t -> t.getResourceLocator().getPath()));
        for (List<Track> tracks : map.values()) {
            Track representativeTrack = tracks.get(0);
            TrackPanel panel = this.getPanelFor(representativeTrack);
            panel.addTracks(tracks);
        }
    }

    public void addTrack(Track track) {
        this.getPanelFor(track).addTrack(track);
    }

    public void addTrack(Track track, String panelName) {
        TrackPanel panel = this.getTrackPanel(panelName);
        panel.addTracks(Collections.singleton(track));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Track> load(ResourceLocator locator) throws DataLoadException {
        try {
            Genome genome;
            TrackLoader loader;
            List<Track> newTracks;
            if (IGV.hasInstance()) {
                IGV.getInstance().setStatusBarMessage3("Loading " + locator.getPath());
            }
            if ((newTracks = (loader = new TrackLoader()).load(locator, genome = GenomeManager.getInstance().getCurrentGenome())).size() > 0) {
                for (Track track : newTracks) {
                    TrackProperties properties;
                    String fn = locator.getPath();
                    int lastSlashIdx = fn.lastIndexOf("/");
                    if (lastSlashIdx < 0) {
                        lastSlashIdx = fn.lastIndexOf("\\");
                    }
                    if (lastSlashIdx > 0) {
                        fn = fn.substring(lastSlashIdx + 1);
                    }
                    if ((properties = locator.getTrackProperties()) == null) continue;
                    track.setProperties(properties);
                }
            }
            List<Track> list = newTracks;
            return list;
        }
        finally {
            if (IGV.hasInstance()) {
                IGV.getInstance().setStatusBarMessage3("");
            }
        }
    }

    public void load(ResourceLocator locator, TrackPanel panel) throws DataLoadException {
        if (SessionReader.isSessionFile(locator.getPath())) {
            LongRunningTask.submit(() -> this.loadSession(locator.getPath(), null));
        } else {
            Runnable runnable = () -> {
                List<Track> tracks = this.load(locator);
                panel.addTracks(tracks);
                this.repaint();
            };
            LongRunningTask.submit(runnable);
        }
    }

    public TrackPanel getPanelFor(Track track) {
        if (PreferencesManager.getPreferences().getAsBoolean("IGV.single.track.pane")) {
            return this.getTrackPanel(DATA_PANEL_NAME);
        }
        ResourceLocator locator = track.getResourceLocator();
        if (locator == null) {
            return this.getTrackPanel(DATA_PANEL_NAME);
        }
        if (locator.getPanelName() != null) {
            return this.getTrackPanel(locator.getPanelName());
        }
        if ("alist".equals(locator.getFormat())) {
            return this.getVcfBamPanel();
        }
        if (PreferencesManager.getPreferences().getAsBoolean("IGV.single.track.pane")) {
            return this.getTrackPanel(DATA_PANEL_NAME);
        }
        if (TrackLoader.isAlignmentTrack(locator.getFormat())) {
            String newPanelName = "Panel" + System.currentTimeMillis();
            return this.addDataPanel(newPanelName).getTrackPanel();
        }
        if (track instanceof VariantTrack && ((VariantTrack)track).sampleCount() > 10) {
            String newPanelName = "Panel" + System.currentTimeMillis();
            return this.addDataPanel(newPanelName).getTrackPanel();
        }
        return this.getTrackPanel(DATA_PANEL_NAME);
    }

    public TrackPanel getVcfBamPanel() {
        String panelName = "VCF_BAM";
        TrackPanel panel = this.getTrackPanel(panelName);
        if (panel != null) {
            return panel;
        }
        return this.addDataPanel(panelName).getTrackPanel();
    }

    private boolean isAnnotationFile(String format) {
        HashSet<String> annotationFormats = new HashSet<String>(Arrays.asList("refflat", "ucscgene", "genepred", "ensgene", "refgene", "gff", "gtf", "gff3", "embl", "bed", "gistic", "bedz", "repmask", "dranger", "ucscsnp", "genepredext", "bigbed"));
        return annotationFormats.contains(format);
    }

    public void sortAlignmentTracks(SortOption option, String tag, boolean invertSort) {
        this.sortAlignmentTracks(option, null, tag, invertSort, null);
    }

    public void sortAlignmentTracks(SortOption option, Double location, String tag, boolean invertSort, Set<String> priorityRecords) {
        List alignmentTracks = this.getAllTracks().stream().filter(track -> track instanceof AlignmentTrack).map(track -> (AlignmentTrack)track).peek(track -> track.sortRows(option, location, tag, invertSort, priorityRecords)).collect(Collectors.toList());
        this.repaint(alignmentTracks);
    }

    public void groupAlignmentTracks(AlignmentTrack.GroupOption option, String tag, Range pos) {
        List alignmentTracks = this.getAllTracks().stream().filter(track -> track instanceof AlignmentTrack).collect(Collectors.toList());
        for (Track t : alignmentTracks) {
            ((AlignmentTrack)t).groupAlignments(option, tag, pos);
        }
        this.repaint(alignmentTracks);
    }

    public void colorAlignmentTracks(AlignmentTrack.ColorOption option, String tag) {
        List alignmentTracks = this.getAllTracks().stream().filter(track -> track instanceof AlignmentTrack).collect(Collectors.toList());
        for (Track t : alignmentTracks) {
            AlignmentTrack alignmentTrack = (AlignmentTrack)t;
            alignmentTrack.setColorOption(option);
            if (option == AlignmentTrack.ColorOption.BISULFITE && tag != null) {
                try {
                    AlignmentTrack.BisulfiteContext context = AlignmentTrack.BisulfiteContext.valueOf(tag);
                    alignmentTrack.setBisulfiteContext(context);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error setting bisulfite context for: " + tag, e);
                }
                continue;
            }
            if (tag == null) continue;
            alignmentTrack.setColorByTag(tag);
        }
        this.repaint(alignmentTracks);
    }

    public void packAlignmentTracks() {
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).packAlignments();
        }
    }

    public void resetOverlayTracks() {
        List<Track> trackList;
        String sample;
        log.debug("Resetting Overlay Tracks");
        this.overlayTracksMap.clear();
        this.overlaidTracks.clear();
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() != TrackType.MUTATION || (sample = track.getSample()) == null) continue;
            trackList = this.overlayTracksMap.get(sample);
            if (trackList == null) {
                trackList = new ArrayList<Track>();
                this.overlayTracksMap.put(sample, trackList);
            }
            trackList.add(track);
        }
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() == TrackType.MUTATION || (sample = track.getSample()) == null || (trackList = this.overlayTracksMap.get(sample)) == null) continue;
            this.overlaidTracks.addAll(trackList);
        }
        boolean displayOverlays = this.getSession().getOverlayMutationTracks();
        for (Track track : this.getAllTracks()) {
            if (track == null || track.getTrackType() != TrackType.MUTATION) continue;
            track.setOverlayed(displayOverlays && this.overlaidTracks.contains(track));
        }
    }

    public List<Track> getOverlayTracks(Track track) {
        String sample = track.getSample();
        if (sample != null) {
            return this.overlayTracksMap.get(sample);
        }
        return null;
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackPanel tsv : this.getTrackPanels()) {
            count += tsv.getVisibleTrackCount();
        }
        return count;
    }

    public List<Track> getAllTracks() {
        ArrayList<Track> allTracks = new ArrayList<Track>();
        for (TrackPanel tp : this.getTrackPanels()) {
            allTracks.addAll(tp.getTracks());
        }
        return allTracks;
    }

    public List<FeatureTrack> getFeatureTracks() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getAllTracks(), FeatureTrack.class));
    }

    public List<DataTrack> getDataTracks() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getAllTracks(), DataTrack.class));
    }

    public List<AlignmentTrack> getAlignmentTracks() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getAllTracks(), AlignmentTrack.class));
    }

    public void clearSelections() {
        for (Track t : this.getAllTracks()) {
            if (t == null) continue;
            t.setSelected(false);
        }
    }

    public void setTrackSelections(Iterable<Track> selectedTracks) {
        for (Track t : selectedTracks) {
            t.setSelected(true);
        }
    }

    public void shiftSelectTracks(Track track) {
        int clickedTrackIndex;
        List<Track> allTracks = this.getAllTracks();
        int otherIndex = clickedTrackIndex = allTracks.indexOf(track);
        for (int i = 0; i < allTracks.size(); ++i) {
            if (!allTracks.get(i).isSelected() || i == clickedTrackIndex) continue;
            otherIndex = i;
            break;
        }
        int left = Math.min(otherIndex, clickedTrackIndex);
        int right = Math.max(otherIndex, clickedTrackIndex);
        for (int i = left; i <= right; ++i) {
            Track t = allTracks.get(i);
            if (!t.isVisible()) continue;
            t.setSelected(true);
        }
    }

    public void toggleTrackSelections(Iterable<Track> selectedTracks) {
        for (Track t : selectedTracks) {
            t.setSelected(!t.isSelected());
        }
    }

    public List<Track> getSelectedTracks() {
        ArrayList<Track> selectedTracks = new ArrayList<Track>();
        for (Track t : this.getAllTracks()) {
            if (t == null || !t.isSelected()) continue;
            selectedTracks.add(t);
        }
        return selectedTracks;
    }

    public Set<ResourceLocator> getDataResourceLocators() {
        HashSet<ResourceLocator> locators = new HashSet<ResourceLocator>();
        for (Track track : this.getAllTracks()) {
            Collection<ResourceLocator> tlocators = track.getResourceLocators();
            if (tlocators == null) continue;
            locators.addAll(tlocators);
        }
        locators.remove(null);
        return locators;
    }

    public Set<TrackType> getLoadedTypes() {
        HashSet<TrackType> types = new HashSet<TrackType>();
        for (Track t : this.getAllTracks()) {
            if (t == null) continue;
            TrackType type = t.getTrackType();
            types.add(type);
        }
        return types;
    }

    public Set<String> getLoadedPaths() {
        return this.getDataResourceLocators().stream().map(rl -> rl.getPath()).collect(Collectors.toSet());
    }

    public void setAllTrackHeights(int newHeight) {
        for (Track track : this.getAllTracks()) {
            track.setHeight(newHeight, true);
        }
    }

    public void deleteTracksByPath(Set<String> paths) {
        List toRemove = this.getAllTracks().stream().filter(t -> {
            ResourceLocator locator = t.getResourceLocator();
            String path = locator == null ? null : locator.getPath();
            return path != null && paths.contains(path);
        }).collect(Collectors.toList());
        this.deleteTracks(toRemove);
    }

    public void deleteTracks(Collection<? extends Track> tracksToRemove) {
        List<TrackPanel> panels = this.getTrackPanels();
        for (TrackPanel trackPanel : panels) {
            trackPanel.removeTracks(tracksToRemove);
            if (trackPanel.hasTracks()) continue;
            this.removeDataPanel(trackPanel.getName());
        }
        for (Track track : tracksToRemove) {
            if (track instanceof IGVEventObserver) {
                IGVEventBus.getInstance().unsubscribe((IGVEventObserver)((Object)track));
            }
            track.unload();
        }
        this.revalidateTrackPanels();
    }

    public void setSequenceTrack() {
        TrackPanel panel = PreferencesManager.getPreferences().getAsBoolean("IGV.single.track.pane") ? this.getTrackPanel(DATA_PANEL_NAME) : this.getTrackPanel(FEATURE_PANEL_NAME);
        SequenceTrack newSeqTrack = new SequenceTrack("Reference sequence");
        panel.addTrack(newSeqTrack);
    }

    public SequenceTrack getSequenceTrack() {
        for (Track t : this.getAllTracks()) {
            if (!(t instanceof SequenceTrack)) continue;
            return (SequenceTrack)t;
        }
        return null;
    }

    public void sortAllTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.sortTracksByAttributes(attributeNames, ascending);
        }
    }

    public void sortByRegionScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        RegionOfInterest r = region == null ? new RegionOfInterest(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd() + 1, frame.getName()) : region;
        List<String> sortedSamples = this.sortSamplesByRegionScore(r, type, frame);
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.sortByRegionsScore(r, type, frame, sortedSamples);
        }
        this.repaint();
    }

    private List<String> sortSamplesByRegionScore(RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        List<Track> allTracks = this.getAllTracks();
        ArrayList<Track> tracksWithScore = new ArrayList<Track>(allTracks.size());
        for (Track t : allTracks) {
            if (!t.isRegionScoreType(type)) continue;
            tracksWithScore.add(t);
        }
        IGV.sortByRegionScore(tracksWithScore, region, type, frame);
        ArrayList<String> sortedSamples = new ArrayList<String>(tracksWithScore.size());
        for (Track t : tracksWithScore) {
            String att = t.getSample();
            if (att == null) continue;
            sortedSamples.add(att);
        }
        return sortedSamples;
    }

    static void sortByRegionScore(List<Track> tracks, RegionOfInterest region, RegionScoreType type, ReferenceFrame frame) {
        if (tracks != null && region != null && !tracks.isEmpty()) {
            String frameName = frame != null ? frame.getName() : null;
            int tmpzoom = frame != null ? frame.getZoom() : 0;
            int zoom = Math.max(0, tmpzoom);
            String chr = region.getChr();
            int start = region.getStart();
            int end = region.getEnd();
            Comparator c = (t1, t2) -> {
                try {
                    if (t1 == null && t2 == null) {
                        return 0;
                    }
                    if (t1 == null) {
                        return 1;
                    }
                    if (t2 == null) {
                        return -1;
                    }
                    float s1 = t1.getRegionScore(chr, start, end, zoom, type, frameName);
                    float s2 = t2.getRegionScore(chr, start, end, zoom, type, frameName);
                    return Float.compare(s2, s1);
                }
                catch (Exception e) {
                    log.error("Error sorting tracks. Sort might not be accurate.", e);
                    return 0;
                }
            };
            Collections.sort(tracks, c);
        }
    }

    public String getGroupByAttribute() {
        return this.session.getGroupByAttribute();
    }

    public void setGroupByAttribute(String attributeName) {
        this.session.setGroupByAttribute(attributeName);
        this.resetGroups();
    }

    private void resetGroups() {
        log.debug("Resetting Groups");
        for (TrackPanel trackPanel : this.getTrackPanels()) {
            trackPanel.groupTracksByAttribute(this.session.getGroupByAttribute());
        }
        IGVEventBus.getInstance().post(new TrackGroupEvent());
    }

    public Future startUp(Main.IGVArgs igvArgs) {
        if (log.isDebugEnabled()) {
            log.debug("startUp");
        }
        return LongRunningTask.submit(new StartupRunnable(igvArgs));
    }

    public void setRulerEnabled(boolean rulerEnabled) {
        this.rulerEnabled = rulerEnabled;
    }

    public boolean isRulerEnabled() {
        return this.rulerEnabled;
    }

    private static void startCommandsServer(Main.IGVArgs igvArgs, IGVPreferences prefMgr) {
        boolean portEnabled = prefMgr.getAsBoolean("PORT_ENABLED");
        String portString = igvArgs.getPort();
        if (portEnabled || portString != null) {
            int port = prefMgr.getAsInt("PORT_NUMBER");
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            CommandListener.start(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySequenceToClipboard(Genome genome, String chr, int start, int end, Strand strand) {
        try {
            IGV.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            byte[] seqBytes = genome.getSequence(chr, start, end);
            if (seqBytes == null) {
                MessageUtils.showMessage("Sequence not available");
            } else {
                String sequence = new String(seqBytes);
                SequenceTrack sequenceTrack = IGV.getInstance().getSequenceTrack();
                if (strand == Strand.NEGATIVE || sequenceTrack != null && sequenceTrack.getStrand() == Strand.NEGATIVE) {
                    sequence = SequenceTrack.getReverseComplement(sequence);
                }
                StringUtils.copyTextToClipboard(sequence);
            }
        }
        finally {
            IGV.getInstance().getMainFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForNotify(long timeout) {
        boolean completed = false;
        IGV iGV = this;
        synchronized (iGV) {
            if (!completed) {
                try {
                    this.wait(timeout);
                    completed = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return completed;
    }

    public void postEvent(IGVEvent event) {
        IGVEventBus.getInstance().post(event);
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof ViewChange || event instanceof InsertionSelectionEvent) {
            this.repaint();
        } else if (event instanceof GenomeChangeEvent) {
            this.repaint();
        } else {
            log.warn("Unknown event type: " + String.valueOf(event.getClass()));
        }
    }

    public void resetFrames() {
        UIUtilities.invokeOnEventThread(() -> {
            this.getMainPanel().headerPanelContainer.createHeaderPanels();
            for (TrackPanel tp : this.getTrackPanels()) {
                tp.createDataPanels();
            }
            this.contentPane.getCommandBar().setGeneListMode(FrameManager.isGeneListMode());
            this.revalidateTrackPanels();
        });
    }

    public void revalidateTrackPanels() {
        UIUtilities.invokeOnEventThread(() -> {
            this.getMainPanel().revalidateTrackPanels();
            this.repaint(this.rootPane);
        });
    }

    public void repaintNamePanels() {
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.getScrollPane().getNamePanel().repaint();
        }
    }

    public void fitTracksToPanel() {
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.fitTracksToPanel();
        }
        this.repaint();
    }

    public void repaint() {
        this.repaint(this.contentPane);
    }

    public void repaint(Track track) {
        this.repaint(this.contentPane, List.of(track));
    }

    public void repaint(Collection<? extends Track> tracks) {
        this.repaint(this.contentPane, tracks);
    }

    private void repaint(JComponent component) {
        ArrayList<Track> trackList = new ArrayList<Track>();
        for (TrackPanel tp : this.getTrackPanels()) {
            trackList.addAll(this.visibleTracks(tp.getDataPanelContainer()));
        }
        this.repaint(component, trackList);
    }

    private void repaint(JComponent component, Collection<? extends Track> trackList) {
        if (Globals.isBatch()) {
            UIUtilities.invokeAndWaitOnEventThread(() -> {
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    for (ReferenceFrame frame : FrameManager.getFrames()) {
                        for (Track track : trackList) {
                            if (track.isReadyToPaint(frame)) continue;
                            track.load(frame);
                        }
                    }
                    Autoscaler.autoscale(this.getAllTracks());
                    this.checkPanelLayouts();
                    component.paintImmediately(component.getBounds());
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                    IGV iGV = IGV.getInstance();
                    synchronized (iGV) {
                        IGV.getInstance().notifyAll();
                    }
                }
            });
        } else {
            if (this.isLoading) {
                UIUtilities.invokeOnEventThread(() -> this.contentPane.repaint());
                this.pending = trackList;
                return;
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                for (Track track : trackList) {
                    if (track.isReadyToPaint(frame)) continue;
                    futures.add(CompletableFuture.runAsync(() -> track.load(frame), threadExecutor));
                }
            }
            if (futures.size() == 0) {
                UIUtilities.invokeOnEventThread(() -> {
                    Autoscaler.autoscale(this.getAllTracks());
                    this.checkPanelLayouts();
                    component.repaint();
                });
            } else {
                CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[0]);
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                this.isLoading = true;
                CompletableFuture.allOf(futureArray).whenCompleteAsync((ignored, ex) -> {
                    WaitCursorManager.removeWaitCursor(token);
                    this.isLoading = false;
                    if (ex != null) {
                        log.error("Error loading track data", (Throwable)ex);
                        this.pending = null;
                    } else {
                        Autoscaler.autoscale(this.getAllTracks());
                        UIUtilities.invokeOnEventThread(() -> {
                            this.checkPanelLayouts();
                            component.repaint();
                            if (this.pending != null) {
                                Collection<? extends Track> tmp = this.pending;
                                this.pending = null;
                                this.repaint(tmp);
                            }
                        });
                    }
                });
            }
        }
    }

    private void checkPanelLayouts() {
        for (TrackPanel tp : this.getTrackPanels()) {
            if (!tp.isHeightChanged()) continue;
            UIUtilities.invokeOnEventThread(() -> tp.revalidate());
        }
    }

    public List<Track> visibleTracks(DataPanelContainer dataPanelContainer) {
        return dataPanelContainer.getTrackGroups().stream().filter(TrackGroup::isVisible).flatMap(trackGroup -> trackGroup.getVisibleTracks().stream()).collect(Collectors.toList());
    }

    public void stopTimedAutosave() {
        this.sessionAutosaveTimer.cancel();
    }

    static {
        threadExecutor = Executors.newFixedThreadPool(5);
    }

    public class StartupRunnable
    implements Runnable {
        Main.IGVArgs igvArgs;

        StartupRunnable(Main.IGVArgs args) {
            this.igvArgs = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String genomeId;
            boolean runningBatch;
            IGVPreferences preferences = PreferencesManager.getPreferences();
            IGV.startCommandsServer(this.igvArgs, preferences);
            UIUtilities.invokeAndWaitOnEventThread(() -> {
                IGV.this.mainFrame.setIconImage(this.getIconImage());
                if (Globals.IS_MAC) {
                    this.setAppleDockIcon();
                }
                IGV.this.mainFrame.setVisible(true);
            });
            boolean bl = runningBatch = this.igvArgs.getBatchFile() != null;
            if (runningBatch) {
                BatchRunner.setIsBatchMode(true);
                try {
                    UIUtilities.invokeAndWaitOnEventThread(() -> {
                        String genomeId = preferences.getDefaultGenome();
                        BatchRunner batchRunner = new BatchRunner(this.igvArgs.getBatchFile(), IGV.this);
                        batchRunner.runWithDefaultGenome(genomeId);
                    });
                }
                finally {
                    BatchRunner.setIsBatchMode(false);
                }
            }
            boolean autosavePresent = false;
            try {
                autosavePresent = SessionAutosaveManager.getMostRecentAutosaveFile().isPresent();
            }
            catch (Exception e) {
                log.error("Failure trying to get most recent autosave file", e);
            }
            boolean loadAutosave = autosavePresent && PreferencesManager.getPreferences().getAsBoolean("AUTOLOAD_LAST_AUTOSAVE");
            boolean genomeLoaded = false;
            if (this.igvArgs.getGenomeId() != null) {
                genomeId = this.igvArgs.getGenomeId();
                try {
                    genomeLoaded = GenomeManager.getInstance().loadGenomeById(genomeId);
                }
                catch (IOException e) {
                    MessageUtils.showErrorMessage("Error loading genome: " + genomeId, e);
                    log.error("Error loading genome: " + genomeId, e);
                }
            }
            if (this.igvArgs.getSessionFile() == null && !loadAutosave && !genomeLoaded) {
                genomeId = preferences.getDefaultGenome();
                try {
                    genomeLoaded = GenomeManager.getInstance().loadGenomeById(genomeId);
                }
                catch (Exception e) {
                    MessageUtils.showErrorMessage("Error loading genome " + genomeId + "<br/>" + e.getMessage(), e);
                    genomeLoaded = false;
                }
                if (!genomeLoaded) {
                    Genome genome = Genome.NULL_GENOME;
                    GenomeManager.getInstance().setCurrentGenome(genome);
                }
            }
            if (this.igvArgs.getSessionFile() != null || this.igvArgs.getDataFileStrings() != null || loadAutosave) {
                if (log.isDebugEnabled()) {
                    log.debug("Loading session data");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Calling restore session");
                }
                if (this.igvArgs.getSessionFile() != null) {
                    boolean success;
                    IGV.getInstance().setStatusBarMessage3("Loading " + this.igvArgs.getSessionFile());
                    try {
                        success = false;
                        if (HttpUtils.isRemoteURL(this.igvArgs.getSessionFile())) {
                            boolean merge = false;
                            success = IGV.this.loadSession(this.igvArgs.getSessionFile(), this.igvArgs.getLocusString());
                        } else {
                            File sf = new File(this.igvArgs.getSessionFile());
                            if (sf.exists()) {
                                success = IGV.this.loadSession(sf.getAbsolutePath(), this.igvArgs.getLocusString());
                            }
                        }
                    }
                    finally {
                        IGV.getInstance().setStatusBarMessage3("");
                    }
                    if (!success) {
                        String genomeId2 = preferences.getDefaultGenome();
                        try {
                            GenomeManager.getInstance().loadGenomeById(genomeId2);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else if (this.igvArgs.getDataFileStrings() != null) {
                    List<String> dataFiles = this.igvArgs.getDataFileStrings();
                    Collection<String> h = this.igvArgs.getHttpHeader();
                    if (h != null && !h.isEmpty()) {
                        HttpUtils.getInstance().addHeaders(h, dataFiles);
                    }
                    String[] names = null;
                    if (this.igvArgs.getName() != null) {
                        names = this.igvArgs.getName().split(",");
                    }
                    String[] indexFiles = null;
                    if (this.igvArgs.getIndexFile() != null) {
                        indexFiles = this.igvArgs.getIndexFile().split(",");
                    }
                    String[] coverageFiles = null;
                    if (this.igvArgs.getCoverageFile() != null) {
                        coverageFiles = this.igvArgs.getCoverageFile().split(",");
                    }
                    ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
                    for (int i = 0; i < dataFiles.size(); ++i) {
                        String p = dataFiles.get(i).trim();
                        if (URLUtils.isURL(p) && !FileUtils.isRemote(p)) {
                            p = StringUtils.decodeURL(p);
                        }
                        ResourceLocator rl = new ResourceLocator(p);
                        if (names != null && i < names.length) {
                            String name = names[i];
                            rl.setName(name);
                        }
                        if (indexFiles != null && i < indexFiles.length) {
                            String idxP = indexFiles[i];
                            if (URLUtils.isURL(idxP) && !FileUtils.isRemote(idxP)) {
                                idxP = StringUtils.decodeURL(idxP);
                            }
                            if (idxP.length() > 0) {
                                rl.setIndexPath(idxP);
                            }
                        }
                        if (coverageFiles != null && i < coverageFiles.length) {
                            String covP = coverageFiles[i];
                            if (URLUtils.isURL(covP) && !FileUtils.isRemote(covP)) {
                                covP = StringUtils.decodeURL(covP);
                            }
                            if (covP.length() > 0) {
                                rl.setCoverage(covP);
                            }
                        }
                        locators.add(rl);
                    }
                    IGV.this.loadTracks(locators);
                } else if (loadAutosave) {
                    boolean success = false;
                    try {
                        File sessionAutosave = SessionAutosaveManager.getMostRecentAutosaveFile().get();
                        success = IGV.this.loadSession(sessionAutosave.getAbsolutePath(), null);
                    }
                    catch (Exception e) {
                        log.error("Failure trying to load most recent autosave file", e);
                    }
                    if (!success) {
                        String genomeId3 = preferences.getDefaultGenome();
                        try {
                            GenomeManager.getInstance().loadGenomeById(genomeId3);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            UIUtilities.invokeAndWaitOnEventThread(() -> {
                if (this.igvArgs.getLocusString() != null) {
                    IGV.this.goToLocus(this.igvArgs.getLocusString());
                }
            });
            if (this.igvArgs.isMcpMode()) {
                IGVMcpServer.start();
            }
            IGV.this.session.recordHistory();
            IGV iGV = IGV.getInstance();
            synchronized (iGV) {
                IGV.getInstance().notifyAll();
            }
        }

        private void setAppleDockIcon() {
            try {
                Image image = this.getIconImage();
                DesktopIntegration.setDockIcon(image);
            }
            catch (Exception e) {
                log.error("Error setting apple dock icon", e);
            }
        }

        private Image getIconImage() {
            String path = "resources/IGV_64.png";
            URL url = IGV.class.getResource(path);
            Image image = new ImageIcon(url).getImage();
            return image;
        }
    }
}

