/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import org.broad.igv.ui.MenuSelectedListener;

public class DynamicMenuItemsAdjustmentListener<T>
implements MenuSelectedListener {
    private final JMenu menu;
    private final JSeparator insertionPoint;
    private final Collection<T> values;
    private final Function<T, JMenuItem> itemConstructor;
    private final List<JComponent> activeComponents;

    public DynamicMenuItemsAdjustmentListener(JMenu menu, JSeparator insertionPoint, Collection<T> values, Function<T, JMenuItem> itemConstructor) {
        this.menu = menu;
        this.insertionPoint = insertionPoint;
        this.values = values;
        this.itemConstructor = itemConstructor;
        this.activeComponents = new ArrayList<JComponent>();
    }

    private List<JMenuItem> getCurrentItems() {
        return this.values.stream().map(this.itemConstructor).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void menuSelected(MenuEvent e) {
        List<JMenuItem> newComponents = this.getCurrentItems();
        JMenu jMenu = this.menu;
        synchronized (jMenu) {
            this.activeComponents.forEach(this.menu::remove);
            if (newComponents.isEmpty()) {
                this.insertionPoint.setVisible(false);
            } else {
                this.insertionPoint.setVisible(true);
                int componentIndex = Arrays.asList(this.menu.getMenuComponents()).indexOf(this.insertionPoint);
                for (int i = 0; i < newComponents.size(); ++i) {
                    this.menu.insert(newComponents.get(i), componentIndex + i + 1);
                }
                this.activeComponents.addAll(newComponents);
            }
        }
        this.menu.revalidate();
        this.menu.repaint();
    }
}

