/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.hub;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ucsc.hub.HubDescriptor;
import org.broad.igv.ucsc.hub.HubRegistry;
import org.broad.igv.ucsc.hub.HubTable;
import org.broad.igv.ucsc.hub.HubTableModel;

public class HubSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    List<HubDescriptor> hubDescriptors;
    private boolean canceled;
    private JTable table;
    private JTextField filterTextField;

    public HubSelectionDialog(Frame owner) {
        super(owner, "Select Track Hubs", true);
        this.setSize(owner.getWidth() - 20, 600);
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        }
        String genomeID = GenomeManager.getInstance().getCurrentGenome().getUCSCId();
        List<HubDescriptor> allHubDescriptors = HubRegistry.getAllHubsForGenome(genomeID);
        List<HubDescriptor> allSelectedHubs = HubRegistry.getSelectedHubsForGenome(genomeID);
        this.hubDescriptors = allHubDescriptors.stream().filter(hd -> hd.getDbList() != null && hd.getDbList().contains(genomeID)).collect(Collectors.toList());
        if (this.hubDescriptors.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No hubs available");
            return;
        }
        this.initComponents(allSelectedHubs);
    }

    public List<HubDescriptor> getSelectedHubs() {
        return this.hubDescriptors.stream().filter(HubDescriptor::isSelected).collect(Collectors.toList());
    }

    private void initComponents(Collection<HubDescriptor> loadedHubs) {
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        outerPanel.setLayout(new BorderLayout(0, 20));
        this.add(outerPanel);
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BoxLayout(headerPanel, 1));
        JLabel titleLabel = new JLabel("Track hubs for genome: " + GenomeManager.getInstance().getCurrentGenome().getDisplayName());
        titleLabel.setFont(titleLabel.getFont().deriveFont(1, 16.0f));
        headerPanel.add(titleLabel);
        headerPanel.add(Box.createVerticalStrut(20));
        JLabel headerMessage = new JLabel();
        headerMessage.setText("<html>Hubs from the <a href='https://genome.ucsc.edu/cgi-bin/hgHubConnect'>UCSC Track Hub Registry</a>, and user entered urls. Check to add to the 'Track Hubs' menu, uncheck to remove.</html>");
        headerMessage.setCursor(new Cursor(12));
        headerMessage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://genome.ucsc.edu/cgi-bin/hgHubConnect"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(HubSelectionDialog.this, "Unable to open the web browser. Please visit:\nhttps://genome.ucsc.edu/cgi-bin/hgHubConnect", "Error Opening Browser", 0);
                }
            }
        });
        headerPanel.add(headerMessage);
        outerPanel.add((Component)headerPanel, "North");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        outerPanel.add((Component)contentPanel, "Center");
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 0));
        String filterToolTip = "Enter multiple filter strings separated by spaces.";
        JLabel filterLabel = new JLabel("Filter:");
        filterLabel.setLabelFor(this.filterTextField);
        filterLabel.setRequestFocusEnabled(false);
        filterLabel.setToolTipText("Enter multiple filter strings separated by spaces.");
        filterPanel.add(filterLabel);
        this.filterTextField = new JTextField();
        this.filterTextField.setToolTipText("Enter multiple filter strings separated by spaces.");
        this.filterTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.filterTextField.getPreferredSize().height));
        this.filterTextField.setToolTipText("Type keywords to filter the track hubs, e.g. hg38. Use spaces to separate multiple keywords.");
        filterPanel.add(Box.createHorizontalStrut(5));
        filterPanel.add(this.filterTextField);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                HubSelectionDialog.this.updateFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                HubSelectionDialog.this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HubSelectionDialog.this.updateFilter();
            }
        });
        contentPanel.add(filterPanel);
        Set loadedURLs = loadedHubs.stream().map(HubDescriptor::getUrl).collect(Collectors.toSet());
        for (int i = 0; i < this.hubDescriptors.size(); ++i) {
            HubDescriptor hub = this.hubDescriptors.get(i);
            hub.setSelected(loadedURLs.contains(hub.getUrl()));
        }
        HubTableModel model = new HubTableModel(this.hubDescriptors);
        this.table = new HubTable(model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        contentPanel.add(scrollPane);
        JPanel buttonPanel = new JPanel();
        ((FlowLayout)buttonPanel.getLayout()).setAlignment(2);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.canceled = true;
            this.setVisible(false);
            this.dispose();
        });
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            this.canceled = false;
            this.setVisible(false);
            this.dispose();
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        outerPanel.add((Component)buttonPanel, "South");
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void updateFilter() {
        RegexFilter rf = null;
        try {
            rf = new RegexFilter(this.filterTextField.getText());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        ((DefaultRowSorter)this.table.getRowSorter()).setRowFilter(rf);
    }

    private class RegexFilter
    extends RowFilter {
        List<Matcher> matchers;

        RegexFilter(String text) {
            if (text == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matchers = Arrays.stream(Globals.whitespacePattern.split(text)).map(t -> {
                String value = t.trim();
                return Pattern.compile("(?i)" + value).matcher("");
            }).collect(Collectors.toList());
        }

        public boolean include(RowFilter.Entry value) {
            return this.matchers.stream().allMatch(entry -> {
                Matcher matcher = entry;
                return IntStream.range(0, HubSelectionDialog.this.table.getColumnCount()).anyMatch(index -> {
                    matcher.reset(HubSelectionDialog.this.table.getColumnName(index).toLowerCase());
                    if (matcher.find()) {
                        return true;
                    }
                    return matcher.reset(value.getStringValue(index)).find();
                });
            });
        }
    }
}

