/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.hub;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broad.igv.DirectoryManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ucsc.hub.Hub;
import org.broad.igv.ucsc.hub.HubDescriptor;
import org.broad.igv.util.HttpUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class HubRegistry {
    public static final String UCSC_REST_PUBLICHUBS = "https://api.genome.ucsc.edu/list/publicHubs";
    public static final String BACKUP_HUBS_URL = "https://raw.githubusercontent.com/igvteam/igv-genomes/refs/heads/main/hubs/ucsc/publicHubs.json";
    private static Logger log = LogManager.getLogger(HubRegistry.class);
    private static List<HubDescriptor> selectedHubDescriptors = null;
    private static List<HubDescriptor> ucscPublicHubDescriptors = null;
    private static Map<String, List<HubDescriptor>> allHubsMap = null;
    private static Map<String, List<HubDescriptor>> selectedHubsMap = null;

    private HubRegistry() {
    }

    private static List<HubDescriptor> getSelectedHubs() {
        if (selectedHubDescriptors == null) {
            selectedHubDescriptors = HubRegistry.readSelectedHubs();
        }
        return selectedHubDescriptors;
    }

    private static List<HubDescriptor> getUcscPublicHubDescriptors() {
        if (ucscPublicHubDescriptors == null) {
            ucscPublicHubDescriptors = HubRegistry.loadUCSCDescriptors();
        }
        return ucscPublicHubDescriptors;
    }

    public static List<HubDescriptor> getAllHubsForGenome(String ucscID) {
        if (allHubsMap == null) {
            ArrayList<HubDescriptor> allHubDescriptors = new ArrayList<HubDescriptor>(HubRegistry.getUcscPublicHubDescriptors());
            Set existingUrls = allHubDescriptors.stream().map(HubDescriptor::getUrl).collect(Collectors.toSet());
            List hubsToAdd = HubRegistry.getSelectedHubs().stream().filter(hub -> !existingUrls.contains(hub.getUrl())).collect(Collectors.toList());
            allHubDescriptors.addAll(0, hubsToAdd);
            allHubsMap = allHubDescriptors.stream().flatMap(hub -> Arrays.stream(hub.getDbList().split(",")).map(db -> Map.entry(db.trim(), hub))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        }
        return allHubsMap.getOrDefault(ucscID, Collections.emptyList());
    }

    public static List<HubDescriptor> getSelectedHubsForGenome(String ucscID) {
        if (selectedHubsMap == null) {
            selectedHubsMap = HubRegistry.getSelectedHubs().stream().flatMap(hub -> Arrays.stream(hub.getDbList().split(",")).map(db -> Map.entry(db.trim(), hub))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        }
        return selectedHubsMap.getOrDefault(ucscID, Collections.emptyList());
    }

    public static void addUserHub(Hub hub) {
        if (selectedHubDescriptors == null) {
            selectedHubDescriptors = new ArrayList<HubDescriptor>();
        }
        selectedHubDescriptors.add(hub.getDescriptor());
        HubRegistry.writeSelectedHubs();
        selectedHubsMap = null;
        allHubsMap = null;
    }

    public static void setSelectedHubs(List<HubDescriptor> hubDescriptors) {
        selectedHubDescriptors = new ArrayList<HubDescriptor>(hubDescriptors);
        HubRegistry.writeSelectedHubs();
        selectedHubsMap = null;
        allHubsMap = null;
    }

    private static void writeSelectedHubs() {
        File file = new File(DirectoryManager.getIgvDirectory(), "hubs.txt");
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println("hubUrl\tshortLabel\tlongLabel\tdbList\tdescriptionUrl");
            for (HubDescriptor hub : selectedHubDescriptors) {
                writer.printf("%s\t%s\t%s\t%s\t%s%n", hub.getUrl(), hub.getShortLabel(), hub.getLongLabel(), hub.getDbList(), hub.getDescriptionUrl());
            }
        }
        catch (IOException e) {
            log.error("Error writing selected hubs to file", e);
        }
    }

    private static List<HubDescriptor> readSelectedHubs() {
        selectedHubDescriptors = new ArrayList<HubDescriptor>();
        File file = new File(DirectoryManager.getIgvDirectory(), "hubs.txt");
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    String[] fields = line.split("\t");
                    if (fields.length != 5) continue;
                    String url = fields[0];
                    String shortLabel = fields[1];
                    String longLabel = fields[2];
                    String dbList = fields[3];
                    String descriptionUrl = fields[4];
                    selectedHubDescriptors.add(new HubDescriptor(url, shortLabel, longLabel, dbList, descriptionUrl));
                }
            }
            catch (IOException e) {
                log.error("Error reading selected hubs from file", e);
            }
        }
        return selectedHubDescriptors;
    }

    public static List<HubDescriptor> loadUCSCDescriptors() {
        JSONArray hubArray;
        ArrayList<HubDescriptor> hubDescriptors = new ArrayList<HubDescriptor>();
        JSONObject jsonResponse = HubRegistry.fetchJsonResponse(UCSC_REST_PUBLICHUBS, BACKUP_HUBS_URL);
        if (jsonResponse != null && (hubArray = jsonResponse.optJSONArray("publicHubs")) != null) {
            for (int i = 0; i < hubArray.length(); ++i) {
                JSONObject hub = hubArray.getJSONObject(i);
                hubDescriptors.add(new HubDescriptor(hub.optString("hubUrl"), hub.optString("shortLabel"), hub.optString("longLabel"), hub.optString("dbList"), hub.optString("descriptionUrl")));
            }
        }
        return hubDescriptors;
    }

    private static JSONObject fetchJsonResponse(String primaryUrl, String backupUrl) {
        try {
            String jsonString = HttpUtils.getInstance().getContentsAsJSON(new URL(primaryUrl));
            return new JSONObject(jsonString);
        }
        catch (Exception e) {
            log.error("Failed to load public hub list from " + primaryUrl, e);
            try {
                String jsonString = HttpUtils.getInstance().getContentsAsJSON(new URL(backupUrl));
                return new JSONObject(jsonString);
            }
            catch (IOException ex) {
                log.error("Failed to load public hub list from " + backupUrl, ex);
                return null;
            }
        }
    }
}

