/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broad.igv.Globals;
import org.broad.igv.feature.Locus;
import org.broad.igv.util.HttpUtils;
import org.json.JSONObject;

public class SearchAPI {
    public static List<Locus> search(String searchTerm, String genome) throws IOException {
        List<String> positions = SearchAPI.searchIGV(searchTerm, genome);
        return SearchAPI.mergeOverlaps(positions);
    }

    private static List<String> searchIGV(String str, String genomeID) throws IOException {
        String tmp = "https://igv.org/genomes/locus.php?genome=$GENOME$&name=$FEATURE$";
        if (genomeID != null && genomeID.indexOf("/") < 0 && genomeID.indexOf("\\") < 0) {
            URL url = new URL(tmp.replace("$GENOME$", genomeID).replace("$FEATURE$", str));
            String r = HttpUtils.getInstance().getContentsAsString(url);
            return List.of(Globals.whitespacePattern.split(r));
        }
        return null;
    }

    private static List<String> searchUCSC(String searchTerm, String genome) throws IOException {
        String url = "https://api.genome.ucsc.edu/search?search=" + searchTerm + "&genome=" + genome;
        String response = HttpUtils.getInstance().getContentsAsString(new URL(url));
        JSONObject json = new JSONObject(response);
        return SearchAPI.reduceSearchResults(json.toMap(), searchTerm);
    }

    public static List<String> reduceSearchResults(Map<String, Object> searchResults, String searchTerm) {
        ArrayList<String> reducedResults = new ArrayList<String>();
        List results = (List)searchResults.get("positionMatches");
        if (results != null) {
            for (Map result : results) {
                List matches = (List)result.get("matches");
                if (matches == null) continue;
                for (Map match : matches) {
                    if (!searchTerm.equalsIgnoreCase(match.get("posName").toString())) continue;
                    reducedResults.add(match.get("position").toString());
                }
            }
        }
        return reducedResults;
    }

    private static List<Locus> mergeOverlaps(List<String> positions) {
        List loci = positions.stream().map(p -> Locus.fromString(p)).filter(locus -> locus != null).collect(Collectors.toList());
        loci.sort((a, b) -> {
            int chrComparison = a.getChr().compareTo(b.getChr());
            return chrComparison != 0 ? chrComparison : Integer.compare(a.getStart(), b.getStart());
        });
        ArrayList<Locus> mergedLoci = new ArrayList<Locus>();
        for (Locus locus2 : loci) {
            if (!mergedLoci.isEmpty() && ((Locus)mergedLoci.get(mergedLoci.size() - 1)).overlaps(locus2)) {
                ((Locus)mergedLoci.get(mergedLoci.size() - 1)).merge(locus2);
                continue;
            }
            mergedLoci.add(locus2);
        }
        return mergedLoci;
    }

    public static void main(String[] args) throws IOException {
        String searchTerm = "PKD1";
        String genome = "hg38";
        List<Locus> results = SearchAPI.search(searchTerm, genome);
        for (Locus result : results) {
            System.out.println(result);
        }
    }
}

