/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.ucsc.BPIndex;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;
import org.broad.igv.ucsc.twobit.UnsignedByteBufferImpl;

public class BPTree
implements BPIndex {
    static int SIGNATURE = 2026540177;
    String path;
    SeekableStream stream;
    private long fileOffset;
    ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    Map<Long, Node> nodeCache;
    int blockSize;
    int keySize;
    int valSize;
    public long itemCount;
    long reserved;
    long nodeOffset;

    public static BPTree loadBPTree(String path, long fileOffset) throws IOException {
        return new BPTree(path, fileOffset);
    }

    public BPTree(String path, long fileOffset) throws IOException {
        this.path = path;
        this.fileOffset = fileOffset;
        this.nodeCache = new HashMap<Long, Node>();
        this.init();
    }

    public BPTree(SeekableStream stream, long fileOffset) throws IOException {
        this.stream = stream;
        this.fileOffset = fileOffset;
        this.nodeCache = new HashMap<Long, Node>();
        this.init();
    }

    UnsignedByteBuffer loadBinaryBuffer(long start, int size) throws IOException {
        return this.stream != null ? UnsignedByteBufferImpl.getUnsignedByteBuffer(this.stream, this.byteOrder, start, size) : UnsignedByteBufferImpl.loadBinaryBuffer(this.path, this.byteOrder, start, size);
    }

    private void init() throws IOException {
        long filePosition = this.fileOffset;
        UnsignedByteBuffer buffer = this.loadBinaryBuffer(filePosition, 64);
        int magicNumber = buffer.getInt();
        if (SIGNATURE != magicNumber) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            buffer = this.loadBinaryBuffer(0L, 64);
            magicNumber = buffer.getInt();
            if (SIGNATURE != magicNumber) {
                throw new RuntimeException("Unexpected magic number");
            }
        }
        this.blockSize = buffer.getInt();
        this.keySize = buffer.getInt();
        this.valSize = buffer.getInt();
        if (this.valSize != 16 && this.valSize != 8) {
            throw new RuntimeException("Unexpected valSiz: " + this.valSize);
        }
        this.itemCount = buffer.getLong();
        this.reserved = buffer.getLong();
        this.nodeOffset = this.fileOffset + 32L;
    }

    private byte[] search(String term) throws IOException {
        return this.walkTreeNode(this.nodeOffset, term);
    }

    @Override
    public long searchForOffset(String term) throws IOException {
        byte[] bytes = this.search(term);
        if (bytes != null) {
            return this.bytesToLong(bytes, 0);
        }
        return -1L;
    }

    public long[] searchLongLong(String term) throws IOException {
        byte[] bytes = this.search(term);
        if (bytes != null) {
            long offset = this.bytesToLong(bytes, 0);
            long size = this.bytesToLong(bytes, 8);
            return new long[]{offset, size};
        }
        return null;
    }

    public int[] searchIntInt(String term) throws IOException {
        byte[] bytes = this.search(term);
        if (bytes != null) {
            int offset = this.bytesToInt(bytes, 0);
            int size = this.bytesToInt(bytes, 4);
            return new int[]{offset, size};
        }
        return null;
    }

    public Node readTreeNode(long offset) throws IOException {
        if (this.nodeCache.containsKey(offset)) {
            return this.nodeCache.get(offset);
        }
        UnsignedByteBuffer buffer = this.loadBinaryBuffer(offset, 4);
        byte type = buffer.get();
        byte reserved = buffer.get();
        int count = buffer.getUShort();
        ArrayList<Item> items = new ArrayList<Item>();
        if (type == 1) {
            size = count * (this.keySize + this.valSize);
            buffer = this.loadBinaryBuffer(offset + 4L, size);
            for (int i = 0; i < count; ++i) {
                String key = buffer.getFixedLengthString(this.keySize);
                byte[] value = buffer.getBytes(this.valSize);
                items.add(new Item(key, value));
            }
        } else {
            size = count * (this.keySize + 8);
            buffer = this.loadBinaryBuffer(offset + 4L, size);
            for (int i = 0; i < count; ++i) {
                String key = buffer.getFixedLengthString(this.keySize);
                long childOffset = buffer.getLong();
                items.add(new Item(key, childOffset));
            }
        }
        Node node = new Node(this, type, count, items);
        this.nodeCache.put(offset, node);
        return node;
    }

    byte[] walkTreeNode(long offset, String term) throws IOException {
        String key;
        Node node = this.readTreeNode(offset);
        if (node.type == 1) {
            for (Item item : node.items) {
                if (!term.equals(item.key)) continue;
                return item.value;
            }
            return null;
        }
        long childOffset = node.items.get((int)0).offset;
        for (int i = 1; i < node.items.size() && term.compareTo(key = node.items.get((int)i).key) >= 0; ++i) {
            childOffset = node.items.get((int)i).offset;
        }
        return this.walkTreeNode(childOffset, term);
    }

    private long bytesToLong(byte[] bytes, int start) {
        long value = 0L;
        int length = Math.min(bytes.length, 8);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = start; i < start + length; ++i) {
                value <<= 8;
                value |= (long)(bytes[i] & 0xFF);
            }
        } else {
            for (int i = start + length - 1; i >= start; --i) {
                value <<= 8;
                value |= (long)(bytes[i] & 0xFF);
            }
        }
        return value;
    }

    private int bytesToInt(byte[] bytes, int start) {
        int value = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = start; i < start + 4; ++i) {
                value <<= 8;
                value |= bytes[i] & 0xFF;
            }
        } else {
            for (int i = start + 4 - 1; i >= start; --i) {
                value <<= 8;
                value |= bytes[i] & 0xFF;
            }
        }
        return value;
    }

    public class Node {
        public int type;
        int count;
        public List<Item> items;

        public Node(BPTree this$0, int type, int count, List<Item> items) {
            this.type = type;
            this.count = count;
            this.items = items;
        }
    }

    public class Item {
        String key;
        byte[] value;
        public long offset;

        public Item(String key, long offset) {
            this.key = key;
            this.offset = offset;
        }

        public Item(String key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public int[] getValueAsInts() {
            if (this.value != null) {
                int offset = BPTree.this.bytesToInt(this.value, 0);
                int size = BPTree.this.bytesToInt(this.value, 4);
                return new int[]{offset, size};
            }
            return null;
        }
    }
}

