/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.converters;

import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class GFFtoBed {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File inputFile, File outputFile) {
        GFFParser parser = new GFFParser();
        BufferedReader reader = null;
        PrintWriter pw = null;
        try {
            GFFCodec.Version version = inputFile.getPath().endsWith(".gff3") ? GFFCodec.Version.GFF3 : GFFCodec.Version.GFF2;
            GFFCodec gffCodec = new GFFCodec(version, null, null);
            reader = ParsingUtils.openBufferedReader(new ResourceLocator(inputFile.getAbsolutePath()));
            List<Feature> features = parser.loadFeatures(reader, null, gffCodec);
            IGVBEDCodec codec = new IGVBEDCodec();
            codec.setGffTags(true);
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            pw.println("#gffTags");
            for (Feature feature : features) {
                BasicFeature bf = (BasicFeature)feature;
                String line = codec.encode(bf);
                pw.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        File gffFile = new File("/Users/jrobinso/projects/igv-js/igv/assets/hg19/gencode.v18.transcripts.patched_contigs.gtf");
        File bedFile = new File("/Users/jrobinso/projects/igv-js/igv/assets/hg19/gencode.v18.transcripts.patched_contigs.bed");
        GFFtoBed.convert(gffFile, bedFile);
    }
}

