/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.math3.stat.StatUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.SbxUtils;
import org.broad.igv.util.collections.DoubleArrayList;

public class ReadStats {
    private static int MAX_READ_COUNT = 100000;
    public int readCount = 0;
    private int indelCount = 0;
    private int nCount = 0;
    private DoubleArrayList readLengths = new DoubleArrayList(10000);
    private DoubleArrayList refToReadRatios = new DoubleArrayList(10000);
    private Set<Integer> qualityScores = new HashSet<Integer>();
    public double medianReadLength = 0.0;
    public double readLengthStdDev = 0.0;
    public double medianRefToReadRatio = 0.0;
    public double fracReadsWithIndels;
    public double fracReadsWithNs;
    public double averageCigarLength;
    private static final Random RAND = new Random();

    public void addAlignment(Alignment alignment) {
        if (this.readCount > MAX_READ_COUNT) {
            return;
        }
        if (alignment.isMapped()) {
            ++this.readCount;
            int readLength = alignment.getReadSequence().length();
            char[] cigarString = alignment.getCigarString().toCharArray();
            this.readLengths.add(readLength);
            if (this.containsChar(cigarString, 'N')) {
                ++this.nCount;
                this.refToReadRatios.add((double)(alignment.getAlignmentEnd() - alignment.getAlignmentStart()) / (double)readLength);
            }
            if (this.containsChar(cigarString, 'D') || this.containsChar(cigarString, 'I')) {
                ++this.indelCount;
            }
            double cigarLength = alignment.getCigarString().length();
            this.averageCigarLength = this.averageCigarLength * (((double)this.readCount - 1.0) / (double)this.readCount) + cigarLength / (double)this.readCount;
        }
        for (AlignmentBlock ab : alignment.getAlignmentBlocks()) {
            if (!ab.hasQualities()) continue;
            for (int i = 0; i < ab.getLength(); ++i) {
                this.qualityScores.add(Integer.valueOf(ab.getQuality(i)));
            }
        }
    }

    public void compute() {
        if (this.readLengths.size() > 0) {
            double[] downsampled = this.downsample(this.readLengths, 10000);
            this.medianReadLength = StatUtils.percentile((double[])downsampled, (double)50.0);
            this.readLengthStdDev = Math.sqrt(StatUtils.variance((double[])downsampled));
        }
        if (this.refToReadRatios.size() > 0) {
            this.medianRefToReadRatio = StatUtils.percentile((double[])this.downsample(this.refToReadRatios, 10000), (double)50.0);
        }
        this.fracReadsWithIndels = (double)this.indelCount / (double)this.readCount;
        this.fracReadsWithNs = (double)this.nCount / (double)this.readCount;
    }

    private boolean containsChar(char[] charArray, char c) {
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != c) continue;
            return true;
        }
        return false;
    }

    private double[] downsample(DoubleArrayList list, int size) {
        if (list.size() < size) {
            return list.toArray();
        }
        double[] ds = list.toArray(0, size);
        for (int i = size; i < list.size(); ++i) {
            double samplingProb = (double)size / (double)(size + (i - size) + 1);
            if (!(RAND.nextDouble() < samplingProb)) continue;
            int idx = (int)(RAND.nextDouble() * (double)(size - 1));
            ds[idx] = list.get(i);
        }
        return ds;
    }

    public AlignmentTrack.ExperimentType inferType() {
        if (this.qualityScores.size() > 0 && SbxUtils.isSBXAlignments(this.qualityScores)) {
            return AlignmentTrack.ExperimentType.SBX;
        }
        this.compute();
        if (this.readCount < 20) {
            return AlignmentTrack.ExperimentType.UNKOWN;
        }
        if (this.medianRefToReadRatio > 5.0 || this.fracReadsWithNs > 0.01) {
            return AlignmentTrack.ExperimentType.RNA;
        }
        if ((this.readLengthStdDev > 100.0 || this.medianReadLength > 1000.0) && this.averageCigarLength > 10.0) {
            return AlignmentTrack.ExperimentType.THIRD_GEN;
        }
        return AlignmentTrack.ExperimentType.OTHER;
    }
}

