/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.apache.commons.math3.stat.StatUtils;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.util.collections.DownsampledDoubleArrayList;

public class PEStats {
    private static Logger log = LogManager.getLogger(PEStats.class);
    String library;
    private static final int MAX = 1000;
    private DownsampledDoubleArrayList insertSizes;
    private int minThreshold = 10;
    private int maxThreshold = 5000;
    int frCount = 0;
    int rfCount = 0;
    int f1f2Count = 0;
    int f2f1Count = 0;
    int totalCount = 0;
    Orientation orientation = Orientation.FR;
    private static final int minOutlierInsertSizePercentile = 95;
    private static final int maxOutlierInsertSizePercentile = 5;
    private int minOutlierInsertSize = this.minThreshold;
    private int maxOutlierInsertSize = this.maxThreshold;

    public PEStats(String library) {
        this.library = library;
        this.insertSizes = new DownsampledDoubleArrayList(100, 1000);
    }

    public void update(Alignment alignment) {
        if (alignment.isProperPair()) {
            this.insertSizes.add(Math.abs(alignment.getInferredInsertSize()));
            String po = alignment.getPairOrientation();
            if (po != null && po.length() == 4) {
                if (po.charAt(0) == 'F') {
                    if (po.charAt(2) == 'F') {
                        if (po.charAt(1) == '1') {
                            ++this.f1f2Count;
                        } else {
                            ++this.f2f1Count;
                        }
                    } else if (po.charAt(2) == 'R') {
                        ++this.frCount;
                    }
                } else if (po.charAt(0) == 'R') {
                    if (po.charAt(2) == 'F') {
                        ++this.rfCount;
                    } else if (po.charAt(2) == 'R') {
                        if (po.charAt(1) == '1') {
                            ++this.f2f1Count;
                        } else {
                            ++this.f1f2Count;
                        }
                    }
                }
            }
            ++this.totalCount;
        }
    }

    public void computeInsertSize(double minPercentile, double maxPercentile) {
        if (this.insertSizes.size() > 100) {
            this.minThreshold = this.computePercentile(minPercentile);
            this.maxThreshold = this.computePercentile(maxPercentile);
            this.minOutlierInsertSize = this.computePercentile(95.0);
            this.maxOutlierInsertSize = this.computePercentile(5.0);
        }
    }

    public int getMinThreshold() {
        return this.minThreshold;
    }

    public int getMaxThreshold() {
        return this.maxThreshold;
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.computeExpectedOrientation();
        }
        return this.orientation;
    }

    public void computeExpectedOrientation() {
        int ffCount;
        this.orientation = this.totalCount > 100 ? ((ffCount = this.f1f2Count + this.f2f1Count) > this.frCount && ffCount > this.rfCount ? (this.f1f2Count > this.f2f1Count ? Orientation.F1F2 : Orientation.F2F1) : (this.rfCount > this.frCount && this.rfCount > ffCount ? Orientation.RF : Orientation.FR)) : Orientation.FR;
    }

    private int computePercentile(double percentile) {
        return (int)StatUtils.percentile((double[])this.insertSizes.toArray(), (int)0, (int)this.insertSizes.size(), (double)percentile);
    }

    int getMinOutlierInsertSize() {
        return this.minOutlierInsertSize;
    }

    int getMaxOutlierInsertSize() {
        return this.maxOutlierInsertSize;
    }

    public static enum Orientation {
        FR,
        RF,
        F1F2,
        F2F1;

    }
}

