/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.List;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.mcp.McpTools;

public class IGVMcpServer {
    static Logger log = LogManager.getLogger(IGVMcpServer.class);

    public static void main(String[] args) {
        IGVMcpServer.start();
    }

    public static void start() {
        log.info("Starting IGV MCP Server");
        StdioServerTransportProvider transportProvider = new StdioServerTransportProvider((McpJsonMapper)new JacksonMcpJsonMapper(new ObjectMapper()));
        List<McpTools.ToolDescriptor> tools = McpTools.getTools();
        McpServer.SyncSpecification serverSpecification = McpServer.sync((McpServerTransportProvider)transportProvider).serverInfo("igv-mcp", "1.0.0");
        for (McpTools.ToolDescriptor td : tools) {
            serverSpecification = serverSpecification.tool(td.tool(), td.handler());
        }
        McpSyncServer server = serverSpecification.build();
        Thread shutdownHook = new Thread(() -> {
            log.info("Shutting down IGV MCP Server ...");
            server.close();
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }
}

