/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.gwas.GWASData;
import org.broad.igv.gwas.GWASFeature;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ChromosomeColors;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GWASTrack
extends AbstractTrack {
    private static final Logger log = LogManager.getLogger(GWASTrack.class);
    private static final int AXIS_AREA_WIDTH = 60;
    private static final DecimalFormat formatter = new DecimalFormat();
    private int minPointSize;
    private int maxPointSize;
    private boolean useChrColors;
    private boolean singleColor;
    private boolean alternatingColors;
    private Color primaryColor;
    private Color secondaryColor;
    private double maxY;
    private boolean drawYAxis = true;
    private boolean showAxis = true;
    double maxValue = -1.0;
    private GWASData gData;
    Genome genome;
    private String[] columns;
    private Pattern delimiter;
    IGV igv;

    public GWASTrack(ResourceLocator locator, String id, String name, GWASData gData, String[] columns, Pattern delimiter, Genome genome) {
        super(locator, id, name);
        this.delimiter = delimiter;
        this.genome = genome;
        this.igv = IGV.getInstance();
        IGVPreferences prefs = PreferencesManager.getPreferences();
        float maxValue = Math.min(25.0f, (float)Math.ceil(gData.getMaxValue()));
        float minValue = (float)Math.floor(gData.getMinValue());
        super.setDataRange(new DataRange(minValue, maxValue));
        super.setHeight(prefs.getAsInt("GWAS_TRACK_HEIGHT"));
        this.minPointSize = prefs.getAsInt("GWAS_MIN_POINT_SIZE");
        this.maxPointSize = prefs.getAsInt("GWAS_MAX_POINT_SIZE");
        this.primaryColor = ColorUtilities.stringToColor(prefs.get("GWAS_PRIMARY_COLOR"));
        this.secondaryColor = ColorUtilities.stringToColor(prefs.get("GWAS_SECONDARY_COLOR"));
        this.singleColor = prefs.getAsBoolean("GWAS_SINGLE_COLOR");
        this.alternatingColors = prefs.getAsBoolean("GWAS_ALTERNATING_COLORS");
        this.useChrColors = prefs.getAsBoolean("GWAS_USE_CHR_COLORS");
        this.showAxis = prefs.getAsBoolean("GWAS_SHOW_AXIS");
        this.gData = gData;
        this.columns = columns;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return true;
    }

    @Override
    public void load(ReferenceFrame frame) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RenderContext context, Rectangle rect) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Graphics2D g = null;
        try {
            g = (Graphics2D)context.getGraphics().create();
            g.setClip(rect);
            Rectangle plotRect = this.calculateDrawingRect(rect);
            DataRange dataRange = this.getDataRange();
            float maxValue = dataRange.getMaximum();
            float minValue = dataRange.getMinimum();
            double pointSizeScaleFactor = (double)(this.maxPointSize - this.minPointSize) / (double)(maxValue - minValue);
            String chrName = context.getChr();
            List<String> chrList = chrName.equals("All") ? genome.getLongChromosomeNames() : Arrays.asList(chrName);
            Color drawColor = this.primaryColor;
            int chrCounter = 0;
            for (String chr : chrList) {
                List<GWASFeature> featureList = this.gData.get(chr);
                if (featureList != null) {
                    if (this.useChrColors) {
                        drawColor = ChromosomeColors.getColor(chr);
                    } else if (this.alternatingColors) {
                        drawColor = chrCounter % 2 == 0 ? this.secondaryColor : this.primaryColor;
                    }
                    for (GWASFeature feature : featureList) {
                        int start = chrName.equalsIgnoreCase("all") ? genome.getGenomeCoordinate(feature.chr, feature.position) - 1 : feature.position - 1;
                        double dataY = feature.value;
                        if (Double.isNaN(dataY)) continue;
                        int pixelSize = Math.min(this.maxPointSize, this.minPointSize + (int)(pointSizeScaleFactor * (dataY - (double)minValue)));
                        int x = (int)(((double)start - origin + 0.5) / locScale) - pixelSize / 2;
                        int y = this.computeYPixelValue(plotRect, this.dataRange, dataY) - pixelSize / 2;
                        g.setColor(drawColor);
                        g.fillOval(x, y, pixelSize, pixelSize);
                        feature.pixelX = x;
                        feature.pixelY = y;
                        feature.pixelSize = pixelSize;
                    }
                }
                ++chrCounter;
            }
            if (this.showAxis) {
                this.renderAxis(context, plotRect);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderAxis(RenderContext context, Rectangle plotRect) {
        Graphics2D g = null;
        try {
            g = (Graphics2D)context.getGraphics().create();
            g.setColor(Color.black);
            g.setFont(FontManager.getFont(11));
            Rectangle axisRect = new Rectangle(plotRect.x, plotRect.y + 1, 60, plotRect.height);
            DataRange axisDefinition = this.getDataRange();
            float maxValue = axisDefinition.getMaximum();
            float minValue = axisDefinition.getMinimum();
            int pY = this.computeYPixelValue(plotRect, axisDefinition, minValue);
            g.drawLine(axisRect.x + 60 - 10, pY, axisRect.x + 60 - 5, pY);
            GraphicUtils.drawRightJustifiedText(formatter.format(minValue), axisRect.x + 60 - 15, pY, g);
            int topPY = this.computeYPixelValue(plotRect, axisDefinition, maxValue);
            g.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 5, topPY);
            GraphicUtils.drawRightJustifiedText(formatter.format(maxValue), axisRect.x + 60 - 15, topPY + 4, g);
            g.drawLine(axisRect.x + 60 - 10, topPY, axisRect.x + 60 - 10, pY);
            int lastY = pY;
            for (int i = (int)minValue + 1; i < (int)maxValue; ++i) {
                int midPY = this.computeYPixelValue(plotRect, axisDefinition, i);
                if (midPY >= lastY - 15 || midPY >= pY - 15 || midPY <= topPY + 15) continue;
                g.drawLine(axisRect.x + 60 - 10, midPY, axisRect.x + 60 - 5, midPY);
                GraphicUtils.drawRightJustifiedText(formatter.format(i), axisRect.x + 60 - 15, midPY + 4, g);
                lastY = midPY;
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    int computeYPixelValue(Rectangle drawingRect, DataRange axisDefinition, double dataY) {
        double maxValue = axisDefinition.getMaximum();
        double minValue = axisDefinition.getMinimum();
        double yScaleFactor = drawingRect.getHeight() / (maxValue - minValue);
        double delta = (maxValue - dataY) * yScaleFactor;
        double pY = drawingRect.getY() + delta;
        return (int)Math.max(drawingRect.getMinY(), Math.min(drawingRect.getMaxY(), pY));
    }

    Rectangle calculateDrawingRect(Rectangle arect) {
        double buffer = Math.min(arect.getHeight() * 0.2, 10.0);
        Rectangle adjustedRect = new Rectangle(arect);
        adjustedRect.y = (int)(arect.getY() + buffer);
        adjustedRect.height = (int)((double)arect.height - ((double)adjustedRect.y - arect.getY()));
        return adjustedRect;
    }

    GWASFeature findFeature(String chr, int mouseX, int mouseY) {
        Set<String> chromosomes = "all".equalsIgnoreCase(chr) ? this.gData.keySet() : Arrays.asList(chr);
        ArrayList<GWASFeature> closeFeatures = new ArrayList<GWASFeature>();
        for (String c : chromosomes) {
            List<GWASFeature> chrFeatures = this.gData.get(c);
            for (GWASFeature f : chrFeatures) {
                int pixelSize = Math.max(3, f.pixelSize);
                if (Math.abs(mouseX - f.pixelX) > pixelSize || Math.abs(mouseY - f.pixelY) > pixelSize) continue;
                closeFeatures.add(f);
            }
        }
        if (closeFeatures.isEmpty()) {
            return null;
        }
        if (closeFeatures.size() == 1) {
            return (GWASFeature)closeFeatures.get(0);
        }
        closeFeatures.sort((o1, o2) -> {
            double d2;
            double d1 = Math.sqrt((mouseX - o1.pixelX) * (mouseX - o1.pixelX) + (mouseY - o1.pixelY) * (mouseY - o1.pixelY));
            if (d1 == (d2 = Math.sqrt((mouseX - o2.pixelX) * (mouseX - o2.pixelX) + (mouseY - o2.pixelY) * (mouseY - o2.pixelY)))) {
                return 0;
            }
            if (d1 > d2) {
                return 1;
            }
            return -1;
        });
        return (GWASFeature)closeFeatures.get(0);
    }

    public String getDescriptionString(GWASFeature feature) {
        String description = feature.line;
        Object descriptionString = null;
        if (description != null) {
            descriptionString = "";
            int headersSize = this.columns.length;
            String[] tokens = this.delimiter.split(description);
            for (int i = 0; i < headersSize; ++i) {
                String tmpHeaderToken = this.columns[i];
                if (tmpHeaderToken == null) continue;
                descriptionString = (String)descriptionString + tmpHeaderToken + ": " + tokens[i] + "<br>";
            }
        }
        return descriptionString;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        GWASFeature feature = this.findFeature(chr, mouseX, mouseY);
        return feature != null ? this.getDescriptionString(feature) : null;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        popupMenu.add(popupTitle);
        ArrayList<Track> tmpTracks = new ArrayList<Track>();
        tmpTracks.add(this);
        popupMenu.addSeparator();
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmpTracks));
        popupMenu.addSeparator();
        popupMenu.add(TrackMenuUtils.getDataRangeItem(tmpTracks));
        popupMenu.add(TrackMenuUtils.getChangeTrackHeightItem(tmpTracks));
        popupMenu.addSeparator();
        popupMenu.add(new JLabel("Color scheme", 2));
        popupMenu.add(this.addChrColorItem(popupMenu));
        popupMenu.add(this.addSingleColorItem(popupMenu));
        popupMenu.add(this.addAlternatingColorItem(popupMenu));
        popupMenu.addSeparator();
        popupMenu.add(this.addPrimaryColorItem(popupMenu));
        popupMenu.add(this.addSecondaryColorItem(popupMenu));
        popupMenu.addSeparator();
        popupMenu.add(this.addMinPointSizeItem(popupMenu));
        popupMenu.add(this.addMaxPointSizeItem(popupMenu));
        popupMenu.addSeparator();
        this.addShowAxisItem(popupMenu);
        return popupMenu;
    }

    public JMenuItem addShowAxisItem(JPopupMenu menu) {
        JCheckBoxMenuItem axisItem = new JCheckBoxMenuItem("Show axis");
        axisItem.setSelected(this.showAxis);
        axisItem.addActionListener(e -> {
            this.showAxis = axisItem.isSelected();
            PreferencesManager.getPreferences().put("GWAS_SHOW_AXIS", String.valueOf(this.showAxis));
            this.repaint();
        });
        menu.add(axisItem);
        return axisItem;
    }

    public JMenuItem addChrColorItem(JPopupMenu menu) {
        JCheckBoxMenuItem colorItem = new JCheckBoxMenuItem("Chromosome color", this.useChrColors);
        colorItem.addActionListener(e -> {
            this.singleColor = false;
            this.useChrColors = true;
            this.alternatingColors = false;
            this.updateColorPreferences();
            this.repaint();
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addAlternatingColorItem(JPopupMenu menu) {
        JCheckBoxMenuItem colorItem = new JCheckBoxMenuItem("Alternating color", this.alternatingColors);
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.singleColor = false;
                GWASTrack.this.useChrColors = false;
                GWASTrack.this.alternatingColors = true;
                GWASTrack.this.updateColorPreferences();
                GWASTrack.this.repaint();
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addSingleColorItem(JPopupMenu menu) {
        JCheckBoxMenuItem colorItem = new JCheckBoxMenuItem("Single color", this.singleColor);
        colorItem.addActionListener(e -> {
            this.singleColor = true;
            this.useChrColors = false;
            this.alternatingColors = false;
            this.updateColorPreferences();
            this.repaint();
        });
        menu.add(colorItem);
        return colorItem;
    }

    private void updateColorPreferences() {
        PreferencesManager.getPreferences().put("GWAS_SINGLE_COLOR", String.valueOf(this.singleColor));
        PreferencesManager.getPreferences().put("GWAS_USE_CHR_COLORS", String.valueOf(this.useChrColors));
        PreferencesManager.getPreferences().put("GWAS_ALTERNATING_COLORS", String.valueOf(this.alternatingColors));
    }

    public JMenuItem addPrimaryColorItem(JPopupMenu menu) {
        JMenuItem colorItem = new JMenuItem("Set primary color...");
        colorItem.addActionListener(e -> {
            Color color = UIUtilities.showColorChooserDialog("Set primary color", this.primaryColor);
            if (color != null) {
                this.primaryColor = color;
                String colorString = ColorUtilities.colorToString(this.primaryColor);
                PreferencesManager.getPreferences().put("GWAS_PRIMARY_COLOR", colorString);
                this.repaint();
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addSecondaryColorItem(JPopupMenu menu) {
        JMenuItem colorItem = new JMenuItem("Set alternating color...");
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = UIUtilities.showColorChooserDialog("Set alternating color", GWASTrack.this.secondaryColor);
                if (color != null) {
                    GWASTrack.this.secondaryColor = color;
                    String colorString = ColorUtilities.colorToString(GWASTrack.this.secondaryColor);
                    PreferencesManager.getPreferences().put("GWAS_SECONDARY_COLOR", colorString);
                    GWASTrack.this.repaint();
                }
            }
        });
        menu.add(colorItem);
        return colorItem;
    }

    public JMenuItem addMinPointSizeItem(JPopupMenu menu) {
        JMenuItem menuItem = new JMenuItem("Set minimum point size...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.changeMinPointSizeValue();
            }
        });
        menu.add(menuItem);
        return menuItem;
    }

    public JMenuItem addMaxPointSizeItem(JPopupMenu menu) {
        JMenuItem menuItem = new JMenuItem("Set maximum point size...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GWASTrack.this.changeMaxPointSizeValue();
            }
        });
        menu.add(menuItem);
        return menuItem;
    }

    private void changeMinPointSizeValue() {
        int value = this.minPointSize;
        String tmpValue = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), "Minimum point size in pixels (1-20):", String.valueOf(value));
        if (tmpValue != null || !tmpValue.trim().equals("")) {
            try {
                value = Integer.parseInt(tmpValue);
                if (value < 1 || value > 20) {
                    JOptionPane.showMessageDialog(IGV.getInstance().getMainFrame(), "Minimum point size must be an integer number between 1 and 20.");
                } else {
                    if (value > this.maxPointSize) {
                        this.maxPointSize = value;
                    }
                    this.minPointSize = value;
                    this.updatePointSizePreferences();
                    this.repaint();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getInstance().getMainFrame(), "Point size must be an integer number.");
            }
        }
    }

    private void changeMaxPointSizeValue() {
        int value = this.maxPointSize;
        String tmpValue = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), "Maximum point size in pixels (1-20):", String.valueOf(value));
        if (tmpValue != null || !tmpValue.trim().equals("")) {
            try {
                value = Integer.parseInt(tmpValue);
                if (value < 1 || value > 20) {
                    JOptionPane.showMessageDialog(IGV.getInstance().getMainFrame(), "Maximum point size must be an integer number between 1 and 20.");
                } else {
                    if (value < this.minPointSize) {
                        this.minPointSize = value;
                    }
                    this.maxPointSize = value;
                    this.updatePointSizePreferences();
                    this.repaint();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getInstance().getMainFrame(), "Point size must be an integer number.");
            }
        }
    }

    private void updatePointSizePreferences() {
        PreferencesManager.getPreferences().put("GWAS_MIN_POINT_SIZE", String.valueOf(this.minPointSize));
        PreferencesManager.getPreferences().put("GWAS_MAX_POINT_SIZE", String.valueOf(this.maxPointSize));
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("maxPointSize", String.valueOf(this.maxPointSize));
        element.setAttribute("minPointSize", String.valueOf(this.minPointSize));
        element.setAttribute("useChrColors", String.valueOf(this.useChrColors));
        element.setAttribute("singleColor", String.valueOf(this.singleColor));
        element.setAttribute("showAxis", String.valueOf(this.showAxis));
        element.setAttribute("alternatingColors", String.valueOf(this.alternatingColors));
        if (this.primaryColor != null) {
            element.setAttribute("primaryColor", ColorUtilities.colorToString(this.primaryColor));
        }
        if (this.secondaryColor != null) {
            element.setAttribute("secondaryColor", ColorUtilities.colorToString(this.secondaryColor));
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        this.maxPointSize = Integer.parseInt(element.getAttribute("maxPointSize"));
        this.minPointSize = Integer.parseInt(element.getAttribute("minPointSize"));
        this.useChrColors = Boolean.parseBoolean(element.getAttribute("useChrColors"));
        this.singleColor = Boolean.parseBoolean(element.getAttribute("singleColor"));
        this.showAxis = Boolean.parseBoolean(element.getAttribute("showAxis")) || Boolean.parseBoolean(element.getAttribute("drawYAxis"));
        this.alternatingColors = Boolean.parseBoolean(element.getAttribute("alternatingColors"));
        if (element.hasAttribute("primaryColor")) {
            this.primaryColor = ColorUtilities.stringToColor(element.getAttribute("primaryColor"));
        }
        if (element.hasAttribute("secondaryColor ")) {
            this.secondaryColor = ColorUtilities.stringToColor(element.getAttribute("secondaryColor"));
        }
    }
}

