/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.tribble.IGVFeatureReader;

public class TribbleReaderWrapper
implements IGVFeatureReader {
    FeatureReader<Feature> wrappedReader;

    public TribbleReaderWrapper(FeatureReader<Feature> wrappedReader) {
        this.wrappedReader = wrappedReader;
    }

    @Override
    public synchronized Iterator<Feature> query(String chr, int start, int end) throws IOException {
        try (CloseableTribbleIterator iter = this.wrappedReader.query(chr, start + 1, end);){
            Feature f;
            ArrayList<Feature> featureList = new ArrayList<Feature>();
            while (iter.hasNext() && (f = (Feature)iter.next()).getStart() <= end) {
                if (f.getEnd() < start) continue;
                featureList.add(f);
            }
            Iterator<Feature> iterator = featureList.iterator();
            return iterator;
        }
    }

    @Override
    public CloseableIterator<Feature> iterator() throws IOException {
        return this.wrappedReader.iterator();
    }

    @Override
    public List<String> getSequenceNames() {
        return this.wrappedReader.getSequenceNames();
    }

    @Override
    public Object getHeader() {
        return this.wrappedReader.getHeader();
    }
}

