/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.fasta;

import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.util.LittleEndianInputStream;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class FastaBlockCompressedSequence
extends FastaIndexedSequence {
    Mapping[] gziMappings;
    Mapping zeroMapping = new Mapping(0L, 0L);

    public FastaBlockCompressedSequence(String path) throws IOException {
        this(path, null, null);
    }

    public FastaBlockCompressedSequence(String path, String gziIndexPath, String indexPath) throws IOException {
        super(path, indexPath);
        if (gziIndexPath == null) {
            gziIndexPath = path + ".gzi";
        }
        this.readGziMappings((String)gziIndexPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBytes(long posStart, long posEnd) throws IOException {
        Mapping m1 = this.findBlockContaining(posStart);
        int d1 = (int)(posStart - m1.uncompressedOffset);
        long vp1 = m1.compressedOffset << 16 | (long)d1;
        try (SeekableBufferedStream ss = null;){
            int nBytes = (int)(posEnd - posStart);
            int bufferSize = Math.max(512000, nBytes / 8);
            ss = new SeekableBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(this.path), bufferSize);
            BlockCompressedInputStream bis = new BlockCompressedInputStream((SeekableStream)ss);
            byte[] bytes = new byte[nBytes];
            bis.seek(vp1);
            this.readFully(bytes, (InputStream)bis);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    protected Mapping findBlockContaining(long uoffset) {
        int ilo = 0;
        int ihi = this.gziMappings.length - 1;
        while (ilo <= ihi) {
            int i = (ilo + ihi) / 2;
            Mapping mapping = this.gziMappings[i];
            if (uoffset < mapping.uncompressedOffset) {
                ihi = i - 1;
                continue;
            }
            if (uoffset < mapping.uncompressedOffset) break;
            ilo = i + 1;
        }
        return ilo == 0 ? this.zeroMapping : this.gziMappings[ilo - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGziMappings(String gziPath) throws IOException {
        LittleEndianInputStream dis = null;
        try (InputStream is = null;){
            is = ParsingUtils.openInputStream(gziPath);
            dis = new LittleEndianInputStream(new BufferedInputStream(is));
            int nEntries = (int)dis.readLong();
            this.gziMappings = new Mapping[nEntries];
            for (int i = 0; i < nEntries; ++i) {
                this.gziMappings[i] = new Mapping(dis.readLong(), dis.readLong());
            }
        }
    }

    private void readFully(byte[] b, InputStream is) throws IOException {
        int count;
        int len = b.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = is.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static class Mapping {
        long compressedOffset;
        long uncompressedOffset;

        public Mapping(long compressedOffset, long uncompressedOffset) {
            this.compressedOffset = compressedOffset;
            this.uncompressedOffset = uncompressedOffset;
        }
    }
}

