/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.encode;

import com.jidesoft.swing.JideBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.NumberFormatter;
import org.broad.igv.Globals;
import org.broad.igv.encode.FileRecord;
import org.broad.igv.encode.TrackChooserModel;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGVDialog;
import org.broad.igv.util.Pair;

public class TrackChooser
extends IGVDialog {
    private static Logger log = LogManager.getLogger(TrackChooser.class);
    private static NumberFormatter numberFormatter = new NumberFormatter();
    JTable table;
    JTextField filterTextField;
    JLabel rowCountLabel;
    TrackChooserModel model;
    private boolean canceled;

    public TrackChooser(Frame owner, List<String> headings, List<FileRecord> rows, String title) {
        super(owner);
        this.setTitle(title);
        this.setModal(true);
        this.model = new TrackChooserModel(headings, rows);
        this.initComponents(owner, this.model);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.model.updateSelections();
        }
        super.setVisible(b);
    }

    private void updateFilter() {
        RegexFilter rf = null;
        try {
            rf = new RegexFilter(this.filterTextField.getText());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.model.getSorter().setRowFilter(rf);
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException e) {
            log.error("Error parsing row count", e);
        }
    }

    private void loadButtonActionPerformed(ActionEvent e) {
        this.canceled = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<FileRecord> getSelectedRecords() {
        return this.model.getRecords().stream().filter(record -> record.isSelected()).collect(Collectors.toUnmodifiableList());
    }

    public List<FileRecord> getAllRecords() {
        return this.model.getRecords();
    }

    private JTable createTable(TrackChooserModel model) {
        this.table = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                if (realColumnIndex > 0) {
                    Object value = TrackChooser.this.table.getValueAt(rowIndex, realColumnIndex);
                    return value == null ? "" : value.toString();
                }
                return null;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return this.table.getColumnName(realIndex);
                    }
                };
            }
        };
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(model);
        this.table.setRowSorter(model.getSorter());
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException e) {
            log.error("Error parsing row count", e);
        }
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        TableColumn selectColumn = this.table.getColumnModel().getColumn(0);
        selectColumn.setPreferredWidth(25);
        selectColumn.setMaxWidth(30);
        this.table.addMouseListener(new MouseAdapter(this){
            private int anchorRow = -1;

            @Override
            public void mousePressed(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                int viewRow = table.rowAtPoint(e.getPoint());
                int viewCol = table.columnAtPoint(e.getPoint());
                if (viewCol != 0 || viewRow == -1) {
                    return;
                }
                e.consume();
                TrackChooserModel model = (TrackChooserModel)table.getModel();
                int modelRow = table.convertRowIndexToModel(viewRow);
                if (e.isShiftDown() && this.anchorRow != -1) {
                    int modelAnchorRow = table.convertRowIndexToModel(this.anchorRow);
                    boolean isSelected = (Boolean)model.getValueAt(modelAnchorRow, 0);
                    int startViewRow = Math.min(this.anchorRow, viewRow);
                    int endViewRow = Math.max(this.anchorRow, viewRow);
                    for (int i = startViewRow; i <= endViewRow; ++i) {
                        int r = table.convertRowIndexToModel(i);
                        model.setValueAt(isSelected, r, 0);
                    }
                } else {
                    this.anchorRow = viewRow;
                    boolean isSelected = (Boolean)model.getValueAt(modelRow, 0);
                    model.setValueAt(!isSelected, modelRow, 0);
                }
            }
        });
        return this.table;
    }

    private void initComponents(Frame owner, TrackChooserModel model) {
        this.rowCountLabel = new JLabel();
        this.table = this.createTable(model);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel dialogPane = new JPanel();
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(0, 10));
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setViewportView(this.table);
        contentPanel.add((Component)scrollPane1, "Center");
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout((LayoutManager)new JideBoxLayout((Container)filterPanel, 0, 5));
        JLabel filterLabel = new JLabel("Filter:");
        String filterToolTip = "Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq";
        filterLabel.setToolTipText("Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq");
        filterPanel.add((Component)filterLabel, "fix");
        this.filterTextField = new JTextField();
        this.filterTextField.setToolTipText("Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq");
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TrackChooser.this.updateFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TrackChooser.this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TrackChooser.this.updateFilter();
            }
        });
        filterPanel.add((Component)this.filterTextField, "vary");
        this.rowCountLabel.setHorizontalAlignment(4);
        JPanel rowCountPanel = new JPanel();
        rowCountPanel.setLayout((LayoutManager)new JideBoxLayout((Container)rowCountPanel, 0, 0));
        rowCountPanel.setPreferredSize(new Dimension(100, 28));
        rowCountPanel.add((Component)this.rowCountLabel, "vary");
        filterPanel.add((Component)rowCountPanel, "fix");
        contentPanel.add((Component)filterPanel, "North");
        dialogPane.add((Component)contentPanel, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        JButton okButton = new JButton("OK");
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(e -> this.loadButtonActionPerformed(e));
        buttonBar.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        buttonBar.add((Component)cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
        int width = owner != null ? owner.getWidth() : 600;
        this.setSize(width, 620);
        this.setLocationRelativeTo(this.getOwner());
    }

    private class RegexFilter
    extends RowFilter {
        List<Pair<String, Matcher>> matchers;

        RegexFilter(String text) {
            String[] tokens;
            if (text == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matchers = new ArrayList<Pair<String, Matcher>>();
            for (String t : tokens = Globals.whitespacePattern.split(text)) {
                String column = "*";
                String value = t.trim();
                if (t.contains("=")) {
                    String[] kv = Globals.equalPattern.split(t);
                    if (kv.length > 1) {
                        column = kv[0].trim();
                        value = kv[1].trim();
                    } else {
                        value = kv[0];
                    }
                }
                this.matchers.add(new Pair<String, Matcher>(column, Pattern.compile("(?i)" + value).matcher("")));
            }
        }

        public boolean include(RowFilter.Entry value) {
            for (Pair<String, Matcher> entry : this.matchers) {
                String column = entry.getFirst();
                Matcher matcher = entry.getSecond();
                boolean found = false;
                int nColumns = TrackChooser.this.table.getColumnCount();
                for (int index = 1; index < nColumns; ++index) {
                    matcher.reset(TrackChooser.this.table.getColumnName(index).toLowerCase());
                    if (matcher.find()) {
                        found = true;
                        break;
                    }
                    boolean wildcard = column.equals("*");
                    if (!wildcard && !column.equalsIgnoreCase(TrackChooser.this.table.getColumnName(index))) continue;
                    matcher.reset(value.getStringValue(index));
                    if (!matcher.find()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

