/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;

public enum VCFHeaderVersion {
    VCF3_2("VCRv3.2", "format"),
    VCF3_3("VCFv3.3", "fileformat"),
    VCF4_0("VCFv4.0", "fileformat"),
    VCF4_1("VCFv4.1", "fileformat"),
    VCF4_2("VCFv4.2", "fileformat"),
    VCF4_3("VCFv4.3", "fileformat"),
    VCF4_4("VCFv4.4", "fileformat");

    private final String versionString;
    private final String formatString;

    private VCFHeaderVersion(String vString, String fString) {
        this.versionString = vString;
        this.formatString = fString;
    }

    public static VCFHeaderVersion toHeaderVersion(String version) {
        version = VCFHeaderVersion.clean(version);
        for (VCFHeaderVersion hv : VCFHeaderVersion.values()) {
            if (!hv.versionString.equals(version)) continue;
            return hv;
        }
        return null;
    }

    public static boolean isVersionString(String version) {
        return VCFHeaderVersion.toHeaderVersion(version) != null;
    }

    public static boolean isFormatString(String format) {
        format = VCFHeaderVersion.clean(format);
        for (VCFHeaderVersion hv : VCFHeaderVersion.values()) {
            if (!hv.formatString.equals(format)) continue;
            return true;
        }
        return false;
    }

    public static VCFHeaderVersion getHeaderVersion(String versionLine) {
        String[] lineFields = versionLine.split("=");
        if (lineFields.length != 2 || !VCFHeaderVersion.isFormatString(lineFields[0].substring(2))) {
            throw new TribbleException.InvalidHeader(versionLine + " is not a valid VCF version line");
        }
        if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
            throw new TribbleException.InvalidHeader(lineFields[1] + " is not a supported version");
        }
        return VCFHeaderVersion.toHeaderVersion(lineFields[1]);
    }

    private static String clean(String s) {
        return s.trim();
    }

    public boolean isAtLeastAsRecentAs(VCFHeaderVersion target) {
        return this.ordinal() >= target.ordinal();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getFormatString() {
        return this.formatString;
    }
}

